/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.otherstruct.OtherStructService;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.opplugin.web.structproject.validator.VirtualOrgDetailSaveValidator;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

public class VirtualOrgDetailSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new VirtualOrgDetailSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject currentDy = e.getDataEntities()[0];
        DynamicObject structProjectDy = currentDy.getDynamicObject("structproject");
        ArrayList<OtherStructVO> list = new ArrayList<OtherStructVO>();
        QFilter structProjectQf = new QFilter("structproject", "=", (Object)structProjectDy.getLong("id"));
        QFilter adminorgQf = new QFilter("adminorg", "=", (Object)currentDy.getLong("id"));
        QFilter currentVersionQf = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginal("id,parentorg.id,adminorg.establishmentdate", new QFilter[]{structProjectQf, adminorgQf, currentVersionQf});
        Long parentOrgId = dynamicObjects[0].getLong("parentorg.id");
        int establishmentdate = dynamicObjects[0].getDate("adminorg.establishmentdate").compareTo(currentDy.getDate("establishmentdate"));
        if (parentOrgId.equals(0L)) {
            currentDy.set("struct_parent_org.id", (Object)0L);
        }
        if (!parentOrgId.equals(currentDy.getLong("struct_parent_org.id")) || establishmentdate != 0) {
            list.add(new OtherStructVO(Long.valueOf(currentDy.getLong("id")), ChangeTransactionConstants.PARENT, Long.valueOf(currentDy.getLong("struct_parent_org.id"))));
        }
        OtherStructEntity otherStructEntity = new OtherStructEntity(list);
        otherStructEntity.setStructProjectId(Long.valueOf(structProjectDy.getLong("id")));
        otherStructEntity.setEnable(structProjectDy.getString("enable"));
        if (!HRStringUtils.equals((String)structProjectDy.getString("enable"), (String)"10")) {
            otherStructEntity.setDeleteFlag(Boolean.FALSE);
            otherStructEntity.setEffectDate(HRDateTimeUtils.getNowDate());
        } else {
            otherStructEntity.setDeleteAll(Boolean.FALSE);
            otherStructEntity.setEffectDate(structProjectDy.getDate("effdt"));
        }
        OtherStructService otherStructService = new OtherStructService(otherStructEntity);
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_virtualorg");
        DynamicObject orgDy = new DynamicObject((DynamicObjectType)dynamicObjectType);
        orgDy.set("orgid", (Object)currentDy.getLong("id"));
        orgDy.set("number", currentDy.get("number"));
        orgDy.set("name", currentDy.get("name"));
        orgDy.set("description", currentDy.get("description"));
        orgDy.set("org", currentDy.get("org"));
        otherStructEntity.setDyList((List)Lists.newArrayList((Object[])new DynamicObject[]{orgDy}));
        otherStructService.saveOtherStruct();
    }
}

