/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject.validator;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedStructResult;

public class OtherStructProjectPermValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(OtherStructProjectPermValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        long structId = dataEntities[0].getDataEntity().getLong("id");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_structure");
        DynamicObject structure = helper.queryOne("org, creator, id, enable", new QFilter("id", "=", (Object)structId));
        String enable = structure.getString("enable");
        long bu = structure.getLong("org.id");
        long createorId = structure.getLong("creator.id");
        long currUserId = RequestContext.get().getCurrUserId();
        HasPermOrgResult hrPermOrg = OrgPermHelper.getHRPermOrg((boolean)true);
        List hasPermOrgs = hrPermOrg.getHasPermOrgs();
        if ((hrPermOrg.hasAllOrgPerm() || hasPermOrgs.contains(bu)) && SystemParamHelper.getCreatorHasPermission((Long)bu) && currUserId == createorId) {
            return;
        }
        AuthorizedStructResult permResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjectsF7", (Object[])new Object[]{currUserId, "217WYC/L9U7E", "haos_structure", "47150e89000000ac", "rootorg", null});
        if (permResult == null) {
            this.addErrorMessage(enable);
            return;
        }
        if (permResult.isHasAllStruct()) {
            return;
        }
        List authorizedStructs = permResult.getAuthorizedStructs();
        if (!CollectionUtils.isEmpty((Collection)authorizedStructs) && authorizedStructs.contains(structId)) {
            return;
        }
        this.addErrorMessage(enable);
    }

    private void addErrorMessage(String enable) {
        if (enable.equals("10")) {
            this.addFatalErrorMessage(this.dataEntities[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67b6\u6784\u672a\u542f\u7528\u3002\u8bf7\u5148\u542f\u7528\u67b6\u6784\u5e76\u5206\u914d\u8be5\u67b6\u6784\u7684\u6743\u9650\u518d\u8fdb\u884c\u7ef4\u62a4\u3002", (String)"OtherStructProjectPermValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), this.dataEntities[0].getDataEntity().getString("number")));
        } else {
            this.addFatalErrorMessage(this.dataEntities[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67b6\u6784\u65b9\u6848\u201c %s \u201d\u67b6\u6784\u7ef4\u62a4\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u6743\u9650\u7ba1\u7406\u5458\u5206\u914d\u540e\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"OtherStructProjectPermValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]), this.dataEntities[0].getDataEntity().getString("number")));
        }
    }
}

