/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.structproject.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.EnabledLang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.servicehelper.VirtualOrgHelper;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class VirtualOrgDetailSaveValidator
extends AbstractValidator {
    private LocaleStringComparator localeStringComparator;

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            ArrayList<String> errorMsgList = new ArrayList<String>();
            this.checkName(errorMsgList, dataEntity.getDataEntity());
            long structProjectId = dataEntity.getDataEntity().getDynamicObject("structproject").getLong("id");
            this.checkNumber(errorMsgList, dataEntity.getDataEntity(), structProjectId);
            this.checkBsed(errorMsgList, dataEntity.getDataEntity());
            this.checkParentOrg(errorMsgList, dataEntity.getDataEntity());
            if (CollectionUtils.isEmpty(errorMsgList)) continue;
            for (String errorMsg : errorMsgList) {
                this.addErrorMessage(dataEntity, errorMsg);
            }
        }
    }

    private void checkName(List<String> errorMsgList, DynamicObject currentDy) {
        ILocaleString localeString = currentDy.getLocaleString("name");
        List enabledLangList = this.getLocaleStringComparator().getEnabledLangList();
        PatternUtil patternUtil = new PatternUtil();
        NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();
        for (EnabledLang enabledLang : enabledLangList) {
            String name = (String)localeString.get((Object)enabledLang.getNumber());
            if (!HRStringUtils.isNotEmpty((String)name) || !patternUtil.validName4Config(name)) continue;
            String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c{0}\u201d\u540d\u79f0\u201c{1}\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26({2})\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[]{enabledLang.getName(), name, nameSeparatorTipsUtil.getAllSeparator()});
            errorMsgList.add(message);
        }
    }

    private void checkNumber(List<String> errorMsgList, DynamicObject currentDy, Long structProjectId) {
        Set set;
        String number = currentDy.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        String message = ResManager.loadKDString((String)"\u6709\u76f8\u540c\u7ec4\u7ec7\u7f16\u7801\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgDetailSaveValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        QFilter dataStatusQf = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
        QFilter enableQf = new QFilter("enable", "=", (Object)"1");
        QFilter structProjectQf = new QFilter("structproject", "=", (Object)structProjectId);
        QFilter orgQf = new QFilter("adminorg", "!=", (Object)currentDy.getLong("id"));
        QFilter currentVersionQf = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter numberQf = new QFilter("adminorg.number", "=", (Object)currentDy.getString("number"));
        DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginal("id", new QFilter[]{dataStatusQf, enableQf, structProjectQf, orgQf, currentVersionQf, numberQf});
        if (dynamicObjects.length > 0) {
            errorMsgList.add(message);
            return;
        }
        Set<String> numberSet = Collections.singleton(number);
        Set<Long> idSet = Collections.singleton(currentDy.getLong("id"));
        DynamicObjectCollection dyCol = AdOrgRepository.getInstance().queryColByNumber("number", numberSet, idSet);
        if (!CollectionUtils.isEmpty((Collection)dyCol)) {
            errorMsgList.add(message);
        }
        if (!CollectionUtils.isEmpty((Collection)(set = VirtualOrgHelper.checkProcessNumber(numberSet)))) {
            String processMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u7ec4\u7ec7\u8c03\u6574\u5355\u636e\u201c{0}\u201d\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[]{set.stream().findFirst().orElse(null)});
            errorMsgList.add(processMsg);
        }
    }

    private void checkBsed(List<String> errorMsgList, DynamicObject currentDy) {
        DynamicObject structProjectDy = currentDy.getDynamicObject("structproject");
        if (HRStringUtils.equals((String)"1", (String)structProjectDy.getString("enable"))) {
            QFilter structProjectQf = new QFilter("structproject", "=", (Object)structProjectDy.getLong("id"));
            QFilter adminorgQf = new QFilter("adminorg", "=", (Object)currentDy.getLong("id"));
            QFilter currentVersionQf = new QFilter("iscurrentversion", "=", (Object)"1");
            DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginal("id,firstbsed", new QFilter[]{structProjectQf, adminorgQf, currentVersionQf});
            if (dynamicObjects.length > 0 && currentDy.getDate("bsed").before(dynamicObjects[0].getDate("firstbsed"))) {
                errorMsgList.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u201c{0}\u201d/\u201c{1}\u201d\u9996\u6b21\u52a0\u5165\u8be5\u67b6\u6784\u7684\u65e5\u671f\u201c{2}\u201d\u3002", (String)"VirtualOrgDetailSaveValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[]{currentDy.getString("number"), currentDy.getString("name"), HRDateTimeUtils.format((Date)dynamicObjects[0].getDate("firstbsed"), (String)"yyyy-MM-dd")}));
            }
        }
    }

    private void checkParentOrg(List<String> errorMsgList, DynamicObject currentDy) {
        DynamicObject structProjectDy = currentDy.getDynamicObject("structproject");
        QFilter structProjectQf = new QFilter("structproject", "=", (Object)structProjectDy.getLong("id"));
        Long adminorgid = currentDy.getLong("id");
        QFilter adminorgQf = new QFilter("adminorg", "=", (Object)adminorgid);
        QFilter currentVersionQf = new QFilter("iscurrentversion", "=", (Object)"1");
        Long rootOrgId = structProjectDy.getLong("rootorg.id");
        if (rootOrgId.equals(adminorgid)) {
            return;
        }
        if (currentDy.getDynamicObject("struct_parent_org") == null) {
            return;
        }
        Long parentorgid = currentDy.getLong("struct_parent_org.id");
        if (parentorgid.equals(adminorgid)) {
            errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgDetailSaveValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[]{currentDy.getString("number")}));
            return;
        }
        DynamicObject[] orgStructDy = AdminOrgStructRepository.getInstance().queryOriginal("id,structlongnumber", new QFilter[]{structProjectQf, adminorgQf, currentVersionQf});
        QFilter parentQf = new QFilter("adminorg", "=", (Object)parentorgid);
        DynamicObject[] parentStructDy = AdminOrgStructRepository.getInstance().queryOriginal("id,structlongnumber", new QFilter[]{structProjectQf, parentQf, currentVersionQf});
        String orgStructLongNumber = orgStructDy[0].getString("structlongnumber");
        String parentStructLongNumber = parentStructDy[0].getString("structlongnumber");
        if (parentStructLongNumber.startsWith(orgStructLongNumber)) {
            errorMsgList.add(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u81ea\u5df1\u6216\u81ea\u5df1\u7684\u4e0b\u7ea7\u7ec4\u7ec7\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgDetailSaveValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[]{currentDy.getString("number")}));
        }
    }

    private LocaleStringComparator getLocaleStringComparator() {
        if (this.localeStringComparator == null) {
            this.localeStringComparator = new LocaleStringComparator();
        }
        return this.localeStringComparator;
    }
}

