/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminorgtypeValidator
extends AbstractValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey)) {
            this.saveValidate();
        } else if (HRStringUtils.equals((String)"enable", (String)operateKey)) {
            this.enableValidate();
        }
    }

    private void saveValidate() {
        List<String> names = Arrays.asList(this.dataEntities).stream().map(item -> item.getDataEntity().getString("name")).collect(Collectors.toList());
        List<String> groupkeys = this.getEnableGroupkeyByNames(names);
        if (groupkeys != null && groupkeys.size() > 0) {
            for (ExtendedDataEntity entity : this.dataEntities) {
                String groupKey = AdminorgtypeValidator.fetchGroupKey(entity.getDataEntity());
                boolean isExit = this.isExitEntityById(entity.getDataEntity().getLong("id"));
                if (isExit || !groupkeys.contains(groupKey)) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBaseDataCheckValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void enableValidate() {
        List objList = Arrays.asList(this.dataEntities).stream().filter(item -> HRStringUtils.equals((String)"0", (String)item.getDataEntity().getString("enable"))).map(item -> item.getDataEntity()).collect(Collectors.toList());
        List<Long> ids = objList.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        Map<Long, String> disableMap = this.getGroupkeyMapByIds(ids);
        List<String> repeatKeys = this.getRepeatKey(disableMap);
        List<String> cnames = objList.stream().map(item -> item.getString("name")).distinct().collect(Collectors.toList());
        List<String> enableGroupkey = this.getEnableGroupkeyByNames(cnames);
        for (ExtendedDataEntity entity : this.dataEntities) {
            Long qid = entity.getDataEntity().getLong("id");
            if (!ids.contains(qid)) continue;
            String groupKey = disableMap.get(qid);
            if ((repeatKeys == null || repeatKeys.size() <= 0 || !repeatKeys.contains(groupKey)) && (enableGroupkey == null || enableGroupkey.size() <= 0 || !enableGroupkey.contains(groupKey))) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBaseDataCheckValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean isExitEntityById(long id) {
        QFilter fieldFilter = new QFilter("id", "=", (Object)id);
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)"id", (QFilter[])new QFilter[]{fieldFilter});
        return !CollectionUtils.isEmpty((Collection)objColl);
    }

    private List<String> getRepeatKey(Map<Long, String> disableMap) {
        Map<String, Long> valueGroup = disableMap.entrySet().stream().collect(Collectors.groupingBy(item -> (String)item.getValue(), Collectors.counting()));
        return valueGroup.keySet().stream().filter(key -> (Long)valueGroup.get(key) > 1L).collect(Collectors.toList());
    }

    private Map<Long, String> getGroupkeyMapByIds(List<Long> ids) {
        QFilter fieldFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)"id,name,adminorgtypestd.id", (QFilter[])new QFilter[]{fieldFilter});
        return objColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> AdminorgtypeValidator.fetchGroupKey(item)));
    }

    private List<String> getEnableGroupkeyByNames(List<String> names) {
        QFilter fieldFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("name", "in", names));
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)"name,adminorgtypestd.id", (QFilter[])new QFilter[]{fieldFilter});
        return objColl.stream().map(item -> AdminorgtypeValidator.fetchGroupKey(item)).collect(Collectors.toList());
    }

    private static String fetchGroupKey(DynamicObject relation) {
        return relation.getString("name") + "_" + relation.getString("adminorgtypestd.id");
    }
}

