/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.validate;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgDataBaseWithTeamValidator
extends AbstractValidator {
    private static String OTCLASSIFY = "otclassify";

    public void validate() {
        String operateKey = this.getOperateKey();
        if (!HRStringUtils.equals((String)"delete", (String)operateKey)) {
            this.saveAndEnableValidate(operateKey);
        }
    }

    private void saveAndEnableValidate(String operateKey) {
        List<DynamicObject> objList = Arrays.asList(this.dataEntities).stream().map(item -> item.getDataEntity()).collect(Collectors.toList());
        Map<String, List<DynamicObject>> nameMapList = objList.stream().collect(Collectors.groupingBy(item -> item.getString("name")));
        Map<String, List<DynamicObject>> nameMap = this.getNameMap(objList);
        boolean isEnable = HRStringUtils.equals((String)"enable", (String)operateKey);
        String errorMsg = isEnable ? ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u6570\u636e\uff0c\u4e0d\u80fd\u542f\u7528\u3002", (String)"OrgBaseDataCheckValidator_1", (String)"hrmp-haos-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OrgBaseDataCheckValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity entity : this.dataEntities) {
            List<DynamicObject> list;
            List sameList;
            DynamicObject obj = entity.getDataEntity();
            String enable = obj.getString("enable");
            if (isEnable && HRStringUtils.equals((String)enable, (String)"1")) continue;
            String name = obj.getString("name");
            String orgTeamType = obj.getString(OTCLASSIFY);
            if (nameMapList.containsKey(name) && (sameList = (list = nameMapList.get(name)).stream().filter(item -> HRStringUtils.equals((String)orgTeamType, (String)item.getString(OTCLASSIFY))).collect(Collectors.toList())).size() > 1) {
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            if (!nameMap.containsKey(name)) continue;
            list = nameMap.get(name);
            long id = obj.getLong("id");
            boolean isExist = list.stream().anyMatch(item -> HRStringUtils.equals((String)orgTeamType, (String)item.getString(OTCLASSIFY)) && id != item.getLong("id"));
            if (!isExist) continue;
            this.addErrorMessage(entity, errorMsg);
        }
    }

    private Map<String, List<DynamicObject>> getNameMap(List<DynamicObject> objList) {
        List nameList = objList.stream().map(item -> item.getString("name")).collect(Collectors.toList());
        QFilter fieldFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("name", "in", nameList));
        DynamicObjectCollection objColl = QueryServiceHelper.query((String)this.entityKey, (String)"id,name,number,otclassify", (QFilter[])new QFilter[]{fieldFilter});
        Map<String, List<DynamicObject>> nameMap = objColl != null && objColl.size() > 0 ? objColl.stream().collect(Collectors.groupingBy(item -> item.getString("name"))) : new HashMap<String, List<DynamicObject>>();
        return nameMap;
    }
}

