/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.opplugin.web.validate;

import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class OtherStructValidator
extends AbstractValidator {
    private final List<OtherStructVO> otherStructList;

    public OtherStructValidator(List<OtherStructVO> otherStructList) {
        this.otherStructList = otherStructList;
    }

    public void validate() {
        ExtendedDataEntity entity = this.getDataEntities()[0];
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObject structProjectDy = dataEntity.getDynamicObject("structproject");
        Date effectDate = dataEntity.getDate("bsed");
        String enable = structProjectDy.getString("enable");
        Date structProjectEffDate = structProjectDy.getDate("effdt");
        if (effectDate.compareTo(structProjectEffDate) < 0) {
            String effDateMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u77e9\u9635\u67b6\u6784\u7684\u751f\u6548\u65e5\u671f\u201c%s\u201d\u3002", (String)"OtherStructValidator_3", (String)"hrmp-haos-opplugin", (Object[])new Object[]{HRDateTimeUtils.formatDate((Date)structProjectEffDate)});
            this.addFatalErrorMessage(entity, effDateMsg);
        }
        if ("10".equals(enable)) {
            if (CollectionUtils.isEmpty(this.otherStructList)) {
                String errorMsg = ResManager.loadKDString((String)"\u67b6\u6784\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u7ec4\u7ec7\u3002", (String)"OtherStructValidator_2", (String)"hrmp-haos-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(entity, errorMsg);
                return;
            }
            return;
        }
        Set orgSet = this.otherStructList.stream().filter(otherStructVO -> !ChangeTransactionConstants.ADD.equals(otherStructVO.getChangeTypeId())).map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject("adminorg.name,firstbsed", orgSet, Long.valueOf(structProjectDy.getLong("id")));
        col.stream().filter(dy -> effectDate.compareTo(dy.getDate("firstbsed")) < 0).findFirst().ifPresent(structDy -> {
            String errorMsg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u8be5\u7ec4\u7ec7\u9996\u6b21\u52a0\u5165\u8be5\u67b6\u6784\u7684\u65e5\u671f\u201c%s\u201d\u3002", (String)"OtherStructValidator_0", (String)"hrmp-haos-opplugin", (Object[])new Object[]{HRDateTimeUtils.formatDate((Date)structDy.getDate("firstbsed"))});
            this.addFatalErrorMessage(entity, errorMsg);
        });
    }
}

