/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.model;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import kd.hr.haos.common.model.MainPersonModel;

public class DateRangeModel {
    private ZonedDateTime startDate;
    private ZonedDateTime endDate;
    private List<MainPersonModel> mainPersonModelList = new ArrayList<MainPersonModel>();

    public DateRangeModel() {
    }

    public DateRangeModel(ZonedDateTime startDate, ZonedDateTime endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public ZonedDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ZonedDateTime startDate) {
        this.startDate = startDate;
    }

    public ZonedDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(ZonedDateTime endDate) {
        this.endDate = endDate;
    }

    public List<MainPersonModel> getMainPersonModelList() {
        return this.mainPersonModelList;
    }

    public void setMainPersonModelList(List<MainPersonModel> mainPersonModelList) {
        this.mainPersonModelList = mainPersonModelList;
    }

    public static Comparator<DateRangeModel> getDateComparator() {
        StartDateComparator startDateComparator = new StartDateComparator();
        EndDateComparator endDateComparator = new EndDateComparator();
        return startDateComparator.thenComparing(endDateComparator);
    }

    public boolean isRangeJoint(ZonedDateTime start, ZonedDateTime end) {
        if (this.startDate == null || this.endDate == null) {
            return false;
        }
        return !this.endDate.isBefore(start) && !this.startDate.isAfter(end);
    }

    public boolean canCombine(DateRangeModel dateRangeModel) {
        if (dateRangeModel == null) {
            return false;
        }
        List<MainPersonModel> mainPersonModelList = dateRangeModel.getMainPersonModelList();
        if (mainPersonModelList == null) {
            return false;
        }
        if (mainPersonModelList.size() != this.mainPersonModelList.size()) {
            return false;
        }
        return IntStream.range(0, mainPersonModelList.size()).allMatch(i -> ((MainPersonModel)mainPersonModelList.get(i)).equals(this.mainPersonModelList.get(i)));
    }

    static class EndDateComparator
    implements Comparator<DateRangeModel> {
        EndDateComparator() {
        }

        @Override
        public int compare(DateRangeModel o1, DateRangeModel o2) {
            if (o1 == o2) {
                return 0;
            }
            ZonedDateTime endDate1 = o1.getEndDate();
            ZonedDateTime endDate2 = o2.getEndDate();
            if (endDate1 == null) {
                return 1;
            }
            if (endDate2 == null) {
                return -1;
            }
            return endDate2.compareTo(endDate1);
        }
    }

    static class StartDateComparator
    implements Comparator<DateRangeModel> {
        StartDateComparator() {
        }

        @Override
        public int compare(DateRangeModel o1, DateRangeModel o2) {
            if (o1 == o2) {
                return 0;
            }
            ZonedDateTime startDate1 = o1.getStartDate();
            ZonedDateTime startDate2 = o2.getStartDate();
            if (startDate1 == null) {
                return 1;
            }
            if (startDate2 == null) {
                return -1;
            }
            return startDate2.compareTo(startDate1);
        }
    }
}

