/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.model;

import java.time.LocalDateTime;
import java.util.Comparator;

public class MainPersonModel {
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private String headSculpture;
    private String personName;
    private String personNumber;
    private String posType;
    private long posTypeId;
    private String posName;
    private String stdPosName;
    private String laborRelStatus;
    private String laborRelType;
    private boolean isPrimary;
    private Long personId;

    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    public String getHeadSculpture() {
        return this.headSculpture;
    }

    public void setHeadSculpture(String headSculpture) {
        this.headSculpture = headSculpture;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getPersonNumber() {
        return this.personNumber;
    }

    public void setPersonNumber(String personNumber) {
        this.personNumber = personNumber;
    }

    public String getPosType() {
        return this.posType;
    }

    public void setPosType(String posType) {
        this.posType = posType;
    }

    public long getPosTypeId() {
        return this.posTypeId;
    }

    public void setPosTypeId(long posTypeId) {
        this.posTypeId = posTypeId;
    }

    public String getPosName() {
        return this.posName;
    }

    public void setPosName(String posName) {
        this.posName = posName;
    }

    public String getLaborRelStatus() {
        return this.laborRelStatus;
    }

    public void setLaborRelStatus(String laborRelStatus) {
        this.laborRelStatus = laborRelStatus;
    }

    public String getLaborRelType() {
        return this.laborRelType;
    }

    public void setLaborRelType(String laborRelType) {
        this.laborRelType = laborRelType;
    }

    public boolean getPrimary() {
        return this.isPrimary;
    }

    public void setPrimary(boolean primary) {
        this.isPrimary = primary;
    }

    public String getStdPosName() {
        return this.stdPosName;
    }

    public void setStdPosName(String stdPosName) {
        this.stdPosName = stdPosName;
    }

    public Long getPersonId() {
        return this.personId;
    }

    public void setPersonId(Long personId) {
        this.personId = personId;
    }

    public static Comparator<MainPersonModel> getComparator() {
        PersonNumberComparator personNumberComparator = new PersonNumberComparator();
        PosTypeComparator posTypeComparator = new PosTypeComparator();
        StartDateComparator startDateComparator = new StartDateComparator();
        return startDateComparator.thenComparing(posTypeComparator).thenComparing(personNumberComparator);
    }

    static class PersonNumberComparator
    implements Comparator<MainPersonModel> {
        PersonNumberComparator() {
        }

        @Override
        public int compare(MainPersonModel o1, MainPersonModel o2) {
            return o1.getPersonNumber().compareTo(o2.getPersonNumber());
        }
    }

    static class PosTypeComparator
    implements Comparator<MainPersonModel> {
        PosTypeComparator() {
        }

        @Override
        public int compare(MainPersonModel o1, MainPersonModel o2) {
            return Long.compare(o1.getPosTypeId(), o2.getPosTypeId());
        }
    }

    static class StartDateComparator
    implements Comparator<MainPersonModel> {
        StartDateComparator() {
        }

        @Override
        public int compare(MainPersonModel o1, MainPersonModel o2) {
            LocalDateTime startDate1 = o1.getStartDate();
            LocalDateTime startDate2 = o2.getStartDate();
            if (startDate1 == null) {
                return 1;
            }
            if (startDate2 == null) {
                return -1;
            }
            return startDate2.compareTo(startDate1);
        }
    }
}

