/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class CheckChainUtils {
    public static <R> R check(List<Supplier<R>> checkList, Context<R> context) {
        return (R)CheckChainUtils.check(checkList, r -> true, context);
    }

    public static <R> R check(List<Supplier<R>> checkList, Predicate<R> canNextPredicate, Context<R> context) {
        CheckChain<R> booleanCheckChain = new CheckChain<R>();
        booleanCheckChain.setCanNextPredicate(canNextPredicate);
        booleanCheckChain.setCheckList(checkList);
        booleanCheckChain.setContext(context);
        return booleanCheckChain.check();
    }

    public static class DefaultContext<R>
    implements Context<R> {
        @Override
        public void compute(R result) {
        }

        @Override
        public void init() {
        }

        @Override
        public R get() {
            return null;
        }
    }

    public static interface Context<R> {
        public void init();

        public void compute(R var1);

        public R get();
    }

    static class CheckChain<R> {
        List<Supplier<R>> checkList;
        Predicate<R> canNextPredicate;
        Context<R> context;

        CheckChain() {
        }

        public R check() {
            this.context.init();
            for (Supplier<R> checkFunction : this.checkList) {
                R result = checkFunction.get();
                this.context.compute(result);
                boolean canNext = this.canNextPredicate.test(result);
                if (canNext) continue;
                break;
            }
            return this.context.get();
        }

        public void setCheckList(List<Supplier<R>> checkList) {
            this.checkList = checkList;
        }

        public void setCanNextPredicate(Predicate<R> canNextPredicate) {
            this.canNextPredicate = canNextPredicate;
        }

        public void setContext(Context<R> context) {
            this.context = context;
        }
    }
}

