/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util.dyconverter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.common.model.DyMapModel;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class Map2Dy {
    private static final Log LOGGER = LogFactory.getLog(Map2Dy.class);
    Map<String, Map<Object, DynamicObject>> dynamicObjectCache;
    DyMapModel dyMapModel;
    MainEntityType mainEntityType;
    boolean useOriginal;
    Map<Object, DynamicObject> pkVsOriginal;
    Map<String, BiConsumer<DynamicObject, Object>> customKeyVsValueSetter;

    public List<DynamicObject> map2DynamicObject(DyMapModel dyMapModel) {
        this.init(dyMapModel);
        return dyMapModel.getData().stream().map(data -> {
            DynamicObject mainDy = this.useOriginal ? this.pkVsOriginal.get(this.convertLongIfInteger(data.get(dyMapModel.getOriginalKey()))) : new DynamicObject((DynamicObjectType)this.mainEntityType);
            data.entrySet().stream().filter(entry -> !dyMapModel.getIgnoreKeySet().contains(entry.getKey())).forEach(entry -> {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (this.customKeyVsValueSetter.containsKey(key)) {
                    this.customKeyVsValueSetter.get(key).accept(mainDy, value);
                } else {
                    this.setValue(mainDy, key, this.convertValue(key, value, (DynamicObjectType)this.mainEntityType));
                }
            });
            return mainDy;
        }).collect(Collectors.toList());
    }

    private void init(DyMapModel dyMapModel) {
        this.dyMapModel = dyMapModel;
        this.mainEntityType = MetadataServiceHelper.getDataEntityType((String)dyMapModel.getMetadata());
        this.customKeyVsValueSetter = new HashMap<String, BiConsumer<DynamicObject, Object>>();
        Optional.ofNullable(dyMapModel.getKeyVsValueSetter()).ifPresent(map -> this.customKeyVsValueSetter.putAll((Map<String, BiConsumer<DynamicObject, Object>>)map));
        dyMapModel.getIgnoreKeySet().forEach(key -> this.customKeyVsValueSetter.put((String)key, (dy, value) -> {}));
        this.useOriginal = HRStringUtils.isNotEmpty((String)dyMapModel.getOriginalKey());
        this.dynamicObjectCache = new HashMap<String, Map<Object, DynamicObject>>();
        this.initBaseDataCache(dyMapModel);
        this.initEntryBaseDataCache(dyMapModel);
        this.initOriginalCache(dyMapModel);
        this.initMultiBaseDataCache(dyMapModel);
    }

    private void initBaseDataCache(DyMapModel dyMapModel) {
        List<BasedataProp> baseDataProp = this.filterBaseDataProp(this.mainEntityType.getProperties());
        baseDataProp.stream().filter(prop -> !this.customKeyVsValueSetter.containsKey(prop.getName())).forEach(prop -> {
            Object[] idList = dyMapModel.getData().stream().map(data -> data.get(prop.getName())).filter(Objects::nonNull).toArray();
            if (idList.length != 0) {
                Map<Object, DynamicObject> pkFieldVsDy = this.getIdVsDynamicObjectMap((BasedataProp)prop, idList);
                this.dynamicObjectCache.put(prop.getName(), pkFieldVsDy);
            }
        });
    }

    private void initEntryBaseDataCache(DyMapModel dyMapModel) {
        Map<String, List> entryPropVsBaseDataProp = this.mainEntityType.getProperties().stream().filter(prop -> prop instanceof EntryProp).map(prop -> (EntryProp)prop).collect(Collectors.toMap(DynamicProperty::getName, prop -> this.filterBaseDataProp(prop.getDynamicCollectionItemPropertyType().getProperties())));
        entryPropVsBaseDataProp.forEach((entryProp, baseDataPropList) -> {
            List entryMapList = dyMapModel.getData().stream().map(data -> data.get(entryProp)).map(value -> (List)value).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
            baseDataPropList.forEach(baseDataProp -> {
                Object[] idList = entryMapList.stream().map(data -> data.get(baseDataProp.getName())).filter(Objects::nonNull).toArray();
                if (idList.length != 0) {
                    Map<Object, DynamicObject> pkFieldVsDy = this.getIdVsDynamicObjectMap((BasedataProp)baseDataProp, idList);
                    this.dynamicObjectCache.put(baseDataProp.getName(), pkFieldVsDy);
                }
            });
        });
    }

    private void initOriginalCache(DyMapModel dyMapModel) {
        Object[] idList;
        if (this.useOriginal && (idList = dyMapModel.getData().stream().map(data -> data.get(dyMapModel.getOriginalKey())).filter(Objects::nonNull).toArray()).length != 0) {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])idList, (DynamicObjectType)this.mainEntityType);
            this.pkVsOriginal = Arrays.stream(load).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
        }
    }

    private void initMultiBaseDataCache(DyMapModel dyMapModel) {
        List<MulBasedataProp> multiBaseDataProp = this.filterMultiBaseDataProp(this.mainEntityType.getProperties());
        multiBaseDataProp.stream().filter(prop -> !this.customKeyVsValueSetter.containsKey(prop.getName())).forEach(prop -> {
            Object[] idList = dyMapModel.getData().stream().map(data -> data.get(prop.getName())).filter(Objects::nonNull).filter(obj -> obj instanceof List).map(obj -> (List)obj).flatMap(Collection::stream).toArray();
            if (idList.length != 0) {
                BasedataProp refBaseProp = (BasedataProp)prop.getRefBaseProp();
                Map<Object, DynamicObject> pkFieldVsDy = this.getIdVsDynamicObjectMap(refBaseProp, idList);
                this.dynamicObjectCache.put(prop.getName(), pkFieldVsDy);
            }
        });
    }

    private Map<Object, DynamicObject> getIdVsDynamicObjectMap(BasedataProp prop, Object[] idList) {
        DynamicObjectType complexType = (DynamicObjectType)prop.getComplexType();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList, (DynamicObjectType)complexType);
        return Arrays.stream(dynamicObjects).collect(Collectors.toMap(DataEntityBase::getPkValue, dy -> dy));
    }

    private List<BasedataProp> filterBaseDataProp(DataEntityPropertyCollection properties) {
        return properties.stream().filter(prop -> prop instanceof BasedataProp).map(prop -> (BasedataProp)prop).collect(Collectors.toList());
    }

    private List<MulBasedataProp> filterMultiBaseDataProp(DataEntityPropertyCollection properties) {
        return properties.stream().filter(prop -> prop instanceof MulBasedataProp).map(prop -> (MulBasedataProp)prop).collect(Collectors.toList());
    }

    private void setValue(DynamicObject mainDy, String key, Object convertedVal) {
        DynamicProperty property = this.mainEntityType.getProperty(key);
        if (property instanceof LongProp && ((LongProp)property).isRefId()) {
            return;
        }
        if (property instanceof DynamicCollectionProperty) {
            if (property instanceof MulBasedataProp) {
                List bdList = (List)convertedVal;
                DynamicObjectCollection dynamicObjectCollection = mainDy.getDynamicObjectCollection(property.getName());
                dynamicObjectCollection.clear();
                DynamicObjectType entryType = dynamicObjectCollection.getDynamicObjectType();
                for (DynamicObject bd : bdList) {
                    DynamicObject row = new DynamicObject(entryType);
                    row.set("fbasedataid", (Object)bd);
                    dynamicObjectCollection.add((Object)row);
                }
            } else if (property instanceof EntryProp) {
                List rowList = (List)convertedVal;
                DynamicObjectCollection dynamicObjectCollection = mainDy.getDynamicObjectCollection(key);
                dynamicObjectCollection.clear();
                dynamicObjectCollection.addAll((Collection)rowList);
            }
        } else if (property instanceof BasedataProp) {
            if (convertedVal instanceof DynamicObject) {
                mainDy.set(key, convertedVal);
            } else {
                mainDy.set(key, convertedVal);
                mainDy.set(key + "_id", convertedVal);
            }
        } else {
            mainDy.set(key, convertedVal);
        }
    }

    private Object convertValue(String key, Object value, DynamicObjectType mainEntityType) {
        DynamicProperty property = mainEntityType.getProperty(key);
        if (property == null) {
            throw new RuntimeException(String.format("convert dynamic object error: %s is not exist in %s", key, mainEntityType.getName()));
        }
        return this.convertValue(property, value);
    }

    private Object convertValue(DynamicProperty property, Object value) {
        if (property instanceof DynamicSimpleProperty) {
            return this.convertSimpleValue(property, value);
        }
        if (property instanceof DynamicComplexProperty) {
            return this.convertComplexValue(property, value);
        }
        if (property instanceof DynamicCollectionProperty) {
            return this.convertCollectionValue(property, value);
        }
        throw this.getNoSupportedBranchException(property);
    }

    private Object convertCollectionValue(DynamicProperty property, Object value) {
        if (property instanceof MulBasedataProp) {
            List pkFieldList = (List)value;
            Map pkFieldVsDy = this.dynamicObjectCache.getOrDefault(property.getName(), Collections.emptyMap());
            return pkFieldList.stream().map(this::convertLongIfInteger).map(pkFieldVsDy::get).collect(Collectors.toList());
        }
        if (property instanceof EntryProp) {
            List entryValueMap = (List)value;
            DynamicObjectType entryType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            if (entryValueMap != null) {
                return entryValueMap.stream().map(rowValue -> {
                    DynamicObject row = new DynamicObject(entryType);
                    rowValue.forEach((k, v) -> this.setValue(row, (String)k, this.convertValue((String)k, v, entryType)));
                    return row;
                }).collect(Collectors.toList());
            }
            return new ArrayList();
        }
        throw this.getNoSupportedBranchException(property);
    }

    private Object convertComplexValue(DynamicProperty property, Object value) {
        if (property instanceof BasedataProp) {
            DynamicObject bd = (DynamicObject)this.dynamicObjectCache.getOrDefault(property.getName(), Collections.emptyMap()).get(this.convertLongIfInteger(value));
            if (bd == null && this.dyMapModel.isRetainBdInput()) {
                return value;
            }
            return bd;
        }
        throw this.getNoSupportedBranchException(property);
    }

    private Object convertSimpleValue(DynamicProperty property, Object value) {
        if (property instanceof TextProp) {
            return this.convertTextValue(property, value);
        }
        if (property instanceof DateTimeProp) {
            Date date = null;
            try {
                date = HRDateTimeUtils.parseDate((String)String.valueOf(value));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return date;
        }
        if (property instanceof ComboProp) {
            return value;
        }
        if (property instanceof DecimalProp) {
            return this.convertDecimalValue(property, value);
        }
        if (property instanceof PKFieldProp) {
            if (property instanceof LongProp) {
                return value == null ? 0L : Long.parseLong(value.toString());
            }
            return value;
        }
        throw this.getNoSupportedBranchException(property);
    }

    private Object convertTextValue(DynamicProperty property, Object value) {
        if (property instanceof MuliLangTextProp) {
            LocaleString localeString = new LocaleString();
            if (value != null) {
                Map<String, String> localeStringMap = Collections.checkedMap((Map)value, String.class, String.class);
                localeStringMap.entrySet().stream().filter(entry -> entry.getValue() != null && !((String)entry.getValue()).isEmpty()).forEach(entry -> {
                    String cfr_ignored_0 = (String)localeString.put((String)entry.getKey(), entry.getValue());
                });
            }
            return localeString;
        }
        return value;
    }

    private Object convertDecimalValue(DynamicProperty property, Object value) {
        if (property instanceof IntegerProp) {
            return value;
        }
        throw this.getNoSupportedBranchException(property);
    }

    private RuntimeException getNoSupportedBranchException(DynamicProperty property) {
        return new RuntimeException(String.format("no supported branch, key: %s, class: %s", property.getName(), property.getClass()));
    }

    private Object convertLongIfInteger(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return value;
    }
}

