/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.haos.common.util.tree.Node;

public class FindParentTree<T> {
    Node<T> virtualRoot;
    Map<Long, Node<T>> boVsNode;

    public FindParentTree(Map<Long, Long> idVsPid, Map<Long, T> idVsData) {
        this.boVsNode = idVsPid.entrySet().stream().map(entry -> {
            Node node = new Node();
            node.setId((Long)entry.getKey());
            node.setPid((Long)entry.getValue());
            node.setData(idVsData.getOrDefault(node.getId(), null));
            return node;
        }).collect(Collectors.toMap(Node::getId, node -> node));
        this.virtualRoot = FindParentTree.genVirtualRoot();
        this.boVsNode.values().forEach(node -> node.setChildList(Collections.singletonList(this.boVsNode.getOrDefault(node.getPid(), this.virtualRoot))));
    }

    public List<T> findParentList(long id, boolean containsSelf) {
        ArrayList<T> result = new ArrayList<T>();
        Node<T> node = this.boVsNode.getOrDefault(id, this.virtualRoot);
        if (node != this.virtualRoot) {
            if (containsSelf) {
                result.add(node.getData());
            }
            int max = 20;
            int i = 0;
            node = node.getChildList().get(0);
            while (node != this.virtualRoot) {
                result.add(node.getData());
                node = node.getChildList().get(0);
                if (i++ <= max) continue;
                break;
            }
        }
        return result;
    }

    private static <T> Node<T> genVirtualRoot() {
        return new Node();
    }
}

