/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.hr.haos.common.util.tree.FindSubNode;
import kd.hr.haos.common.util.tree.Node;

public class FindSubTree<T> {
    FindSubNode<T> virtualRoot;
    Map<Long, FindSubNode<T>> boVsNode;
    boolean isInitSub = false;
    Consumer<FindSubNode<T>> findSubVisitor;

    public FindSubTree() {
    }

    public FindSubTree(Map<Long, Long> boVsPidMap, Map<Long, T> idVsData) {
        this.boVsNode = boVsPidMap.entrySet().stream().map(entry -> {
            FindSubNode node = new FindSubNode();
            node.setId((Long)entry.getKey());
            node.setPid((Long)entry.getValue());
            node.setData(idVsData.getOrDefault(node.getId(), null));
            return node;
        }).collect(Collectors.toMap(Node::getId, node -> node));
        this.virtualRoot = FindSubTree.genVirtualRoot();
        this.boVsNode.values().forEach(node -> this.boVsNode.getOrDefault(node.getPid(), this.virtualRoot).getChildList().add(node));
    }

    public static <T> FindSubTree<T> create(Map<Long, Long> boVsPidMap, Map<Long, T> idVsData) {
        return new FindSubTree<T>(boVsPidMap, idVsData);
    }

    public void initSub() {
        ArrayDeque stack = new ArrayDeque();
        this.levelTraverse0(this.virtualRoot, true, stack::push);
        while (!stack.isEmpty()) {
            FindSubNode pop = (FindSubNode)stack.pop();
            ArrayList subList = new ArrayList();
            pop.setSubList(subList);
            pop.getChildList().forEach(node -> subList.addAll(((FindSubNode)node).getSubList()));
            this.findSubVisitor.accept(pop);
        }
        this.isInitSub = true;
    }

    public List<T> findSub(long id, boolean containsAllSub) {
        if (this.isInitSub) {
            return this.boVsNode.getOrDefault(id, new FindSubNode()).getSubList().stream().map(Node::getData).collect(Collectors.toList());
        }
        return this.levelTraverse(id, containsAllSub);
    }

    public T get(long id) {
        return this.boVsNode.getOrDefault(id, new FindSubNode()).getData();
    }

    public List<T> levelTraverse(long id, boolean containsAllSub) {
        ArrayList result = new ArrayList();
        this.levelTraverse0(this.boVsNode.getOrDefault(id, new FindSubNode()), containsAllSub, node -> result.add(node.getData()));
        return result;
    }

    public List<T> levelFirstLevel() {
        return this.virtualRoot.getChildList().stream().map(Node::getData).collect(Collectors.toList());
    }

    public void levelTraverse(Consumer<Node<T>> visitor) {
        this.levelTraverse0(this.virtualRoot, true, visitor);
    }

    private void levelTraverse0(Node<T> node, boolean containsAllSub, Consumer<Node<T>> visitor) {
        ArrayDeque queue = new ArrayDeque();
        node.getChildList().forEach(queue::offer);
        if (containsAllSub) {
            while (!queue.isEmpty()) {
                Node poll = (Node)queue.poll();
                visitor.accept(poll);
                poll.getChildList().forEach(queue::offer);
            }
        }
    }

    private static <T> FindSubNode<T> genVirtualRoot() {
        return new FindSubNode();
    }

    public void setFindSubVisitor(Consumer<FindSubNode<T>> findSubVisitor) {
        this.findSubVisitor = findSubVisitor;
    }
}

