/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.common.util.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.hr.haos.common.util.tree.Node;

public class Tree {
    Node<Void> virtualRoot;
    Map<Long, Node<Void>> boVsNode;

    public List<Long> levelTraverse() {
        ArrayList<Long> result = new ArrayList<Long>();
        ArrayDeque queue = new ArrayDeque();
        this.virtualRoot.childList.forEach(node -> {
            result.add(node.id);
            queue.offer(node);
        });
        while (!queue.isEmpty()) {
            Node poll = (Node)queue.poll();
            poll.childList.forEach(node -> {
                result.add(node.id);
                queue.offer(node);
            });
        }
        return result;
    }

    public Node<Void> findNode(long bo) {
        return this.boVsNode.get(bo);
    }

    public Tree(Map<Long, Long> boVsPidMap) {
        this.boVsNode = boVsPidMap.entrySet().stream().map(entry -> {
            Node node = new Node();
            node.id = (Long)entry.getKey();
            node.pid = (Long)entry.getValue();
            return node;
        }).collect(Collectors.toMap(node -> node.id, node -> node));
        this.virtualRoot = Tree.genVirtualRoot();
        this.boVsNode.values().forEach(node -> this.boVsNode.getOrDefault((Object)Long.valueOf((long)node.pid), this.virtualRoot).childList.add(node));
    }

    private static Node<Void> genVirtualRoot() {
        return new Node<Void>();
    }
}

