/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.business.util.HisMainPeopleHelper;
import kd.hr.haos.common.model.MainPersonModel;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.haos.formplugin.web.adminorg.HisMainPeopleListProvider;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.template.HRBasedataList;

public class AdminOrgHisMainPeopleListPlugin
extends HRBasedataList {
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        this.putModelList();
        String belongCompName = (String)this.getView().getFormShowParameter().getCustomParam("belong_comp_name");
        String belongDeptName = (String)this.getView().getFormShowParameter().getCustomParam("belong_dept_name");
        String clickRowStr = this.getView().getPageCache().get("clickRowStr");
        List modelList = (List)this.getView().getFormShowParameter().getCustomParam("mainPersonModel");
        if (HRStringUtils.isNotEmpty((String)clickRowStr)) {
            this.clickRowView(clickRowStr);
            args.setListDataProvider((IListDataProvider)new HisMainPeopleListProvider(modelList, belongCompName, belongDeptName));
        } else {
            args.setListDataProvider((IListDataProvider)new HisMainPeopleListProvider(modelList, belongCompName, belongDeptName));
        }
    }

    private void putModelList() {
        if (this.getView().getFormShowParameter().getCustomParam("mainPersonModel") != null) {
            return;
        }
        String orgId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        ArrayList personResult = AdminOrgQueryServiceHelper.getPersonInfo((String)orgId);
        if (CollectionUtils.isEmpty((Collection)personResult)) {
            personResult = new ArrayList();
        } else {
            Iterator iterator = personResult.iterator();
            Date searchDate = OrgDateTimeUtil.getSearchDate((FormShowParameter)this.getView().getFormShowParameter());
            while (iterator.hasNext()) {
                Map peresonMap = (Map)iterator.next();
                String startDateStr = (String)peresonMap.get("effdt");
                Date startDate = new Date(Long.parseLong(startDateStr));
                if (!searchDate.before(startDate)) continue;
                iterator.remove();
            }
        }
        if (this.getView().getFormShowParameter().getCustomParam("mainPersonModelPlain") == null) {
            String personResultStr = SerializationUtils.toJsonString(personResult);
            List personResultPlain = (List)SerializationUtils.fromJsonString((String)personResultStr, List.class);
            List modelListPlain = personResultPlain.stream().map(HisMainPeopleHelper::convert).sorted(MainPersonModel.getComparator()).collect(Collectors.toList());
            this.getView().getFormShowParameter().setCustomParam("mainPersonModelPlain", modelListPlain);
        }
        List<MainPersonModel> modelList = personResult.stream().map(HisMainPeopleHelper::convert).sorted(MainPersonModel.getComparator()).collect(Collectors.toList());
        this.checkDesensitize(modelList, true);
        this.getView().getFormShowParameter().setCustomParam("mainPersonModel", modelList);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        BillList billList = (BillList)evt.getSource();
        String focusField = billList.getEntryState().getFocusField();
        if (HRStringUtils.equals((String)focusField, (String)"click_view")) {
            int row = evt.getRow();
            String clickRowStr = this.getView().getPageCache().get("clickRowStr");
            clickRowStr = HRStringUtils.isEmpty((String)clickRowStr) ? String.valueOf(row) : clickRowStr + "," + row;
            this.getView().getPageCache().put("clickRowStr", clickRowStr);
            this.getView().updateView("billlistap");
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ListView listView = (ListView)this.getView();
        boolean checkDesensitize = this.checkDesensitize(null, false);
        if (!checkDesensitize) {
            listView.setVisible(Boolean.valueOf(false), new String[]{"click_view"});
        }
        boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"name");
        boolean personnumberClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"number");
        boolean postypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"postype");
        boolean positionClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"position");
        boolean standpositionClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"stdposition");
        boolean laborrelstatusClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_employee", (String)"laborrelstatus");
        boolean laborreltypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_employee", (String)"laborreltype");
        if (!(nameClickView || personnumberClickView || postypeClickView || positionClickView || standpositionClickView || laborrelstatusClickView || laborreltypeClickView)) {
            listView.setVisible(Boolean.valueOf(false), new String[]{"click_view"});
        }
    }

    private boolean checkDesensitize(List<MainPersonModel> modelList, boolean initStatus) {
        boolean desensitizeStatus = false;
        boolean namePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null);
        boolean personnumberPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null);
        boolean postypePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"postype", (String)Lang.get().toString(), (String)"LIST", null);
        boolean positionPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null);
        boolean standpositionPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"stdposition", (String)Lang.get().toString(), (String)"LIST", null);
        boolean laborrelstatusPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_employee", (String)"laborrelstatus", (String)Lang.get().toString(), (String)"LIST", null);
        boolean laborreltypePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_employee", (String)"laborreltype", (String)Lang.get().toString(), (String)"LIST", null);
        boolean isprimaryPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"isprimary", (String)Lang.get().toString(), (String)"LIST", null);
        if (namePrivacy || personnumberPrivacy || postypePrivacy || positionPrivacy || standpositionPrivacy || laborrelstatusPrivacy || laborreltypePrivacy || isprimaryPrivacy) {
            desensitizeStatus = true;
        }
        if (initStatus) {
            if (CollectionUtils.isEmpty(modelList)) {
                return desensitizeStatus;
            }
            for (MainPersonModel mainPersonModel : modelList) {
                if (namePrivacy) {
                    String personName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getPersonName());
                    mainPersonModel.setPersonName(personName);
                }
                if (personnumberPrivacy) {
                    String personNumber = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getPersonNumber());
                    mainPersonModel.setPersonNumber(personNumber);
                }
                if (postypePrivacy) {
                    String posType = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"postype", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getPosType());
                    mainPersonModel.setPosType(posType);
                }
                if (positionPrivacy) {
                    String posName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getPosName());
                    mainPersonModel.setPosName(posName);
                }
                if (standpositionPrivacy) {
                    String stdPosName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"stdposition", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getStdPosName());
                    mainPersonModel.setStdPosName(stdPosName);
                }
                if (laborrelstatusPrivacy) {
                    String laborRelStatus = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_employee", (String)"laborrelstatus", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getLaborRelStatus());
                    mainPersonModel.setLaborRelStatus(laborRelStatus);
                }
                if (!laborreltypePrivacy) continue;
                String laborRelType = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_employee", (String)"laborreltype", (String)Lang.get().toString(), (String)"LIST", null, (Object)mainPersonModel.getLaborRelType());
                mainPersonModel.setLaborRelType(laborRelType);
            }
        }
        return desensitizeStatus;
    }

    private void clickRowView(String clickRowStr) {
        String[] rowArr = clickRowStr.split(",");
        Set rowSet = Arrays.stream(rowArr).collect(Collectors.toSet());
        List mainPersonModelListPlain = (List)this.getView().getFormShowParameter().getCustomParam("mainPersonModelPlain");
        List mainPersonModelList = (List)this.getView().getFormShowParameter().getCustomParam("mainPersonModel");
        boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"name");
        boolean personnumberClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"number");
        boolean postypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"postype");
        boolean positionClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"position");
        boolean standpositionClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)"stdposition");
        boolean laborrelstatusClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_employee", (String)"laborrelstatus");
        boolean laborreltypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_employee", (String)"laborreltype");
        for (int i = 0; i < mainPersonModelList.size(); ++i) {
            MainPersonModel mainPersonModel = (MainPersonModel)mainPersonModelList.get(i);
            if (!rowSet.contains(String.valueOf(i))) continue;
            MainPersonModel mainPersonModelPlain = (MainPersonModel)mainPersonModelListPlain.get(i);
            if (nameClickView) {
                mainPersonModel.setPersonName(mainPersonModelPlain.getPersonName());
            }
            if (personnumberClickView) {
                mainPersonModel.setPersonNumber(mainPersonModelPlain.getPersonNumber());
            }
            if (postypeClickView) {
                mainPersonModel.setPosType(mainPersonModelPlain.getPosType());
            }
            if (positionClickView) {
                mainPersonModel.setPosName(mainPersonModelPlain.getPosName());
            }
            if (standpositionClickView) {
                mainPersonModel.setStdPosName(mainPersonModelPlain.getStdPosName());
            }
            if (laborrelstatusClickView) {
                mainPersonModel.setLaborRelStatus(mainPersonModelPlain.getLaborRelStatus());
            }
            if (!laborreltypeClickView) continue;
            mainPersonModel.setLaborRelType(mainPersonModelPlain.getLaborRelType());
        }
    }
}

