/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.haos.business.util.HisMainPeopleHelper;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.business.util.TimelineControlApUtil;
import kd.hr.haos.common.constants.PosTypeEnum;
import kd.hr.haos.common.model.DateRangeModel;
import kd.hr.haos.common.model.MainPersonModel;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class AdminOrgHisMainPeopleTimeLinePlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(AdminOrgHisMainPeopleTimeLinePlugin.class);
    private static final String BLANK_FLEX_KEY = "blankflex";
    private static final String TARGET_FLEX_KEY = "cardflex";
    private static final String BLANK_KEY = "blank_key";
    public static final String HRPI_PERSON = "hrpi_person";
    private static final String HBPM_POSITIONHR = "hbpm_positionhr";
    private static final String HBPM_POSITIONTYPE = "hbpm_positiontype";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        String orgId = (String)formShowParameter.getCustomParam("currentObjectPKId");
        List<Map<String, Object>> personResult = AdminOrgQueryServiceHelper.getPersonInfo((String)orgId);
        formShowParameter.setCustomParam("person_result", (Object)personResult);
        if (!CollectionUtils.isEmpty((Collection)personResult)) {
            personResult = personResult.stream().filter(map -> Objects.nonNull(map.get("effdt")) && Objects.nonNull(map.get("leffdt")) && Long.parseLong((String)map.get("effdt")) < Long.parseLong((String)map.get("leffdt"))).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)personResult)) {
            Date searchDate = OrgDateTimeUtil.getSearchDate((FormShowParameter)formShowParameter);
            List<DateRangeModel> viewModel = this.createViewModel(personResult, searchDate);
            if (!CollectionUtils.isEmpty(viewModel)) {
                this.createAps(e, viewModel);
                this.hideNoDataView(formShowParameter);
            } else {
                this.showNoDataView(formShowParameter);
            }
        } else {
            this.showNoDataView(formShowParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        ((BillList)this.getControl("billlistap")).getFilterParameter().getQFilters().add(new QFilter("1", "!=", (Object)1));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean blank = (Boolean)this.getView().getFormShowParameter().getCustomParam(BLANK_KEY);
        if (blank) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TARGET_FLEX_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BLANK_FLEX_KEY});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{TARGET_FLEX_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BLANK_FLEX_KEY});
        }
    }

    private void createAps(LoadCustomControlMetasArgs e, List<DateRangeModel> viewModel) {
        FlexPanelAp myFlexFlexPanelAp = this.createMyFlexFlexPanelAp(viewModel);
        HashMap<String, String> mapHeadMap = new HashMap<String, String>();
        mapHeadMap.put("id", TARGET_FLEX_KEY);
        mapHeadMap.put("items", (String)myFlexFlexPanelAp.createControl().get("items"));
        e.getItems().add(mapHeadMap);
    }

    private void showNoDataView(FormShowParameter formShowParameter) {
        formShowParameter.setCustomParam(BLANK_KEY, (Object)true);
    }

    private void hideNoDataView(FormShowParameter formShowParameter) {
        formShowParameter.setCustomParam(BLANK_KEY, (Object)false);
    }

    private List<DateRangeModel> createViewModel(List<Map<String, Object>> personResult, Date searchDate) {
        List<MainPersonModel> dateValidMainPersonModelList = personResult.stream().map(HisMainPeopleHelper::convertMinusEndDate).filter(mainPersonModel -> Objects.nonNull(mainPersonModel.getStartDate()) && Objects.nonNull(mainPersonModel.getEndDate()) && mainPersonModel.getStartDate().compareTo(mainPersonModel.getEndDate()) <= 0).collect(Collectors.toList());
        List<DateRangeModel> dateRangeModelList = this.getDateRangeModels(dateValidMainPersonModelList);
        dateRangeModelList.forEach(dateRangeModel -> dateValidMainPersonModelList.stream().filter(person -> dateRangeModel.isRangeJoint(TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)person.getStartDate()), TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)person.getEndDate()))).forEach(person -> dateRangeModel.getMainPersonModelList().add(person)));
        dateRangeModelList.sort(DateRangeModel.getDateComparator());
        List<DateRangeModel> viewModel = this.combineDateRange(dateRangeModelList);
        Optional.of(viewModel).map(model -> ((DateRangeModel)model.get(0)).getEndDate()).filter(endDate -> endDate.isBefore(TimeConvertUtil.nowUserZonedDateTimeWithoutTime())).ifPresent(endDate -> viewModel.add(0, new DateRangeModel(endDate.plusDays(1L), TimeConvertUtil.nowUserZonedDateTimeWithoutTime())));
        this.getSearchDateBeforeModel(viewModel, searchDate);
        return viewModel;
    }

    private void getSearchDateBeforeModel(List<DateRangeModel> viewModel, Date searchDate) {
        if (!CollectionUtils.isEmpty(viewModel)) {
            Iterator<DateRangeModel> iterator = viewModel.iterator();
            while (iterator.hasNext()) {
                DateRangeModel dateRangeModel = iterator.next();
                if (HRDateTimeUtils.dayBefore((Date)searchDate, (Date)Date.from(dateRangeModel.getStartDate().toInstant()))) {
                    iterator.remove();
                    continue;
                }
                if (HRDateTimeUtils.dayEquals((Date)searchDate, (Date)Date.from(dateRangeModel.getStartDate().toInstant()))) {
                    dateRangeModel.setEndDate(dateRangeModel.getStartDate());
                    continue;
                }
                if (!HRDateTimeUtils.dayAfter((Date)searchDate, (Date)Date.from(dateRangeModel.getStartDate().toInstant())) || !HRDateTimeUtils.dayBefore((Date)searchDate, (Date)Date.from(dateRangeModel.getEndDate().toInstant()))) continue;
                dateRangeModel.setEndDate(searchDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()));
            }
        }
    }

    private List<DateRangeModel> combineDateRange(List<DateRangeModel> dateRangeModelList) {
        ArrayList<DateRangeModel> result = new ArrayList<DateRangeModel>();
        if (dateRangeModelList == null || dateRangeModelList.size() == 0) {
            return result;
        }
        result.add(dateRangeModelList.get(0));
        for (int i = 1; i < dateRangeModelList.size(); ++i) {
            DateRangeModel epochSmaller;
            DateRangeModel epochLarger = (DateRangeModel)result.get(result.size() - 1);
            if (epochLarger.canCombine(epochSmaller = dateRangeModelList.get(i))) {
                epochLarger.setStartDate(epochSmaller.getStartDate());
                continue;
            }
            result.add(epochSmaller);
        }
        return result;
    }

    private List<DateRangeModel> getDateRangeModels(List<MainPersonModel> dateValidMainPersonModelList) {
        List allDate = dateValidMainPersonModelList.stream().collect(ArrayList::new, (list, person) -> {
            list.add(person.getStartDate());
            list.add(person.getEndDate());
        }, ArrayList::addAll);
        List distinctOrderedDateList = allDate.stream().distinct().sorted(LocalDateTime::compareTo).collect(Collectors.toList());
        List<DateRangeModel> dateRangeModelList = distinctOrderedDateList.stream().map(localDateTime -> new DateRangeModel(TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)localDateTime), TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)localDateTime))).filter(rangeModel -> !rangeModel.getStartDate().isAfter(TimeConvertUtil.nowUserZonedDateTimeWithoutTime())).collect(Collectors.toList());
        IntStream.range(0, distinctOrderedDateList.size() - 1).forEach(i -> {
            LocalDateTime newEnd;
            LocalDateTime newStart = ((LocalDateTime)distinctOrderedDateList.get(i)).plusDays(1L);
            if (!newStart.isAfter(newEnd = ((LocalDateTime)distinctOrderedDateList.get(i + 1)).minusDays(1L)) && !newStart.isAfter(LocalDateTime.now())) {
                DateRangeModel dateRangeModel = new DateRangeModel(TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)newStart), TimeConvertUtil.toUserZonedDateTimeWithoutTime((LocalDateTime)newEnd));
                dateRangeModelList.add(dateRangeModel);
            }
        });
        return dateRangeModelList;
    }

    private FlexPanelAp createMyFlexFlexPanelAp(List<DateRangeModel> dateRangeModelList) {
        FlexPanelAp myFlexFlexPanelAp = TimelineControlApUtil.getMyFlexFlexPanelAp();
        ArrayList<FlexPanelAp> timeLineFlexPanelApList = new ArrayList<FlexPanelAp>(dateRangeModelList.size());
        boolean personnamePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)HRPI_PERSON, (String)"name", (String)Lang.get().toString(), (String)"LIST", null);
        boolean positionPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null);
        boolean positionTypePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"postype", (String)Lang.get().toString(), (String)"LIST", null);
        boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)HRPI_PERSON, (String)"name");
        boolean positionClickView = AdminOrgQueryServiceHelper.checkClickView((String)HBPM_POSITIONHR, (String)"name");
        boolean postypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)HBPM_POSITIONTYPE, (String)"name");
        for (int i = 0; i < dateRangeModelList.size(); ++i) {
            FlexPanelAp flexPanelAp = this.createTimelineFlexPanelAp(dateRangeModelList.get(i), i, personnamePrivacy, positionPrivacy, positionTypePrivacy, nameClickView, positionClickView, postypeClickView);
            timeLineFlexPanelApList.add(flexPanelAp);
        }
        if (timeLineFlexPanelApList.size() != 0) {
            TimelineControlApUtil.modifyPeoplePanel((FlexPanelAp)((FlexPanelAp)timeLineFlexPanelApList.get(timeLineFlexPanelApList.size() - 1)));
        }
        myFlexFlexPanelAp.getItems().addAll(timeLineFlexPanelApList);
        return myFlexFlexPanelAp;
    }

    private FlexPanelAp createTimelineFlexPanelAp(DateRangeModel dateRangeModel, int level, boolean personnamePrivacy, boolean positionPrivacy, boolean positionTypePrivacy, boolean nameClickView, boolean positionClickView, boolean postypeClickView) {
        FlexPanelAp timeFlexPanelAp = this.createTimeFlexPanelAp(dateRangeModel.getStartDate(), dateRangeModel.getEndDate());
        List mainPersonModelList = dateRangeModel.getMainPersonModelList();
        ArrayList<FlexPanelAp> personInfoFlexPanelApList = new ArrayList<FlexPanelAp>(mainPersonModelList.size());
        for (int i = 0; i < mainPersonModelList.size(); ++i) {
            FlexPanelAp personInfoFlexPanelAp = this.createPersonInfoFlexPanelAp((MainPersonModel)mainPersonModelList.get(i), level, i, personnamePrivacy, positionPrivacy, positionTypePrivacy, nameClickView, positionClickView, postypeClickView);
            personInfoFlexPanelApList.add(personInfoFlexPanelAp);
        }
        Optional.of(personInfoFlexPanelApList).filter(list -> list.size() == 0).ifPresent(list -> list.add(TimelineControlApUtil.getNonPersonFlexPanelAp()));
        FlexPanelAp timelineFlexPanelAp = TimelineControlApUtil.getTimelineFlexPanelAp();
        FlexPanelAp peopleFlexPanelAp = TimelineControlApUtil.getPeopleFlexPanelAp();
        if (personInfoFlexPanelApList.size() != 0) {
            TimelineControlApUtil.modifyPersonPanel((FlexPanelAp)((FlexPanelAp)personInfoFlexPanelApList.get(personInfoFlexPanelApList.size() - 1)));
        }
        peopleFlexPanelAp.getItems().addAll(personInfoFlexPanelApList);
        timelineFlexPanelAp.getItems().add(timeFlexPanelAp);
        timelineFlexPanelAp.getItems().add(peopleFlexPanelAp);
        return timelineFlexPanelAp;
    }

    private FlexPanelAp createTimeFlexPanelAp(ZonedDateTime startDate, ZonedDateTime endDate) {
        FlexPanelAp timeFlexPanelAp = TimelineControlApUtil.getTimeFlexPanelAp();
        LabelAp timeDescLabelAp = TimelineControlApUtil.getTimeDescLabelAp();
        String periodMessage = this.getTimeMessage(startDate, endDate);
        timeDescLabelAp.setName(new LocaleString(periodMessage));
        VectorAp circleVectorAp = TimelineControlApUtil.getCircleVectorAp();
        timeFlexPanelAp.getItems().add(circleVectorAp);
        timeFlexPanelAp.getItems().add(timeDescLabelAp);
        return timeFlexPanelAp;
    }

    private FlexPanelAp createPersonInfoFlexPanelAp(MainPersonModel mainPersonModel, int level, int index, boolean personnamePrivacy, boolean positionPrivacy, boolean positionTypePrivacy, boolean nameClickView, boolean positionClickView, boolean postypeClickView) {
        FlexPanelAp personPanelAp = TimelineControlApUtil.getPersonFlexPanelAp();
        ImageAp headImageAp = TimelineControlApUtil.getHeadImageAp((int)level, (int)index);
        Optional.ofNullable(mainPersonModel.getHeadSculpture()).filter(str -> !StringUtils.isEmpty((Object)str)).map(HRImageUrlUtil::getImageFullUrl).ifPresent(arg_0 -> ((ImageAp)headImageAp).setImageKey(arg_0));
        FlexPanelAp personInfoFlexPanelAp = TimelineControlApUtil.getPersonInfoFlexPanelAp();
        FlexPanelAp nameAndEyeFlexPanelAp = TimelineControlApUtil.getNameAndEyeFlexPanelAp((int)level, (int)index);
        LabelAp personNameLabelAp = TimelineControlApUtil.getPersonNameLabelAp((int)level, (int)index);
        String personName = mainPersonModel.getPersonName();
        if (personnamePrivacy) {
            personName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)HRPI_PERSON, (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)personName);
        }
        personNameLabelAp.setName(new LocaleString(personName));
        VectorAp eyeVectorAp = TimelineControlApUtil.getEyeVectorAp((int)level, (int)index);
        FlexPanelAp positionInfoFlexPanelAp = TimelineControlApUtil.getPositionInfoFlexPanelAp((int)level, (int)index);
        LabelAp positionNameLabelAp = TimelineControlApUtil.getPositionNameLabelAp((int)level, (int)index);
        String positionName = this.getPositionName(mainPersonModel);
        if (positionPrivacy) {
            positionName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null, (Object)positionName);
        }
        positionNameLabelAp.setName(new LocaleString(positionName));
        LabelAp posTypeLabelAp = TimelineControlApUtil.getPosTypeLabelAp((int)level, (int)index);
        String posType = this.getLocaleNameById(mainPersonModel.getPosTypeId());
        if (positionTypePrivacy) {
            posType = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"postype", (String)Lang.get().toString(), (String)"LIST", null, (Object)posType);
        }
        posTypeLabelAp.setName(new LocaleString(posType));
        FlexPanelAp personInternalFlexAp = TimelineControlApUtil.getPersonInternalFlexAp();
        personPanelAp.getItems().add(headImageAp);
        personPanelAp.getItems().add(personInfoFlexPanelAp);
        nameAndEyeFlexPanelAp.getItems().add(personNameLabelAp);
        if ((personnamePrivacy || positionPrivacy || positionTypePrivacy) && (nameClickView || positionClickView || postypeClickView)) {
            nameAndEyeFlexPanelAp.getItems().add(eyeVectorAp);
        }
        personInfoFlexPanelAp.getItems().add(nameAndEyeFlexPanelAp);
        personInfoFlexPanelAp.getItems().add(positionInfoFlexPanelAp);
        positionInfoFlexPanelAp.getItems().add(positionNameLabelAp);
        personPanelAp.getItems().add(personInternalFlexAp);
        if (mainPersonModel.getPosTypeId() != 0L) {
            positionInfoFlexPanelAp.getItems().add(posTypeLabelAp);
        }
        return personPanelAp;
    }

    private String getPositionName(MainPersonModel mainPersonModel) {
        String posName = "";
        if (HRStringUtils.isNotEmpty((String)mainPersonModel.getPosName())) {
            posName = mainPersonModel.getPosName();
        } else if (HRStringUtils.isNotEmpty((String)mainPersonModel.getStdPosName())) {
            posName = mainPersonModel.getStdPosName();
        }
        return posName;
    }

    private String getTimeMessage(ZonedDateTime startDate, ZonedDateTime endDate) {
        String start = HRInteDateTimeUtil.formatDate((String)"hrpi_chargeperson", (String)"effdt", (Date)Date.from(startDate.toInstant()));
        boolean isLatest = !endDate.isBefore(TimeConvertUtil.nowUserZonedDateTimeWithoutTime());
        String end = isLatest ? ResManager.loadKDString((String)"\u81f3\u4eca", (String)"AdminOrgHisMainPeopleTimeLinePlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]) : HRInteDateTimeUtil.formatDate((String)"hrpi_chargeperson", (String)"leffdt", (Date)Date.from(endDate.toInstant()));
        Period period = Period.between(startDate.toLocalDate(), isLatest ? LocalDate.now().plusDays(1L) : endDate.toLocalDate().plusDays(1L));
        String periodMessage = OrgDateTimeUtil.setYmd((int)period.getYears(), (int)period.getMonths(), (int)period.getDays());
        StringBuilder stringBuilder = new StringBuilder();
        return stringBuilder.append(start).append(isLatest ? " " : " ~ ").append(end).append(" (").append(periodMessage).append(")").toString();
    }

    private String getLocaleNameById(long id) {
        return Arrays.stream(PosTypeEnum.values()).filter(posTypeEnum -> posTypeEnum.getId() == id).findAny().orElse(PosTypeEnum.OTHER).getLocaleName();
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith("eye_")) {
            Vector vector = new Vector();
            vector.setKey(key);
            vector.setView(this.getView());
            vector.addClickListener((ClickListener)this);
            e.setControl((Control)vector);
        } else if (key.startsWith("personnamelabelap_") || key.startsWith("positionname_") || key.startsWith("postypeap_")) {
            Label label = new Label();
            label.setKey(key);
            label.setView(this.getView());
            e.setControl((Control)label);
        } else if (key.startsWith("pictureap_")) {
            Image image = new Image();
            image.setKey(key);
            image.setView(this.getView());
            e.setControl((Control)image);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.startsWith("eye_")) {
            Date searchDate;
            List<DateRangeModel> viewModel;
            MainPersonModel mainPersonModel;
            String levelStr = key.substring(4, 5);
            Integer level = Integer.valueOf(levelStr);
            String indexStr = key.substring(6, 7);
            Integer index = Integer.valueOf(indexStr);
            String levelAndIndex = key.substring(4);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            List personResult = (List)formShowParameter.getCustomParam("person_result");
            if (!CollectionUtils.isEmpty((Collection)personResult) && (mainPersonModel = (MainPersonModel)(viewModel = this.createViewModel(personResult, searchDate = OrgDateTimeUtil.getSearchDate((FormShowParameter)formShowParameter))).get(level).getMainPersonModelList().get(index)) != null) {
                Label postype;
                boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)HRPI_PERSON, (String)"name");
                boolean positionClickView = AdminOrgQueryServiceHelper.checkClickView((String)HBPM_POSITIONHR, (String)"name");
                boolean postypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)HBPM_POSITIONTYPE, (String)"name");
                if (nameClickView) {
                    Label personname = (Label)this.getView().getControl("personnamelabelap_" + levelAndIndex);
                    personname.setText(mainPersonModel.getPersonName());
                }
                Label position = (Label)this.getView().getControl("positionname_" + mainPersonModel);
                if (positionClickView) {
                    position.setText(mainPersonModel.getPosName());
                }
                if ((postype = (Label)this.getView().getControl("postypeap_" + index)) != null && postypeClickView) {
                    postype.setText(mainPersonModel.getPosType());
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{key});
            }
        }
    }
}

