/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.formplugin.web.adminorg.AdminOrgPermTreeListF7Plugin;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class AdminOrgPermBatchBillTreeListF7Plugin
extends AdminOrgPermTreeListF7Plugin {
    private static final String HRCS = "hrcs";
    private static final String IHRCS_BIZ_DATA_PERMISSION_SERVICE = "IHRCSBizDataPermissionService";
    private static final String CACHE_PERM_ORG_RESULT_WITH_SUB = "perm_org_result_withsub";
    private static final String CACHE_PERM_ORG_RESULT = "perm_org_result";
    private static final String ORG_BATCH_CHG_BILL = "homs_orgbatchchgbill";
    private static final String PERM_PROP_KEY = "adminorgboid";

    @Override
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter structNumberFilter = null;
        if (!this.permOrgResultWithSub.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)this.permOrgResultWithSub.getHasPermOrgsWithSub())) {
            List orgIds = this.permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
            List structNumberList = this.permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(orgSubInfo -> orgSubInfo.isContainsSub()).map(orgSubInfo -> orgSubInfo.getLongStructNumber()).collect(Collectors.toList());
            for (String structNumber : structNumberList) {
                if (structNumberFilter == null) {
                    structNumberFilter = new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%"));
                    continue;
                }
                structNumberFilter.or(new QFilter("structlongnumber", "like", (Object)("%" + structNumber + "%")));
            }
            if (structNumberFilter == null) {
                structNumberFilter = new QFilter("boid", "in", orgIds);
            } else {
                structNumberFilter.or(new QFilter("boid", "in", orgIds));
            }
            setFilterEvent.getQFilters().add(structNumberFilter);
        }
    }

    @Override
    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        if (this.permOrgResultWithSub == null) {
            Long userId = RequestContext.get().getCurrUserId();
            String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT_WITH_SUB);
            if (!HRStringUtils.isEmpty((String)orgResultString)) {
                this.permOrgResultWithSub = (AuthorizedOrgResultWithSub)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResultWithSub.class);
            } else {
                String permItemId = HRPermUtil.getF7ParentPermItemId((IFormView)this.getView());
                this.permOrgResultWithSub = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_BIZ_DATA_PERMISSION_SERVICE, (String)"getUserAdminOrgsF7WithSub", (Object[])new Object[]{userId, "homs", ORG_BATCH_CHG_BILL, permItemId, PERM_PROP_KEY, this.getStructProjectCustomInParam(PERM_PROP_KEY)});
                this.getPageCache().put(CACHE_PERM_ORG_RESULT_WITH_SUB, SerializationUtils.toJsonString((Object)this.permOrgResultWithSub));
            }
        }
        return this.permOrgResultWithSub;
    }

    @Override
    protected AuthorizedStructResult getPermStructProject() {
        if (this.permStructProjectResult == null) {
            Long userId = RequestContext.get().getCurrUserId();
            String orgResultString = this.getPageCache().get(this.CACHE_PERM_STRUCT_PROJECT_RESULT);
            if (!HRStringUtils.isEmpty((String)orgResultString)) {
                this.permStructProjectResult = (AuthorizedStructResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedStructResult.class);
            } else {
                String permItemId = HRPermUtil.getF7ParentPermItemId((IFormView)this.getView());
                this.permStructProjectResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_BIZ_DATA_PERMISSION_SERVICE, (String)"getUserStructProjectsF7", (Object[])new Object[]{userId, "homs", ORG_BATCH_CHG_BILL, permItemId, PERM_PROP_KEY, null});
                this.getPageCache().put(this.CACHE_PERM_STRUCT_PROJECT_RESULT, SerializationUtils.toJsonString((Object)this.permStructProjectResult));
            }
        }
        return this.permStructProjectResult;
    }

    @Override
    protected QFilter getPermFilter() {
        return null;
    }

    protected AuthorizedOrgResult getPermOrgResult() {
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResult.class);
        }
        String permItemId = HRPermUtil.getF7ParentPermItemId((IFormView)this.getView());
        AuthorizedOrgResult permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_BIZ_DATA_PERMISSION_SERVICE, (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, "homs", ORG_BATCH_CHG_BILL, permItemId, PERM_PROP_KEY, this.getStructProjectCustomInParam(PERM_PROP_KEY)});
        this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult));
        return permResult;
    }
}

