/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.QueryExceedMaxCountEvent;
import kd.bos.list.events.QueryExceedMaxCountListener;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.formplugin.web.adminorg.template.AdminOrgPermTreeListBase;
import kd.hr.hbp.business.servicehelper.AppIdServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.perm.HRPermUtil;

public class AdminOrgPermTreeListPlugin
extends AdminOrgPermTreeListBase {
    private static final String IHRCS_PERM_SERVICE = "IHRCSBizDataPermissionService";
    private static final String HRCS = "hrcs";
    private static final String CACHE_PERM_ORG_RESULT = "perm_org_result";
    private static final String CACHE_PERM_ORG_RESULT_WITHSUB = "perm_org_result_withsub";
    private static final String CACHE_PERM_ORG_RESULT_WITHSUB_NUMBER = "perm_org_result_withsub_number";
    private static final String LIST_COUNT = "list_count";

    public void filterColumnSetFilter(SetFilterEvent event) {
        QFilter permFilter;
        AuthorizedOrgResultWithSub permOrgResultWithSub;
        super.filterColumnSetFilter(event);
        String fieldName = event.getFieldName();
        if ("parentorg.name".equals(fieldName) && !(permOrgResultWithSub = this.getPermOrgResultWithSub()).isHasAllOrgPerm() && (permFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)permOrgResultWithSub, (String)"boid")) != null) {
            permFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
            event.setSpecialDataPermQFilter(permFilter);
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        final String listCountStr = this.getView().getPageCache().get(LIST_COUNT);
        QueryExceedMaxCountListener listener = new QueryExceedMaxCountListener(){

            public void queryExceedMaxCount(QueryExceedMaxCountEvent queryExceedMaxCountEvent) {
                if (HRStringUtils.isNotEmpty((String)listCountStr)) {
                    queryExceedMaxCountEvent.setDataCount(Integer.parseInt(listCountStr));
                    queryExceedMaxCountEvent.setCancel(true);
                }
            }
        };
        billList.addQueryExceedMaxCountListener(listener);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObject structDy = this.getModel().getDataEntity().getDynamicObject("structproject");
        if (structDy.getLong("id") == 1010L) {
            this.getView().getPageCache().remove(LIST_COUNT);
            return;
        }
        if (this.listInfoMap != null && this.listInfoMap.containsKey(LIST_COUNT)) {
            this.getView().getPageCache().put(LIST_COUNT, String.valueOf(this.listInfoMap.get(LIST_COUNT)));
        } else {
            this.getView().getPageCache().put(LIST_COUNT, "0");
        }
    }

    @Override
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        if (this.orgTreeModel.isHisTree()) {
            setFilterEvent.getQFilters().add(this.getHisListDataStatusBSedFilter());
        } else {
            setFilterEvent.getQFilters().add(this.getDataStatusAndBSedFilter());
        }
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity(true).getBoolean("chkincludechild");
    }

    public void initialize() {
        super.initialize();
        String billFormId = ((BillList)this.getView().getControl("billlistap")).getBillFormId();
        if (HRStringUtils.equalsIgnoreCase((String)billFormId, (String)"homs_adminorgdetail")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap3"});
        }
    }

    protected boolean isShowDisableAndSearchDate() {
        if (HRStringUtils.equals((String)this.getView().getEntityId(), (String)"haos_adminorglist")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Date getDateParam() {
        String searchDateStr = this.getPageCache().get("searchdate");
        if (searchDateStr == null) {
            return new Date();
        }
        LocalDate searchDate = (LocalDate)JSON.parseObject((String)searchDateStr, LocalDate.class);
        return HRDateTimeUtils.localDate2Date((LocalDate)searchDate);
    }

    protected String getListPermProKey() {
        return "boid";
    }

    protected AuthorizedOrgResult getPermOrgResult() {
        AuthorizedOrgResult authorizedOrgResult;
        String permField;
        boolean isIgnoreDataRule;
        Long userId = RequestContext.get().getCurrUserId();
        String orgResultString = this.getPageCache().get(CACHE_PERM_ORG_RESULT);
        if (!HRStringUtils.isEmpty((String)orgResultString)) {
            return (AuthorizedOrgResult)SerializationUtils.fromJsonString((String)orgResultString, AuthorizedOrgResult.class);
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String permEntityId = listParameter.getBillFormId();
        String permItemId = "47150e89000000ac";
        boolean isF7 = listParameter.isLookUp();
        if (isF7) {
            permEntityId = HRPermUtil.getF7ParentEntityId((IFormView)this.getView());
            permItemId = HRPermUtil.getF7ParentPermItemId((IFormView)this.getView());
        }
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = this.getAppIdWithDealThirdApp((FormShowParameter)listParameter, permEntityId);
        if (this.isCheckIgnoreConfig() && (isIgnoreDataRule = ((Boolean)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"isIgnoreEntityDataRule", (Object[])new Object[]{appId, permEntityId})).booleanValue())) {
            AuthorizedOrgResult permResult = AuthorizedOrgResult.allOrg();
            this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)permResult));
            return permResult;
        }
        String cachedSearchDateStr = this.getPageCache().get("searchdate");
        Date searchDate = HRDateTimeUtils.truncateDate((Date)new Date());
        if (HRStringUtils.isNotEmpty((String)cachedSearchDateStr)) {
            searchDate = (Date)JSON.parseObject((String)cachedSearchDateStr, Date.class);
        }
        if (isF7) {
            permField = this.getParentF7Prop(listParameter);
            authorizedOrgResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, appId, permEntityId, permItemId, permField, this.getStructProjectCustomInParamWithDate(permField)});
        } else {
            permField = this.getListPermProKey();
            authorizedOrgResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)HRCS, (String)IHRCS_PERM_SERVICE, (String)"getUserAdminOrgs", (Object[])new Object[]{userId, appId, permEntityId, permItemId, permField, this.getStructProjectCustomInParamWithDate(permField)});
        }
        if (!authorizedOrgResult.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)authorizedOrgResult.getHasPermOrgs())) {
            HRBaseServiceHelper orgMasterHelper = new HRBaseServiceHelper("haos_adminorgdetail");
            DynamicObjectCollection dynamicObjects = orgMasterHelper.queryOriginalCollection("id,boid", new QFilter[]{new QFilter("id", "in", (Object)authorizedOrgResult.getHasPermOrgs()), new QFilter("datastatus", "!=", (Object)"-2")});
            ArrayList orgBoIdS = new ArrayList(dynamicObjects.size());
            dynamicObjects.stream().forEach(dynamicObject -> orgBoIdS.add(dynamicObject.getLong("boid")));
            authorizedOrgResult.getHasPermOrgs().clear();
            authorizedOrgResult.getHasPermOrgs().addAll(orgBoIdS);
        }
        this.getPageCache().put(CACHE_PERM_ORG_RESULT, SerializationUtils.toJsonString((Object)authorizedOrgResult));
        return authorizedOrgResult;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        return super.getPermOrgResultWithSub();
    }

    private String getParentF7Prop(ListShowParameter listParameter) {
        return this.getParentF7PropWrap(listParameter);
    }

    private String getAppIdWithDealThirdApp(FormShowParameter showParameter, String entityNumber) {
        String entryAppId = HRPermUtil.getAppIdFromShowParam((FormShowParameter)showParameter);
        return AppIdServiceHelper.getPermAppId((String)entryAppId, (String)entityNumber);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            String fieldName = filterColumn.getFieldName();
            if (!HRStringUtils.equals((String)fieldName, (String)"parentorg.name")) continue;
            DynamicObject structDy = this.getModel().getDataEntity().getDynamicObject("structproject");
            if (structDy.getLong("id") == 1010L) {
                return;
            }
            List<ComboItem> combos = this.buildOrgComboItems();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            commonFilterColumn.setComboItems(combos);
            commonFilterColumn.setType("enum");
        }
    }

    private List<ComboItem> buildOrgComboItems() {
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        DynamicObject structDy = this.getModel().getDataEntity().getDynamicObject("structproject");
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        if (!permOrgResultWithSub.isHasAllOrgPerm() && !CollectionUtils.isEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
            List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(orgSubInfo -> orgSubInfo.getOrgId()).collect(Collectors.toList());
            List orgStructLongNumberList = permOrgResultWithSub.getHasPermOrgsWithSub().stream().filter(orgSubInfo -> orgSubInfo.isContainsSub()).map(orgSubInfo -> orgSubInfo.getLongStructNumber()).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = AdminOrgStructRepository.getInstance().queryOriginStructInfoLikeStructNumOrOrgIds("id,adminorg.id,adminorg.name,parentorg.id,parentorg.name", orgStructLongNumberList, orgIds, Long.valueOf(structDy.getLong("id")), "structlongnumber");
            HashSet parengIdSet = Sets.newHashSet();
            for (DynamicObject org : dynamicObjects) {
                if (org == null || org.getLong("parentorg.id") == 0L || parengIdSet.contains(org.getLong("parentorg.id"))) continue;
                parengIdSet.add(org.getLong("parentorg.id"));
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getLong("parentorg.id")));
                item.setValue(String.valueOf(org.getLong("parentorg.id")));
                item.setCaption(new LocaleString(org.getString("parentorg.name")));
                combos.add(item);
            }
        } else {
            DynamicObject[] adminorgDys;
            for (DynamicObject org : adminorgDys = AdminOrgStructRepository.getInstance().queryStructInfoByStruct("adminorg.id,adminorg.name", Long.valueOf(structDy.getLong("id")), "structlongnumber")) {
                if (org == null) continue;
                ComboItem item = new ComboItem();
                item.setId(String.valueOf(org.getLong("adminorg.id")));
                item.setValue(String.valueOf(org.getLong("adminorg.id")));
                item.setCaption(new LocaleString(org.getString("adminorg.name")));
                combos.add(item);
            }
        }
        return combos;
    }
}

