/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDyObjectPropUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class AdminorgDetailStructEntryPlugin
extends HRDataBaseEdit {
    private static Log logger = LogFactory.getLog(AdminorgDetailStructEntryPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setStructProjectEntry();
    }

    private void setStructProjectEntry() {
        Long userId = RequestContext.get().getCurrUserId();
        String boIdStr = (String)this.getView().getFormShowParameter().getCustomParams().get("boid");
        long boId = Long.parseLong(boIdStr);
        AuthorizedStructResult permResult = (AuthorizedStructResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserStructProjectsF7", (Object[])new Object[]{userId, "homs", "haos_adminorgdetail", "47150e89000000ac", "boid", null});
        DynamicObject[] structArr = permResult.isHasAllStruct() ? StructProjectRepository.getInstance().queryAllStructArrBySyncorg() : StructProjectRepository.getInstance().queryAllStructArrBySyncorg(permResult.getAuthorizedStructs(), "id,parentorg.id,parentorg.structnumber,parentorg.sourcevid");
        if (structArr.length > 0) {
            HashMap orgStructMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet orgStructNumberSet = Sets.newHashSet();
            DynamicObject[] orgStructDyArr = AdminOrgStructRepository.getInstance().queryHisEffStructInfoByOrgId("id,parentorg,structproject,structlongnumber", Long.valueOf(boId), this.getSearchDate());
            if (orgStructDyArr.length == 0) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"structproject_flex"});
                this.getView().sendFormAction(this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()));
            }
            for (DynamicObject orgStructDy : orgStructDyArr) {
                orgStructMap.put(orgStructDy.getLong("structproject.id"), orgStructDy);
                String structLongNumber = orgStructDy.getString("structlongnumber");
                if (!HRStringUtils.isNotEmpty((String)structLongNumber)) continue;
                String[] structNumberArr = structLongNumber.split("!");
                Arrays.asList(structNumberArr).stream().forEach(structNumber -> orgStructNumberSet.add(structNumber));
            }
            String selectField = "id, name, number, boid, enable, structnumber,isvirtualorg";
            DynamicObject[] adminOrgInfoArr = AdOrgRepository.getInstance().queryOriginalByStructNumber(selectField, (Set)orgStructNumberSet);
            Map<String, DynamicObject> adminOrgDynMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getString("structnumber"), adminOrgInfo -> adminOrgInfo));
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("struct_project", new Object[0]);
            vs.addField("struct_parent_org", new Object[0]);
            vs.addField("struct_long_name", new Object[0]);
            for (int i = 0; i < structArr.length; ++i) {
                DynamicObject structDy = structArr[i];
                if (!orgStructMap.containsKey(structDy.getLong("id"))) continue;
                vs.addRow(new Object[]{structDy.getLong("id"), this.getParentIdByStruct(structDy.getLong("id"), orgStructMap), this.getStructLongNameByStruct(structDy.getLong("id"), orgStructMap, adminOrgDynMap)});
            }
            if (vs.getCount() == 0) {
                this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).setVisible(Boolean.valueOf(false), new String[]{"structproject_flex"});
                this.getView().sendFormAction(this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()));
            } else {
                model.batchCreateNewEntryRow("struct_project_entry", vs);
                model.endInit();
                this.getView().updateView("struct_project_entry");
            }
        } else {
            this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).setVisible(Boolean.valueOf(false), new String[]{"structproject_flex"});
            this.getView().sendFormAction(this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()));
        }
    }

    private Long getParentIdByStruct(Long structId, Map<Long, DynamicObject> orgStructMap) {
        if (orgStructMap.containsKey(structId)) {
            DynamicObject structInfoDy = orgStructMap.get(structId);
            return HRDyObjectPropUtil.getId((DynamicObject)structInfoDy.getDynamicObject("parentorg"));
        }
        return null;
    }

    private String getStructLongNameByStruct(Long structId, Map<Long, DynamicObject> orgStructMap, Map<String, DynamicObject> adminOrgDynMap) {
        if (orgStructMap.containsKey(structId)) {
            DynamicObject structInfoDy = orgStructMap.get(structId);
            String structLongNumber = structInfoDy.getString("structlongnumber");
            if (HRStringUtils.isEmpty((String)structLongNumber)) {
                return "";
            }
            String[] structnumberArr = structLongNumber.split("!");
            StringBuilder structLongNameBuilder = new StringBuilder();
            String nameSeparator = HaosOrgUnitServiceHelper.getFullNameSep();
            for (int i = 0; i < structnumberArr.length - 1; ++i) {
                String structnumber = structnumberArr[i];
                DynamicObject adminorgDy = adminOrgDynMap.get(structnumber);
                if (adminorgDy == null) continue;
                structLongNameBuilder.append(nameSeparator).append(adminorgDy.getString("name"));
            }
            if (HRStringUtils.isNotEmpty((String)structLongNameBuilder.toString())) {
                return structLongNameBuilder.substring(nameSeparator.length());
            }
        }
        return "";
    }

    private Date getSearchDate() {
        Object searchDateOb = this.getView().getFormShowParameter().getCustomParams().get("searchdate");
        Date searchDate = new Date();
        if (null != searchDateOb) {
            try {
                searchDate = searchDateOb instanceof String ? HRDateTimeUtils.parseDate((String)((String)searchDateOb)) : (Date)searchDateOb;
            }
            catch (ParseException parseException) {
                logger.error((Throwable)parseException);
            }
        }
        return searchDate;
    }
}

