/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.list.QueryResult;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.model.MainPersonModel;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisMainPeopleListProvider
extends ListDataProvider {
    private List<MainPersonModel> modelList;
    private DynamicObjectCollection dyColResult;
    private String belongCompName;
    private String belongDeptName;
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String HEAD_SCULPTURE = "headsculpture";
    private static final String PERSON_NAME = "personname";
    private static final String PERSON_NUMBER = "personnumber";
    private static final String POS_TYPE = "postype";
    private static final String POS_NAME = "posname";
    private static final String STAND_POSITION_NAME = "standposition";
    private static final String COMPANY = "company";
    private static final String DEPARTMENT = "department";
    private static final String LABOR_REL_STATUS = "laborrelstatus";
    private static final String LABOR_REL_TYPE = "laborreltype";
    private static final String IS_PRIMARY = "isprimary";

    public HisMainPeopleListProvider(List<MainPersonModel> modelList, String belongCompName, String belongDeptName) {
        this.modelList = modelList;
        this.belongCompName = belongCompName;
        this.belongDeptName = belongDeptName;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection((DynamicObjectType)this.getEntityType(), null);
        for (int i = start; i < Math.min(start + limit, this.modelList.size()); ++i) {
            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)this.getEntityType());
            MainPersonModel mainPersonModel = this.modelList.get(i);
            dynamicObject.set("id", (Object)mainPersonModel.getPersonId());
            dynamicObject.set(PERSON_NAME, (Object)mainPersonModel.getPersonName());
            dynamicObject.set(PERSON_NUMBER, (Object)mainPersonModel.getPersonNumber());
            if (HRStringUtils.isNotEmpty((String)mainPersonModel.getHeadSculpture())) {
                dynamicObject.set(HEAD_SCULPTURE, (Object)HRImageUrlUtil.getImageFullUrl((String)mainPersonModel.getHeadSculpture()));
            }
            dynamicObject.set(POS_NAME, (Object)mainPersonModel.getPosName());
            dynamicObject.set(STAND_POSITION_NAME, (Object)mainPersonModel.getStdPosName());
            dynamicObject.set(POS_TYPE, (Object)mainPersonModel.getPosType());
            dynamicObject.set(LABOR_REL_STATUS, (Object)mainPersonModel.getLaborRelStatus());
            dynamicObject.set(LABOR_REL_TYPE, (Object)mainPersonModel.getLaborRelType());
            dynamicObject.set(START_DATE, (Object)TimeConvertUtil.localDateTime2Date((LocalDateTime)mainPersonModel.getStartDate()));
            dynamicObject.set(END_DATE, (Object)TimeConvertUtil.localDateTime2Date((LocalDateTime)mainPersonModel.getEndDate()));
            dynamicObject.set(IS_PRIMARY, (Object)mainPersonModel.getPrimary());
            dynamicObject.set(COMPANY, (Object)this.belongCompName);
            dynamicObject.set(DEPARTMENT, (Object)this.belongDeptName);
            dynamicObjectCollection.add((Object)dynamicObject);
        }
        this.dyColResult = dynamicObjectCollection;
        return dynamicObjectCollection;
    }

    public QueryResult getQueryResult() {
        QueryResult queryResult = new QueryResult();
        queryResult.setDataCount(this.dyColResult.size());
        queryResult.setBillDataCount(this.dyColResult.size());
        queryResult.setCollection(this.dyColResult);
        return queryResult;
    }

    public int getMaxCount() {
        return this.modelList.size();
    }
}

