/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.HaosOrgUnitServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class NewAdminorgDetailEditPlugin
extends HRDataBaseEdit {
    private final String TOBEDISABLEFLAG = "tobedisableflag";
    private final String BSED = "bsed";
    private final String TOBEDISABLEDATE = "tobedisabledate";
    private final String DISABLEDATE = "disabledate";
    private final String DEPARTMENT_TYPE = "departmenttype";
    private final String SYSTEM_TYPE = "hrmp-haos-formplugin";
    private static Log logger = LogFactory.getLog(NewAdminorgDetailEditPlugin.class);
    private static HRBaseServiceHelper ADMIN_ORG_TYPE = new HRBaseServiceHelper("haos_adminorgdetail");
    private static final String[] DATA_STATUS_SHC_EFF_INV = new String[]{"0", "1", "2"};
    private static final String[] DATA_STATUS_EFF_INV = new String[]{"1", "2"};

    public void afterBindData(EventObject eventObject) {
        String hideSafeInfo;
        this.getView().setFormTitle(new LocaleString(this.getView().getFormShowParameter().getCaption()));
        super.afterBindData(eventObject);
        this.showTop();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"attachmeflex"});
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.getModel().setValue("deptlongname", (Object)"-");
        this.showDate(dataEntity);
        long boId = dataEntity.getLong("boid");
        DynamicObject belongCompany = ADMIN_ORG_TYPE.queryOne("id", this.buildHisFilter("boid", dataEntity.getLong("belongcompany.boid")));
        this.getModel().setValue("belongcompany", (Object)belongCompany);
        DynamicObject parentOrg = ADMIN_ORG_TYPE.queryOne("id", this.buildHisFilter("boid", dataEntity.getLong("parentorg.boid")));
        this.getModel().setValue("parentorg", (Object)parentOrg);
        Long adminOrgTypeId = (Long)this.getModel().getDataEntity().get("adminorgtype.adminorgtypestd.id");
        if (Objects.nonNull(adminOrgTypeId)) {
            this.handleOrgType(boId, String.valueOf(adminOrgTypeId));
        }
        if (HRStringUtils.isNotEmpty((String)(hideSafeInfo = (String)this.getView().getFormShowParameter().getCustomParam("hideSafeInfo"))) && HRStringUtils.equals((String)"1", (String)hideSafeInfo)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"safeinfo"});
        }
        String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)this.getModel().getDataEntity().getLong("boid"), (Date)this.getSearchDate(), (String)String.valueOf(AdminOrgConstants.ADMINORG_STRUCT));
        this.getModel().setValue("orglongname", (Object)orgLongName);
        this.setOrgStructInfo(boId);
        this.showStructEntry();
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void setOrgStructInfo(Long orgBoId) {
        String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
        if (HRStringUtils.isEmpty((String)structProjectIdStr)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"struct_name", "struct_parent_org"});
            return;
        }
        DynamicObject structDy = AdminOrgStructRepository.getInstance().queryStructHisByIdAndProjId("id,name,parentorg,structlongnumber", orgBoId, this.getSearchDate(), Long.valueOf(structProjectIdStr));
        if (structDy == null) {
            return;
        }
        DynamicObject structParentDy = structDy.getDynamicObject("parentorg");
        if (structParentDy != null) {
            DynamicObject parentOrg = ADMIN_ORG_TYPE.queryOne("id", this.buildHisFilter("boid", structParentDy.getLong("id")));
            this.getModel().setValue("struct_parent_org", (Object)parentOrg);
            String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)structParentDy.getLong("id"), (Date)this.getSearchDate(), (String)structProjectIdStr);
            orgLongName = StringUtils.isEmpty((CharSequence)orgLongName) ? this.getModel().getDataEntity().getString("name") : orgLongName + HaosOrgUnitServiceHelper.getFullNameSep() + this.getModel().getDataEntity().getString("name");
            this.getModel().setValue("struct_name", (Object)orgLongName);
        } else {
            this.getModel().setValue("struct_name", (Object)this.getModel().getDataEntity().getString("name"));
        }
        if (AdminOrgConstants.ADMINORG_STRUCT.equals(Long.valueOf(structProjectIdStr))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"struct_name", "struct_parent_org"});
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setStatus(OperationStatus.VIEW);
    }

    private void showTop() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("topinfo");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"boid");
        if (this.getView().getEntityId().equals("homs_adminorgdetail")) {
            formShowParameter.setFormId("homs_orgdetailtopinfo");
        } else {
            formShowParameter.setFormId("haos_orgdetailtopinfo");
        }
        formShowParameter.setCustomParam("structproject", this.getView().getFormShowParameter().getCustomParam("structproject"));
        formShowParameter.setCustomParam("visableChange", (Object)"false");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        formShowParameter.setCustomParam("currentObjectPKId", (Object)dataEntity.getString("boid"));
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("searchdate", (Object)this.getSearchDate());
        this.getView().showForm(formShowParameter);
    }

    private Date getSearchDate() {
        Object searchDateOb = this.getView().getFormShowParameter().getCustomParams().get("searchdate");
        Date searchDate = new Date();
        if (null != searchDateOb) {
            try {
                searchDate = searchDateOb instanceof String ? HRDateTimeUtils.parseDate((String)((String)searchDateOb)) : (Date)searchDateOb;
            }
            catch (ParseException parseException) {
                logger.error((Throwable)parseException);
            }
        }
        return searchDate;
    }

    private QFilter buildHisFilter(String property, Object ... id) {
        Date searchDate = this.getSearchDate();
        QFilter filter = new QFilter(property, "in", (Object)id);
        if (searchDate == null) {
            filter.and(new QFilter("iscurrentversion", "in", (Object)"1"));
        } else {
            filter.and(new QFilter("bsed", "<=", (Object)searchDate));
            filter.and(new QFilter("bsled", ">=", (Object)searchDate));
            String isShowScheduleEffect = (String)this.getView().getFormShowParameter().getCustomParam("isShowScheduleEffect");
            String[] dataStatusArr = !HRStringUtils.isEmpty((String)isShowScheduleEffect) && "1".equals(isShowScheduleEffect) ? DATA_STATUS_SHC_EFF_INV : DATA_STATUS_EFF_INV;
            QFilter statusFilter = new QFilter("datastatus", "in", (Object)dataStatusArr);
            filter.and(statusFilter);
            filter.and("iscurrentversion", "=", (Object)"0");
        }
        return filter;
    }

    private void showDate(DynamicObject dataEntity) {
        Object toBeDisableFlag = dataEntity.get("tobedisableflag");
        boolean flag = toBeDisableFlag == null ? Boolean.FALSE : (Boolean)toBeDisableFlag;
        String enable = dataEntity.getString("enable");
        this.getView().setVisible(Boolean.FALSE, new String[]{"bsed", "tobedisabledate", "disabledate"});
        if (enable.equals("1")) {
            if (!flag) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bsed"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"tobedisabledate"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"disabledate"});
        }
    }

    private void handleOrgType(Long boId, String orgTypeId) {
        QFilter buildDateFilter = this.buildHisFilter("adminorg", boId);
        HRBaseServiceHelper companyHelper = new HRBaseServiceHelper("haos_adminorgcompany");
        DynamicObject companyObject = companyHelper.queryOriginalOne("companytype,industrytype,bsed", new QFilter[]{buildDateFilter});
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        AnchorItems baseItem = new AnchorItems("baseinfoflex", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"NewAdminorgDetailEditPlugin_20", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        AnchorItems companyItem = new AnchorItems("companyinfoflex", ResManager.loadKDString((String)"\u516c\u53f8\u4fe1\u606f", (String)"NewAdminorgDetailEditPlugin_21", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        ArrayList<AnchorItems> anchorItems = new ArrayList<AnchorItems>();
        anchorItems.add(baseItem);
        switch (orgTypeId) {
            case "1010": {
                this.groupSetting(buildDateFilter, companyObject, companyItem, anchorItems);
                break;
            }
            case "1020": {
                this.companySetting(companyObject, companyItem, anchorItems);
                break;
            }
            case "1030": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"companyinfoflex", "groupinfoflex", "deptinfoflex"});
                break;
            }
            case "1040": {
                this.departmentSetting(boId, buildDateFilter, anchorItems);
                break;
            }
        }
        AnchorItems orgStatusItem = new AnchorItems("statusinfoflex", ResManager.loadKDString((String)"\u7ec4\u7ec7\u72b6\u6001", (String)"NewAdminorgDetailEditPlugin_27", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(orgStatusItem);
        AnchorItems orgDutyItem = new AnchorItems("orgdutyflex", ResManager.loadKDString((String)"\u7ec4\u7ec7\u804c\u8d23", (String)"NewAdminorgDetailEditPlugin_24", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(orgDutyItem);
        if (this.getView().getEntityId().equals("homs_adminorgdetail")) {
            AnchorItems coopItem = new AnchorItems("collaborationflex", ResManager.loadKDString((String)"\u534f\u4f5c\u5173\u7cfb", (String)"NewAdminorgDetailEditPlugin_26", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
            anchorItems.add(coopItem);
        }
        AnchorItems safeItem = new AnchorItems("safeinfoflex", ResManager.loadKDString((String)"\u4fdd\u5bc6\u4fe1\u606f", (String)"NewAdminorgDetailEditPlugin_25", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        String hideSafeInfo = (String)this.getView().getFormShowParameter().getCustomParam("hideSafeInfo");
        if (HRStringUtils.isEmpty((String)hideSafeInfo) || !HRStringUtils.equals((String)"1", (String)hideSafeInfo)) {
            anchorItems.add(safeItem);
        }
        anchorCtl.addItems(anchorItems);
        anchorCtl.setHighlight(true);
    }

    private void companySetting(DynamicObject companyObject, AnchorItems companyItem, List<AnchorItems> anchorItems) {
        if (companyObject != null) {
            this.getModel().setValue("companytype", companyObject.get("companytype"));
            this.getModel().setValue("industrytype", companyObject.get("industrytype"));
        }
        anchorItems.add(companyItem);
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupinfoflex", "deptinfoflex"});
    }

    private void departmentSetting(Long boId, QFilter buildDateFilter, List<AnchorItems> anchorItems) {
        HRBaseServiceHelper deptHelper = new HRBaseServiceHelper("haos_adminorgdepartment");
        DynamicObject deptObject = deptHelper.queryOriginalOne("departmenttype,bsed", new QFilter[]{buildDateFilter});
        if (deptObject != null) {
            this.getModel().setValue("departmenttype", deptObject.get("departmenttype"));
        }
        AnchorItems deptItem = new AnchorItems("deptinfoflex", ResManager.loadKDString((String)"\u90e8\u95e8\u4fe1\u606f", (String)"NewAdminorgDetailEditPlugin_23", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(deptItem);
        this.getView().setVisible(Boolean.FALSE, new String[]{"companyinfoflex", "groupinfoflex"});
        this.setDeptLongName(boId);
    }

    private void groupSetting(QFilter buildDateFilter, DynamicObject companyObject, AnchorItems companyItem, List<AnchorItems> anchorItems) {
        HRBaseServiceHelper groupHelper = new HRBaseServiceHelper("haos_adminorggroup");
        DynamicObject groupObject = groupHelper.queryOne("groupvision,groupmission,bsed", new QFilter[]{buildDateFilter});
        if (groupObject != null) {
            this.getModel().setValue("groupvision", groupObject.get("groupvision"));
            this.getModel().setValue("groupmission", groupObject.get("groupmission"));
        }
        if (companyObject != null) {
            this.getModel().setValue("companytype", companyObject.get("companytype"));
            this.getModel().setValue("industrytype", companyObject.get("industrytype"));
        }
        AnchorItems groupItem = new AnchorItems("groupinfoflex", ResManager.loadKDString((String)"\u96c6\u56e2\u4fe1\u606f", (String)"NewAdminorgDetailEditPlugin_22", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), null);
        anchorItems.add(groupItem);
        anchorItems.add(companyItem);
        this.getView().setVisible(Boolean.FALSE, new String[]{"deptinfoflex"});
    }

    private void setDeptLongName(Long boId) {
        String structNumber;
        String name;
        HRBaseServiceHelper structServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        DynamicObject structInfoDyn = structServiceHelper.queryOne("structlongnumber", new QFilter[]{this.buildHisFilter("adminorg", boId), (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()});
        if (structInfoDyn == null) {
            return;
        }
        String structLongNumber = structInfoDyn.getString("structlongnumber");
        Object[] structNumbers = structLongNumber.split("!");
        DynamicObject[] adminOrgInfos = ADMIN_ORG_TYPE.query("id,structnumber,name", new QFilter[]{new QFilter("adminorgtype.adminorgtypestd.id", "=", (Object)1040L), this.buildHisFilter("structnumber", structNumbers)});
        Map<String, String> structNumberMap = Arrays.stream(adminOrgInfos).collect(Collectors.toMap(dy -> dy.getString("structnumber"), dy -> dy.getString("name")));
        List reverseStructLongNumbers = Lists.reverse(Arrays.asList(structNumbers));
        ArrayList<String> deptName = new ArrayList<String>(16);
        Iterator iterator = reverseStructLongNumbers.iterator();
        while (iterator.hasNext() && !HRStringUtils.isEmpty((String)(name = structNumberMap.get(structNumber = (String)iterator.next())))) {
            deptName.add(name);
        }
        if (deptName.size() == 0) {
            logger.info(String.format("==setDeptLongName,reverseStructLongNumbers:%s", reverseStructLongNumbers));
            return;
        }
        String deptLongName = String.join((CharSequence)HaosOrgUnitServiceHelper.getFullNameSep(), Lists.reverse(deptName));
        this.getModel().setValue("deptlongname", (Object)deptLongName);
    }

    private void showStructEntry() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("struct_panelap");
        formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"boid");
        formShowParameter.setFormId("haos_adminorgdetailstruct");
        formShowParameter.setCustomParam("boid", (Object)this.getModel().getDataEntity().getString("boid"));
        formShowParameter.setCustomParam("visableChange", (Object)"false");
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.setCustomParam("searchdate", (Object)this.getSearchDate());
        this.getView().showForm(formShowParameter);
    }
}

