/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.haos.business.servicehelper.AdminOrgQueryServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ShowMoreLeadersPlugin
extends HRDataBaseEdit {
    private static final String LEADER_LIST = "leaderlist";
    private static final String MORE_AP = "moreap";
    private static final String CLICK_VIEW = "click_view";
    private static final String HEAD_SCULPTURE = "headsculpture";
    private static final String PERSON_NAME = "personname";
    private static final String PERSON_NUMBER = "personnumber";
    private static final String POS_TYPE = "postype";
    private static final String POS_NAME = "posname";
    private static final String POSTION = "position";
    private static final String DEPARTMENT = "department";
    private static final String ADMIN_ORG_NAME = "adminorg.name";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String moreap = (String)formShowParameter.getCustomParam(MORE_AP);
        List lists = JSON.parseArray((String)moreap, Map.class);
        List<Object> personList = this.mergePersonList(lists);
        boolean checkDesensitize = this.checkDesensitize(personList);
        if (!checkDesensitize) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{CLICK_VIEW});
        }
        this.setPersonToLeaderList(personList);
    }

    private void setPersonToLeaderList(List personList) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        vs.addField(HEAD_SCULPTURE, new Object[0]);
        vs.addField(PERSON_NAME, new Object[0]);
        vs.addField(PERSON_NUMBER, new Object[0]);
        vs.addField(DEPARTMENT, new Object[0]);
        vs.addField(POS_NAME, new Object[0]);
        vs.addField(POS_TYPE, new Object[0]);
        for (int i = personList.size() - 1; i >= 0; --i) {
            Map map = (Map)personList.get(i);
            vs.addRow(new Object[]{map.get(HEAD_SCULPTURE), map.get("name"), map.get("number"), map.get(ADMIN_ORG_NAME), map.get(POSTION), map.get(POS_TYPE)});
        }
        model.batchCreateNewEntryRow(LEADER_LIST, vs);
        model.endInit();
        this.getView().updateView(LEADER_LIST);
    }

    private List<Object> mergePersonList(List<Map> personList) {
        HashMap<String, Map> perListMap = new HashMap<String, Map>();
        for (Map map : personList) {
            String personId = String.valueOf(map.get("person"));
            if (perListMap.containsKey(personId)) {
                Map mergeMap = (Map)perListMap.get(personId);
                String postype = (String)mergeMap.get(POS_TYPE);
                String postype1 = (String)map.get(POS_TYPE);
                if (!HRStringUtils.equals((String)postype1, (String)postype)) {
                    mergeMap.put(POS_TYPE, "");
                }
                String position = (String)mergeMap.get(POSTION);
                String position1 = (String)map.get(POSTION);
                position = HRStringUtils.isNotEmpty((String)position) ? position + "\u3001" + position1 : position1;
                mergeMap.put(POSTION, position);
                continue;
            }
            perListMap.put(personId, map);
        }
        return perListMap.values().stream().collect(Collectors.toList());
    }

    private boolean checkDesensitize(List personList) {
        boolean desensitizeStatus = false;
        boolean namePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null);
        boolean personnumberPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null);
        boolean postypePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)POS_TYPE, (String)Lang.get().toString(), (String)"LIST", null);
        boolean positionPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)POSTION, (String)Lang.get().toString(), (String)"LIST", null);
        if (namePrivacy || personnumberPrivacy || postypePrivacy || positionPrivacy) {
            desensitizeStatus = true;
        }
        for (int i = 0; i < personList.size(); ++i) {
            Map map = (Map)personList.get(i);
            if (namePrivacy) {
                String personName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, map.get("name"));
                map.put("name", personName);
            }
            if (personnumberPrivacy) {
                String personNumber = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null, map.get("number"));
                map.put("number", personNumber);
            }
            if (postypePrivacy) {
                String posType = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)POS_TYPE, (String)Lang.get().toString(), (String)"LIST", null, map.get(POS_TYPE));
                map.put(POS_TYPE, posType);
            }
            if (!positionPrivacy) continue;
            String posName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)POSTION, (String)Lang.get().toString(), (String)"LIST", null, map.get(POSTION));
            map.put(POSTION, posName);
        }
        return desensitizeStatus;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLICK_VIEW});
    }

    public void click(EventObject evt) {
        super.click(evt);
        EntryGrid strategyEntryGrid = (EntryGrid)this.getView().getControl(LEADER_LIST);
        int row = strategyEntryGrid.getEntryState().getFocusRow();
        this.clickRowView(row);
    }

    private void clickRowView(int clickRowIndex) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String moreap = (String)formShowParameter.getCustomParam(MORE_AP);
        List lists = JSON.parseArray((String)moreap, Map.class);
        List<Object> personList = this.mergePersonList(lists);
        boolean nameClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"name");
        boolean personnumberClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_person", (String)"number");
        boolean postypeClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)POS_TYPE);
        boolean positionClickView = AdminOrgQueryServiceHelper.checkClickView((String)"hrpi_depemp", (String)POSTION);
        Map map = (Map)personList.get(personList.size() - 1 - clickRowIndex);
        if (nameClickView) {
            this.getView().getModel().setValue(PERSON_NAME, map.get("name"), clickRowIndex);
        }
        if (personnumberClickView) {
            this.getView().getModel().setValue(PERSON_NUMBER, map.get("number"), clickRowIndex);
        }
        if (postypeClickView) {
            this.getView().getModel().setValue(POS_TYPE, map.get(POS_TYPE), clickRowIndex);
        }
        if (positionClickView) {
            this.getView().getModel().setValue(POS_NAME, map.get(POSTION), clickRowIndex);
        }
    }
}

