/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.mob;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.formplugin.web.HRDataBaseMobList;

public class AdminOrgMobListPlugin
extends HRDataBaseMobList {
    private static final String KEY_LONG_NAME = "nodbstrfield";
    private Map<Long, String> idVsLongName;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        Set idSet = e.getPageData().stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        this.idVsLongName = OrgBatchBillHelper.getBelongCompanyByAdId(idSet, (Date)this.getCustomDate());
    }

    public void packageData(PackageDataEvent e) {
        String fieldName = ((ColumnDesc)e.getSource()).getKey();
        if (KEY_LONG_NAME.equals(fieldName)) {
            e.setFormatValue((Object)this.idVsLongName.getOrDefault(e.getRowData().getLong("id"), ""));
        }
    }

    private Date getCustomDate() {
        String dateString = (String)this.getView().getFormShowParameter().getCustomParam("query_date");
        return OrgDateTimeUtil.str2DateIfNullToday((String)dateString, (boolean)true);
    }
}

