/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.report;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FloatingDirection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.formplugin.web.adminorg.util.TreeNodeNameSetter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.business.util.OrgServiceUtil;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.AuthorizedStructResult;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.structproject.StructProjectCapable;
import kd.hr.hbp.formplugin.web.org.structproject.imp.AdminOrgSpProcessor;

public class AbstractReportPlugin
extends AbstractReportFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
BeforeF7SelectListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private OrgTreeModel orgTreeModel;
    private TreeNode rootNode;
    private static final String CUR_TREE_ROOT_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid,adminorg.name name, structlongnumber, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag";
    private static final String CUR_SUB_TREE_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid, adminorg.name name, parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag";
    private static final String CUR_SUB_TREE_FIELDS = " id, boid , name , parentorg,'' isleaf, structlongnumber, enable, tobedisableflag";
    private List<String> allPermLongNumberList;
    private QFilter dataStatusAndBSedFilter;
    private QFilter orgEnableFilter;
    public static final String SELECT_ALL_TREENODE = "select_all_treenode";
    String subTreeOrderBys = "sortcode";
    private static final String CHK_INCLUDE_CHILD = "chkincludechild";
    private String orgStructNumberProperty = "adminorg.structnumber";
    private TreeNodeNameSetter treeNodeNameSetter;
    private TreeView treeView;
    private Boolean isShowDisable = null;
    public static final String PARENT_ORG = "parentorg";
    private StructProjectCapable structProjectCapable;

    public void initialize() {
        super.initialize();
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", KEY_TREEVIEW);
        hashMap.put("labelShowType", 1);
        service.addAction("u", hashMap);
        this.orgTreeModel = this.getOrgTreeModel();
        this.treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        this.orgStructNumberProperty = this.orgTreeModel.isHisTree() ? "adminorg.structnumber" : "structnumber";
        this.treeNodeNameSetter = new TreeNodeNameSetter();
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        if (this.structProjectCapable == null) {
            this.structProjectCapable = new AdminOrgSpProcessor();
        }
        this.structProjectCapable.wrapView((IFormView)this.getView());
        this.structProjectCapable.setPropKeySupplier(() -> {
            if (this.getView().getFormShowParameter() instanceof ListShowParameter && ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp()) {
                return null;
            }
            return this.getListPermProKey();
        });
        this.structProjectCapable.setGetStructProjectPerm(this::getPermStructProject);
    }

    protected String getListPermProKey() {
        return "boid";
    }

    public void afterCreateNewData(EventObject e) {
        if (this.structProjectCapable.enableStructProjectCode()) {
            this.setDefaultStructProject();
            this.markStructProjectInitFinish();
        }
    }

    private void setDefaultStructProject() {
        if (this.hasStructProjectControl()) {
            this.getModel().setValue("structproject", (Object)this.structProjectCapable.getStructProject());
            this.cacheStructProject4perm();
        }
    }

    public final boolean hasStructProjectControl() {
        return this.getModel().getProperty("structproject") != null;
    }

    private void cacheStructProject4perm() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.structProjectCapable.getStructProject().getString("id"));
        this.getView().getPageCache().put("tree_perm_structprojectids", SerializationUtils.toJsonString(list));
    }

    private void markStructProjectInitFinish() {
        this.getPageCache().put("struct_project_init_finish", "true");
    }

    protected AuthorizedStructResult getPermStructProject() {
        return null;
    }

    public void propertyChanged(PropertyChangedArgs changedArgs) {
        String propertyName = changedArgs.getProperty().getName();
        if (CHK_INCLUDE_CHILD.equals(propertyName)) {
            Map focusNode = this.treeView.getTreeState().getFocusNode();
            this.getView().getPageCache().put(CHK_INCLUDE_CHILD, String.valueOf((Boolean)changedArgs.getChangeSet()[0].getNewValue()));
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)((String)focusNode.get("parentid")), (Object)((String)focusNode.get("id"))));
        } else if ("structproject".equals(propertyName)) {
            ChangeData changeData = changedArgs.getChangeSet()[0];
            if (changeData.getNewValue() == null) {
                this.getModel().setValue("structproject", changeData.getOldValue());
                return;
            }
            TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)this.getPageCache());
            this.structProjectCapable.propertyChanged(changedArgs);
            this.treeView.deleteAllNodes();
            TreeNode treeNode = this.init();
            this.treeView.updateNode(treeNode);
            this.treeView.updateNodes(treeNode.getChildren());
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)treeNode.getParentid(), (Object)treeNode.getId()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init();
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        if (queryParam.getCustomParam().get("orgIds") == null) {
            if (this.rootNode == null) {
                this.rootNode = this.init();
            }
            AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
            HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
            if (permOrgResultWithSub.isHasAllOrgPerm()) {
                param.put("orgIds", Collections.singletonList(Long.valueOf(this.rootNode.getId())));
            } else {
                List permOrgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(per -> per.getOrgId()).collect(Collectors.toList());
                if (permOrgIds.contains(Long.valueOf(this.rootNode.getId()))) {
                    param.put("orgIds", Collections.singletonList(Long.valueOf(this.rootNode.getId())));
                } else {
                    param.put("orgIds", Collections.singletonList(-1L));
                }
            }
            queryParam.setCustomParam(param);
        }
    }

    private TreeNode init() {
        this.orgTreeModel = this.getOrgTreeModel();
        this.rootNode = this.initAllOrgTree();
        this.treeView.addNode(this.rootNode);
        if (this.treeView.getTreeState().getFocusNode() == null) {
            this.treeView.focusNode(this.rootNode);
        }
        if (this.rootNode.getChildren().isEmpty()) {
            this.rootNode.setLeaf(true);
            this.rootNode.setChildren(null);
        }
        return this.rootNode;
    }

    protected OrgTreeModel getOrgTreeModel() {
        return new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE.booleanValue());
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if ("org_tree_filter".equals(control.getKey())) {
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, control.getKey());
            this.showAdminOrgTreeFilterDialog(closeCallBack, control.getKey());
        }
    }

    private void showAdminOrgTreeFilterDialog(CloseCallBack closeCallBack, String key) {
        FormShowParameter formShowParameter = new FormShowParameter();
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Floating);
        openStyle.setFloatingDirection(FloatingDirection.RightCenter);
        openStyle.setTargetKey(key);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("140px");
        cssValue.setHeight("50px");
        openStyle.setInlineStyleCss(cssValue);
        formShowParameter.setFormId("haos_reportorgtreefilter");
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u663e\u793a\u7981\u7528", (String)"AbstractReportPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        formShowParameter.setCloseCallBack(closeCallBack);
        String chkShowDisable = this.getPageCache().get("chkshowdisable" + key);
        formShowParameter.setCustomParam("chkshowdisable", (Object)chkShowDisable);
        this.getView().showForm(formShowParameter);
    }

    public void registerListener(EventObject e) {
        this.addlistener();
    }

    private void addlistener() {
        this.treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        this.treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"org_tree_filter"});
        this.addClickListeners(new String[]{CHK_INCLUDE_CHILD});
        BasedataEdit structProjectBdEdit = (BasedataEdit)this.getControl("structproject");
        if (structProjectBdEdit != null) {
            structProjectBdEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (!HRStringUtils.isEmpty((String)searchText)) {
                this.searchFromLazyOrgTree(searchText, this.rootNode);
            }
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("org_tree_filter".equals(actionId)) {
            Boolean checkShowDisable = (Boolean)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
            String checkShowDisableStr = checkShowDisable != null ? String.valueOf(checkShowDisable) : "false";
            String oldCheckShowDisableStr = this.getPageCache().get("chkshowdisable" + actionId);
            String string = oldCheckShowDisableStr = HRStringUtils.isEmpty((String)oldCheckShowDisableStr) ? "false" : oldCheckShowDisableStr;
            if (!oldCheckShowDisableStr.equals(checkShowDisableStr)) {
                this.isShowDisable = Boolean.parseBoolean(checkShowDisableStr);
                TreeNode treeNode = this.init();
                this.treeView.updateNode(treeNode);
                this.treeView.updateNodes(treeNode.getChildren());
                this.getPageCache().put("chkshowdisable" + actionId, String.valueOf(checkShowDisableStr));
            }
        }
    }

    public void searchFromLazyOrgTree(String searchText, TreeNode rootNode) {
        TreeView allOrgTreeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        this.rootNode = this.initAllOrgTree();
        allOrgTreeView.addNode(rootNode);
        boolean isFirstSearch = true;
        if (!StringUtils.isBlank((CharSequence)searchText)) {
            List<Object> treeNodes = Lists.newArrayListWithCapacity((int)16);
            IPageCache pageCache = this.getView().getPageCache();
            String oldSearchText = pageCache.get("org_oldSearchText");
            pageCache.put("org_oldSearchText", searchText);
            if (searchText.equals(oldSearchText)) {
                String searchNodesCache = pageCache.get("org_searchNode");
                if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                    treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
                }
            } else {
                pageCache.remove("org_searchNode");
                treeNodes = this.searchCurTreeNode(searchText, this.getSearchTreeStructFilter());
                if (this.finishSearch(treeNodes, true)) {
                    return;
                }
            }
            if (CollectionUtils.isEmpty((Collection)treeNodes)) {
                this.finishSearch(treeNodes, false);
            } else {
                this.searchFromLazyOrgTree(treeNodes, isFirstSearch);
            }
        }
        this.getView().getPageCache().remove("org_oldSearchText");
        this.getView().getPageCache().remove("org_searchNode");
    }

    private void searchFromLazyOrgTree(List<TreeNode> treeNodes, boolean isFirstSearch) {
        IPageCache pageCache = this.getView().getPageCache();
        TreeNode node = this.searchExistsNodeFromLazyOrgTree(treeNodes, 0);
        if (node == null) {
            this.finishSearch(treeNodes, isFirstSearch);
        } else {
            this.focusNodeAfterSearch(node);
        }
        if (ObjectUtils.isEmpty(treeNodes)) {
            pageCache.put("org_searchNode", null);
            return;
        }
        pageCache.put("org_searchNode", SerializationUtils.toJsonString(treeNodes));
    }

    private void focusNodeAfterSearch(TreeNode node) {
        ((TreeView)this.getView().getControl(KEY_TREEVIEW)).focusNode(node);
        ((TreeView)this.getView().getControl(KEY_TREEVIEW)).expand(node.getId());
        ((TreeView)this.getView().getControl(KEY_TREEVIEW)).treeNodeClick(node.getParentid(), node.getId());
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(List<TreeNode> treeNodes, int recursionCount) {
        if (CollectionUtils.isEmpty(treeNodes) || recursionCount > 20) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        if (node == null) {
            return null;
        }
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)parentId);
        if (OrgTreeUtils.isChildNode((TreeNode)parentNode, (TreeNode)node)) {
            HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
            this.expandParentNode(parentId, loopController, expendIds, 0);
            for (int i = expendIds.size() - 1; i >= 0; --i) {
                ((TreeView)this.getView().getControl(KEY_TREEVIEW)).expand((String)expendIds.get(i));
            }
        } else {
            this.queryTreeNodeWithParent(node);
        }
        node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList removeSubNodes = Lists.newArrayList();
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return this.searchExistsNodeFromLazyOrgTree(treeNodes, recursionCount);
        }
        return node;
    }

    private void queryTreeNodeWithParent(TreeNode node) {
        String notLoadParentLongNumber;
        int layerCount;
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        String currentNodeId = treeView.getTreeState().getFocusNodeId();
        String structLongNumber = node.getLongNumber();
        if (StringUtils.equals((CharSequence)"999999999", (CharSequence)currentNodeId.toString())) {
            String[] splitedStructLongNumber = structLongNumber.split("!");
            layerCount = splitedStructLongNumber.length - 1;
            notLoadParentLongNumber = splitedStructLongNumber[0];
        } else {
            int nextLongNumberLength = this.rootNode.getLongNumber().length() + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
            if (structLongNumber.length() < nextLongNumberLength) {
                return;
            }
            String newParentStructLongNumber = structLongNumber.substring(0, nextLongNumberLength);
            notLoadParentLongNumber = newParentStructLongNumber.substring(newParentStructLongNumber.lastIndexOf(33) + 1);
            layerCount = (structLongNumber.length() - newParentStructLongNumber.length()) / TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        }
        ArrayList<String> structNumbers = new ArrayList<String>();
        structNumbers.add(notLoadParentLongNumber);
        this.getView().getFormShowParameter().setCustomParam("layerCount", (Object)layerCount);
        this.queryTreeNodeChildrenByStructNumbers(structNumbers, node);
    }

    private void queryTreeNodeChildrenByStructNumbers(List<String> structNumbers, TreeNode node) {
        if (structNumbers.isEmpty()) {
            return;
        }
        String selectFields = "adminorg.id, adminorg.boid boid, parentorg.id parentorg, structlongnumber, isleaf";
        if (!this.isAdminStructProjectTree()) {
            this.orgStructNumberProperty = "adminorg.structnumber";
        }
        QFilter numberFilter = new QFilter("adminorg.structnumber", "in", structNumbers);
        DynamicObjectCollection structDynCols = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl(selectFields, new QFilter[]{this.getDataStatusFilter(), numberFilter}, null);
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)structDynCols, (String)"structlongnumber");
        this.setOrgLeaf(structDynCols, PARENT_ORG);
        this.getView().getPageCache().put(SELECT_ALL_TREENODE, "true");
        this.lazyCurTreeNodeChildren(structDynCols, node, "adminorg.id", PARENT_ORG);
    }

    public void lazyCurTreeNodeChildren(DynamicObjectCollection structDynCols, TreeNode node, String nodeIdPropertyName, String parentIdPropertyName) {
        TreeNode parentNode = this.rootNode;
        for (DynamicObject dynamicObject : structDynCols) {
            String orgId = dynamicObject.getString(nodeIdPropertyName);
            parentNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)orgId);
            if (parentNode != null && !ObjectUtils.isEmpty((Object)parentNode.getChildren()) && !node.getParentid().equals(orgId)) continue;
            String parentId = dynamicObject.getString(parentIdPropertyName);
            ((TreeView)this.getView().getControl(KEY_TREEVIEW)).queryTreeNodeChildren(parentId, orgId);
        }
    }

    private void expandParentNode(String nodeId, Set<String> loopController, List<String> expendIds, int recursionCount) {
        if (recursionCount > 20) {
            return;
        }
        if (!StringUtils.isBlank((CharSequence)nodeId) && loopController != null && this.rootNode != null) {
            loopController.add(nodeId);
            TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
            if (treeNode != null && !treeNode.isExpend()) {
                if (expendIds == null) {
                    ((TreeView)this.getView().getControl(KEY_TREEVIEW)).expand(nodeId);
                } else {
                    expendIds.add(nodeId);
                }
                treeNode.setExpend(true);
                this.expandParentNode(treeNode.getParentid(), loopController, expendIds, recursionCount);
            }
        }
    }

    public boolean finishSearch(List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        this.getView().getPageCache().put("org_searchNode", "");
        this.getView().getPageCache().remove("org_oldSearchText");
        if (noResult) {
            this.getView().showTipNotification(BaseMessage.getMessage((String)"M00030"));
        } else {
            this.getView().showSuccessNotification(BaseMessage.getMessage((String)"M00029"));
        }
        return true;
    }

    public List<TreeNode> searchCurTreeNode(String searchText, QFilter structFilter) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter nameFilter = new QFilter("adminorg.name", "like", (Object)("%" + searchText + "%"));
        QFilter[] filters = new QFilter[]{nameFilter, structFilter, this.getOrgTreeFilter()};
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, filters, null);
        if (dynCol == null) {
            return treeNodes;
        }
        this.setOrgLeaf(dynCol, PARENT_ORG);
        Map<Long, DynamicObject> dynBoMap = dynCol.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn));
        QFilter sortCodeAdminOrgFilter = new QFilter("adminorg.id", "in", dynBoMap.keySet());
        DynamicObjectCollection sortCodeCol = HRBaseDaoFactory.getInstance((String)OrgTreeDynEnum.ADMIN_SORT_CODE.getDynEntity()).queryColl("id,adminorg.id orgId, adminorg.number number,sortcode", new QFilter[]{sortCodeAdminOrgFilter, this.getDataStatusFilter()}, null);
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)sortCodeCol, (String)this.subTreeOrderBys);
        ArrayList<DynamicObject> dynColList = new ArrayList<DynamicObject>();
        for (DynamicObject dyn2 : sortCodeCol) {
            long orgId = dyn2.getLong("orgId");
            DynamicObject treeNodeDyn = dynBoMap.get(orgId);
            if (treeNodeDyn == null) continue;
            dynColList.add(treeNodeDyn);
        }
        dynColList.forEach(dynamicObject -> {
            String orgId = dynamicObject.getString("id");
            TreeNode treeNode = new TreeNode(dynamicObject.getString(PARENT_ORG), orgId, dynamicObject.getString("name"));
            treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
            treeNode.setData((Object)dynamicObject.getString("boid"));
            treeNodes.add(treeNode);
        });
        return treeNodes;
    }

    public QFilter getSearchTreeStructFilter() {
        List structLongNumbers = TreeTemplateHelper.getAllPermissionStructLongNumbers((String)this.orgTreeModel.getEntityName(), (QFilter[])new QFilter[]{this.getOrgEnableFilter(), this.getDataStatusFilter()}, null);
        if (null == structLongNumbers || structLongNumbers.size() == 0) {
            return null;
        }
        List allSubStructNumbers = OrgTreeUtils.getAllSubStructNumbers((String)this.rootNode.getLongNumber(), (List)structLongNumbers, (boolean)true);
        return new QFilter("adminorg.structnumber", "in", (Object)allSubStructNumbers);
    }

    public TreeNode initAllOrgTree() {
        TreeNode rootNode;
        this.rootNode = rootNode = this.getRootNode();
        rootNode.setIsOpened(Boolean.TRUE.booleanValue());
        List<TreeNode> childNodes = this.getChildNodesWrap(rootNode);
        if (!childNodes.isEmpty()) {
            rootNode.addChildren(childNodes);
        }
        return rootNode;
    }

    private List<TreeNode> getChildNodesWrap(TreeNode treeNode) {
        if (HRStringUtils.isEmpty((String)treeNode.getId())) {
            return Lists.newArrayListWithExpectedSize((int)16);
        }
        List<Map<String, String>> treeView = this.getTreeViewByParentId(treeNode);
        return this.buildTreeChildNodes(treeView);
    }

    private List<TreeNode> buildTreeChildNodes(List<Map<String, String>> treeView) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(16);
        if (treeView != null && treeView.size() > 0) {
            for (Map<String, String> map : treeView) {
                nodes.add(this.genTreeNodeWrap(map));
            }
        }
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        if (nodes.size() < 1) {
            return list;
        }
        HashMap<String, TreeNode> dctItems = new HashMap<String, TreeNode>(nodes.size());
        for (TreeNode node : nodes) {
            dctItems.put(node.getId(), node);
        }
        for (TreeNode node : nodes) {
            TreeNode parentNode = (TreeNode)dctItems.get(node.getParentid());
            if (parentNode != null) {
                if (parentNode.getChildren() == null) {
                    parentNode.addChildren(new ArrayList());
                }
                parentNode.getChildren().add(node);
            } else {
                list.add(node);
            }
            this.setLazyNodeLeafChildren(node);
        }
        return list;
    }

    private TreeNode genTreeNodeWrap(Map<String, String> map) {
        TreeNode node = new TreeNode();
        node.setParentid(map.get("parent"));
        String nodeId = map.get("id");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return node;
        }
        node.setId(nodeId);
        node.setText(map.get("name"));
        this.resetOrgNameByEnableInfo(node, map);
        node.setLongNumber(map.get("longnumber"));
        boolean isLeaf = "1".equals(map.get("isleaf"));
        node.setLeaf(isLeaf);
        node.setData((Object)map.get("boid"));
        this.setLabelPara(node, map.get("enable"), map.get("tobedisableflag"));
        return node;
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, Map<String, String> nodeMap) {
        String companyName;
        TreeNodeLabel treeNodeLabel;
        if (node == null || nodeMap == null) {
            return;
        }
        String enable = nodeMap.get("enable");
        node.getLabelPara().clear();
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
        String tobedisableflag = nodeMap.get("tobedisableflag");
        if ("0".equals(enable)) {
            treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AdminOrgTreeListTemplate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
        } else if ("1".equals(tobedisableflag) || "true".equals(tobedisableflag)) {
            treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5f85\u505c\u7528", (String)"AdminOrgTreeListTemplate_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#FF991C");
            labelParaList.add(treeNodeLabel);
        }
        String isVirtualOrg = nodeMap.getOrDefault("isvirtualorg", Boolean.FALSE.toString());
        if (HRStringUtils.equals((String)isVirtualOrg, (String)Boolean.TRUE.toString())) {
            TreeNodeLabel treeNodeLabel2 = new TreeNodeLabel(ResManager.loadKDString((String)"\u865a\u62df\u7ec4\u7ec7", (String)"AdminOrgTreeListTemplate_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#55A0F5");
            labelParaList.add(treeNodeLabel2);
        }
        if (!CollectionUtils.isEmpty(labelParaList)) {
            node.setLabelPara(labelParaList);
        }
        if (!this.isAdminStructProjectTree() && HRStringUtils.isNotEmpty((String)(companyName = this.treeNodeNameSetter.createCompanySuffix(nodeMap)))) {
            node.setText(String.format("%s\uff08%s\uff09", node.getText(), companyName));
        }
    }

    private void setLabelPara(TreeNode node, String enable, String tobedisableflag) {
        node.getLabelPara().clear();
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
        if ("0".equals(enable)) {
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AbstractReportPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
        } else if (HRStringUtils.equals((String)"true", (String)tobedisableflag)) {
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5f85\u505c\u7528", (String)"AbstractReportPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), "#FF991C");
            labelParaList.add(treeNodeLabel);
        }
        if (!CollectionUtils.isEmpty(labelParaList)) {
            node.setLabelPara(labelParaList);
        }
    }

    private void setLazyNodeLeafChildren(TreeNode node) {
        if (node == null) {
            return;
        }
        if (!node.isLeaf() && node.getChildren() == null) {
            node.addChildren(new ArrayList(0));
        }
    }

    public List<Map<String, String>> getTreeViewByParentId(TreeNode treeNode) {
        DynamicObjectCollection dyColl = this.getTreeViewCollection(treeNode);
        return this.encapsulationTreeMap(dyColl);
    }

    public List<Map<String, String>> encapsulationTreeMap(DynamicObjectCollection dyColl) {
        if (!this.isAdminStructProjectTree()) {
            this.treeNodeNameSetter.beforeEncapsulationTreeMap(dyColl, this.getDateParam());
        }
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)dyColl)) {
            return list;
        }
        for (DynamicObject dyn : dyColl) {
            HashMap map = Maps.newHashMap();
            map.put("id", dyn.getString("id"));
            map.put("boid", dyn.getString("boid"));
            map.put("name", dyn.getString("name"));
            map.put("enable", dyn.getString("enable"));
            map.put("parent", dyn.getString(PARENT_ORG));
            map.put("isleaf", dyn.getBoolean("isleaf") ? "1" : "0");
            map.put("longnumber", dyn.getString("structlongnumber"));
            map.put("tobedisableflag", dyn.containsProperty("tobedisableflag") ? dyn.getString("tobedisableflag") : "");
            list.add(map);
        }
        return list;
    }

    private DynamicObjectCollection getTreeViewCollection(TreeNode currentNode) {
        if (currentNode == null) {
            return null;
        }
        String currentStructLongNumber = currentNode.getLongNumber();
        QFilter treeViewStructNumberFilter = this.getCurrentChildFilter(currentStructLongNumber, Long.valueOf(currentNode.getId()));
        DynamicObjectCollection treeViewDynObjColl = this.queryCurTreeViewDynamicCollection(new QFilter[]{this.getCurTreeBizCommonQFilter(), treeViewStructNumberFilter});
        this.setOrgLeaf(treeViewDynObjColl, PARENT_ORG);
        return treeViewDynObjColl;
    }

    public QFilter getCurrentChildFilter(String currentStructLongNumber, Long currentOrgId) {
        QFilter qFilter;
        String selectAll = this.getView().getPageCache().get(SELECT_ALL_TREENODE);
        this.getView().getPageCache().remove(SELECT_ALL_TREENODE);
        if (!this.isAdminStructProjectTree()) {
            this.orgStructNumberProperty = "adminorg.structnumber";
        }
        if (HRStringUtils.equals((String)selectAll, (String)"true")) {
            return this.getTreeViewStructNumberFilter(currentStructLongNumber);
        }
        if (!this.isAdminStructProjectTree()) {
            this.orgStructNumberProperty = "adminorg.structnumber";
        }
        if (!this.orgTreeModel.isFilterTreePerm() || this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            return new QFilter(PARENT_ORG, "=", (Object)currentOrgId);
        }
        List hasPermOrgsWithSub = this.getPermOrgResultWithSub().getHasPermOrgsWithSub();
        HashSet parentOrgSet = Sets.newHashSet();
        parentOrgSet.add(currentOrgId);
        this.getParentTreeNodeIdSet(currentOrgId, parentOrgSet);
        for (OrgSubInfo orgSubInfo : hasPermOrgsWithSub) {
            if (!parentOrgSet.contains(orgSubInfo.getOrgId()) || !orgSubInfo.isContainsSub()) continue;
            return new QFilter(PARENT_ORG, "=", (Object)currentOrgId);
        }
        ArrayList childStructNumbers = Lists.newArrayList();
        ArrayList currentChildIds = Lists.newArrayList();
        for (OrgSubInfo orgSubInfo : hasPermOrgsWithSub) {
            String structNumber = orgSubInfo.getStructNumber();
            String longStructNumber = orgSubInfo.getLongStructNumber();
            if (HRStringUtils.isEmpty((String)structNumber) || HRStringUtils.isEmpty((String)longStructNumber)) {
                currentChildIds.add(orgSubInfo.getOrgId());
                continue;
            }
            if (!longStructNumber.startsWith(currentStructLongNumber)) continue;
            if (longStructNumber.length() - currentStructLongNumber.length() == 13) {
                childStructNumbers.add(structNumber);
                continue;
            }
            if (longStructNumber.length() - currentStructLongNumber.length() > 13) {
                structNumber = longStructNumber.substring(currentStructLongNumber.length() + 1, currentStructLongNumber.length() + 13);
                childStructNumbers.add(structNumber);
                continue;
            }
            childStructNumbers.add(structNumber);
        }
        if (!CollectionUtils.isEmpty((Collection)childStructNumbers)) {
            qFilter = this.isAdminStructProjectTree() ? new QFilter("structnumber", "in", (Object)childStructNumbers) : new QFilter("adminorg.structnumber", "in", (Object)childStructNumbers);
            return qFilter.and(new QFilter(PARENT_ORG, "=", (Object)currentOrgId));
        }
        if (!CollectionUtils.isEmpty((Collection)currentChildIds)) {
            qFilter = new QFilter("boid", "in", (Object)currentChildIds);
            return qFilter.and(new QFilter(PARENT_ORG, "=", (Object)currentOrgId));
        }
        return new QFilter("1", "!=", (Object)1);
    }

    private void getParentTreeNodeIdSet(Long treeParentId, Set<Long> parentTreeNodeIdSet) {
        TreeNode treeNode;
        if (this.rootNode == null) {
            this.rootNode = this.init();
        }
        if (Objects.nonNull(treeNode = this.rootNode.getTreeNode(String.valueOf(treeParentId), 20)) && HRStringUtils.isNotEmpty((String)treeNode.getParentid())) {
            parentTreeNodeIdSet.add(Long.valueOf(treeNode.getParentid()));
            this.getParentTreeNodeIdSet(Long.valueOf(treeNode.getParentid()), parentTreeNodeIdSet);
        }
    }

    public void setOrgLeaf(DynamicObjectCollection dynObjCol, String dynParentProperty) {
        if (dynObjCol == null) {
            return;
        }
        HashMap<Long, DynamicObject> notLeafDynMap = new HashMap<Long, DynamicObject>(dynObjCol.size());
        for (DynamicObject dyn2 : dynObjCol) {
            notLeafDynMap.put(dyn2.getLong("boid"), dyn2);
        }
        Map<Long, DynamicObject> queryChildDynMap = this.getNeedQueryToSetLeafDynMap(notLeafDynMap);
        String doNotHaveParentCache = this.getView().getPageCache().get("do_not_have_parent_org_structlongnumber");
        DynamicObjectCollection childDynCol = doNotHaveParentCache != null ? this.getHisChildDynColl(queryChildDynMap.keySet()) : this.getCurChildDynCol(queryChildDynMap.keySet());
        if (childDynCol == null) {
            for (DynamicObject dyn3 : notLeafDynMap.values()) {
                dyn3.set("isleaf", (Object)Boolean.TRUE);
            }
        } else {
            Map<Long, List<DynamicObject>> curOrgGroupParentCol = childDynCol.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong(dynParentProperty)));
            Set<Map.Entry<Long, DynamicObject>> curOrgColEntry = queryChildDynMap.entrySet();
            for (Map.Entry<Long, DynamicObject> curOrgMap : curOrgColEntry) {
                Long curOrgId = curOrgMap.getKey();
                DynamicObject curOrgDyn = curOrgMap.getValue();
                List<DynamicObject> childDynList = curOrgGroupParentCol.get(curOrgId);
                if (ObjectUtils.isEmpty(childDynList)) {
                    curOrgDyn.set("isleaf", (Object)Boolean.TRUE);
                    continue;
                }
                curOrgDyn.set("isleaf", (Object)Boolean.FALSE);
            }
        }
    }

    public DynamicObjectCollection getCurChildDynCol(Set<Long> orgBoIdSet) {
        if (ObjectUtils.isEmpty(orgBoIdSet)) {
            return null;
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        QFilter structLongNumberAndSubFilter = null;
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm()) {
            structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
        }
        QFilter parentBoIdFilter = new QFilter(PARENT_ORG, "in", orgBoIdSet);
        QFilter[] qFilters = new QFilter[]{this.getOrgTreeFilter(), parentBoIdFilter, structLongNumberAndSubFilter};
        return HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl("structlongnumber, isleaf,adminorg.boid boid, parentorg.boid parentorg", qFilters, null);
    }

    private DynamicObjectCollection getHisChildDynColl(Set<Long> orgBoIdSet) {
        if (ObjectUtils.isEmpty(orgBoIdSet)) {
            return null;
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        QFilter adminOrgBoIdFilter = null;
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm() && kd.bos.util.CollectionUtils.isNotEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
            QFilter structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.orgTreeModel.getEntityName());
            DynamicObjectCollection originalDynColl = serviceHelper.queryOriginalCollection("adminorg.boid", structLongNumberAndSubFilter.toArray());
            Set adminOrgBoIdSet = originalDynColl.stream().map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toSet());
            adminOrgBoIdFilter = new QFilter("adminorg.boid", "in", adminOrgBoIdSet);
        }
        QFilter parentBoIdFilter = new QFilter(PARENT_ORG, "in", orgBoIdSet);
        QFilter[] qFilters = new QFilter[]{this.getOrgTreeFilter(), parentBoIdFilter, adminOrgBoIdFilter};
        return HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl("structlongnumber, isleaf,adminorg.boid boid, parentorg.boid parentorg", qFilters, null);
    }

    public Map<Long, DynamicObject> getNeedQueryToSetLeafDynMap(Map<Long, DynamicObject> notLeafDynMap) {
        HashMap<Long, DynamicObject> queryChildDynMap = new HashMap<Long, DynamicObject>();
        if (ObjectUtils.isEmpty(notLeafDynMap)) {
            return queryChildDynMap;
        }
        ArrayList<DynamicObject> notIsLeafDynList = new ArrayList<DynamicObject>(notLeafDynMap.values());
        if (this.orgTreeModel.isFilterTreePerm() && !this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            if ("orgTeam".equals(this.orgTreeModel.getOrgType())) {
                queryChildDynMap.putAll(notLeafDynMap);
            } else {
                for (DynamicObject dyn : notIsLeafDynList) {
                    queryChildDynMap.put(dyn.getLong("boid"), dyn);
                }
            }
        } else {
            queryChildDynMap.putAll(notLeafDynMap);
        }
        return queryChildDynMap;
    }

    public DynamicObjectCollection queryCurTreeViewDynamicCollection(QFilter[] qFilters) {
        if (this.orgTreeModel.isHisTree() || !this.isAdminStructProjectTree()) {
            DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, qFilters, null);
            if (dynCol == null) {
                return null;
            }
            Map<Long, DynamicObject> dynBoMap = dynCol.stream().collect(Collectors.toMap(dyn -> dyn.getLong("boid"), dyn -> dyn));
            QFilter sortCodeAdminOrgFilter = new QFilter("adminorg.id", "in", dynBoMap.keySet());
            DynamicObjectCollection sortCodeCol = HRBaseDaoFactory.getInstance((String)OrgTreeDynEnum.ADMIN_SORT_CODE.getDynEntity()).queryColl("id,adminorg.id orgId, adminorg.number number, sortcode", new QFilter[]{sortCodeAdminOrgFilter, this.getDataStatusFilter()}, null);
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)sortCodeCol, (String)this.subTreeOrderBys);
            DynamicObjectCollection retDynCol = new DynamicObjectCollection();
            for (DynamicObject dyn2 : sortCodeCol) {
                long orgId = dyn2.getLong("orgId");
                DynamicObject treeNodeDyn = dynBoMap.get(orgId);
                if (treeNodeDyn == null) continue;
                retDynCol.add((Object)treeNodeDyn);
            }
            return retDynCol;
        }
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)(this.orgTreeModel.isHisTree() || !this.isAdminStructProjectTree() ? this.orgTreeModel.getEntityName() : this.orgTreeModel.getMainEntityName())).queryColl(this.orgTreeModel.isHisTree() || !this.isAdminStructProjectTree() ? CUR_SUB_TREE_STRUCT_FIELDS : CUR_SUB_TREE_FIELDS, qFilters, this.subTreeOrderBys);
        return dynCol;
    }

    public final boolean isAdminStructProjectTree() {
        return this.structProjectCapable.getStructProject().getLong("id") == 1010L;
    }

    private QFilter getTreeViewStructNumberFilter(String currentStructLongNumber) {
        QFilter structNumberFilter = null;
        structNumberFilter = this.getPermOrgResultWithSub().isHasAllOrgPerm() ? new QFilter(this.orgStructNumberProperty, "in", this.getAllPermissionStructNumbers(currentStructLongNumber)) : this.getPermissionTreeViewStructNumbers(this.getPermOrgResultWithSub(), currentStructLongNumber);
        return structNumberFilter;
    }

    private QFilter getPermissionTreeViewStructNumbers(AuthorizedOrgResultWithSub permissionModel, String currentStructLongNumber) {
        List<String> structLongNumbers = this.getStructLongNumberInPermCache(permissionModel);
        List subStructNumbers = OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, structLongNumbers, (boolean)false, (Integer)20);
        return new QFilter("adminorg.structnumber", "in", (Object)subStructNumbers);
    }

    private List<String> getStructLongNumberInPermCache(AuthorizedOrgResultWithSub permissionModel) {
        List structLongNumbers;
        IPageCache pageCache = this.getView().getPageCache();
        String structLongNumberInPermStr = pageCache.get("all_struct_long_number_in_perm");
        if (!StringUtils.isEmpty((CharSequence)structLongNumberInPermStr)) {
            structLongNumbers = SerializationUtils.fromJsonStringToList((String)structLongNumberInPermStr, String.class);
        } else {
            structLongNumbers = TreeTemplateHelper.getPermissionStructLongNumbersWithSub((AuthorizedOrgResultWithSub)permissionModel, (String)this.orgTreeModel.getEntityName(), (QFilter)this.getOrgTreeFilter(), (String)"adminorg.id", null);
            pageCache.put("all_struct_long_number_in_perm", SerializationUtils.toJsonString((Object)structLongNumbers));
        }
        return structLongNumbers;
    }

    private List<String> getAllPermissionStructNumbers(String currentStructLongNumber) {
        IPageCache pageCache = this.getView().getPageCache();
        if (ObjectUtils.isEmpty(this.allPermLongNumberList)) {
            this.allPermLongNumberList = this.getAllPermissionStructLongNumbers();
            pageCache.put("all_struct_long_number", SerializationUtils.toJsonString(this.allPermLongNumberList));
        }
        List subStructNumbers = OrgTreeUtils.getMultiLayerSubStructNumber((String)currentStructLongNumber, this.allPermLongNumberList, (boolean)false, (Integer)20);
        return subStructNumbers;
    }

    public List<String> getAllPermissionStructLongNumbers() {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl("structlongnumber", new QFilter[]{this.getOrgTreeFilter()}, null);
        return collection.stream().map(dynamicObject -> dynamicObject.getString("structlongnumber")).collect(Collectors.toList());
    }

    private TreeNode getRootNode() {
        IPageCache pageCache = this.getView().getPageCache();
        this.structProjectCapable.getStructProject();
        String rootNodeStr = pageCache.get("org_root_node");
        if (!StringUtils.isEmpty((CharSequence)rootNodeStr)) {
            TreeNode rootTreeNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeStr, TreeNode.class);
            return rootTreeNode;
        }
        TreeNode rootNode = new TreeNode("", null, ResManager.loadKDString((String)"\u672a\u521d\u59cb\u5316\u6839\u7ec4\u7ec7\u3002", (String)"AbstractReportPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        DynamicObject rootNodeDynamicObj = this.getRootDynamicObject();
        if (rootNodeDynamicObj == null) {
            return rootNode;
        }
        if (this.getDefinedDyVsCustomNode().containsKey(rootNodeDynamicObj.getLong("id"))) {
            return this.getDefinedDyVsCustomNode().get(rootNodeDynamicObj.getLong("id")).get();
        }
        this.encapsulateRootNode(rootNode, rootNodeDynamicObj);
        this.setLabelPara(rootNode, rootNodeDynamicObj.getString("enable"), rootNodeDynamicObj.getString("tobedisableflag"));
        pageCache.put("org_root_node", SerializationUtils.toJsonString((Object)rootNode));
        return rootNode;
    }

    private void encapsulateRootNode(TreeNode rootNode, DynamicObject dynamicObject) {
        if (dynamicObject == null) {
            return;
        }
        if (!this.isAdminStructProjectTree()) {
            this.treeNodeNameSetter.beforeEncapsulationNode(dynamicObject, this.getDateParam());
        }
        TreeTemplateHelper.encapsulateRootOrgTeamNode((TreeNode)rootNode, (DynamicObject)dynamicObject, (OrgTreeModel)this.orgTreeModel);
        this.resetOrgNameByEnableInfo(rootNode, dynamicObject);
    }

    protected void resetOrgNameByEnableInfo(TreeNode node, DynamicObject dyn) {
        String companyName;
        LocalDate today;
        String cachedSearchDateStr;
        LocalDate cachedSearchDate;
        String isVirtualOrg;
        TreeNodeLabel treeNodeLabel;
        if (node == null || dyn == null) {
            return;
        }
        String enable = dyn.containsProperty("enable") ? dyn.getString("enable") : "1";
        String tobedisableflag = dyn.containsProperty("tobedisableflag") ? dyn.getString("tobedisableflag") : "false";
        node.getLabelPara().clear();
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
        if ("0".equals(enable)) {
            treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AdminOrgTreeListTemplate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
        } else if (HRStringUtils.equals((String)"true", (String)tobedisableflag)) {
            treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5f85\u505c\u7528", (String)"AdminOrgTreeListTemplate_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#FF991C");
            labelParaList.add(treeNodeLabel);
        }
        String string = isVirtualOrg = dyn.containsProperty("isvirtualorg") ? dyn.getString("isvirtualorg") : Boolean.FALSE.toString();
        if (HRStringUtils.equals((String)isVirtualOrg, (String)Boolean.TRUE.toString())) {
            TreeNodeLabel treeNodeLabel2 = new TreeNodeLabel(ResManager.loadKDString((String)"\u865a\u62df\u7ec4\u7ec7", (String)"AdminOrgTreeListTemplate_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#55A0F5");
            labelParaList.add(treeNodeLabel2);
        }
        if (!(cachedSearchDate = (cachedSearchDateStr = this.getView().getPageCache().get("searchdate")) == null ? TreeTemplateHelper.date2LocalDate((Date)new Date()) : (LocalDate)JSON.parseObject((String)cachedSearchDateStr, LocalDate.class)).isEqual(today = TreeTemplateHelper.date2LocalDate((Date)new Date()))) {
            TreeNodeLabel searchDate = new TreeNodeLabel(cachedSearchDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), "#666666");
            labelParaList.add(searchDate);
        }
        if (!CollectionUtils.isEmpty(labelParaList)) {
            node.setLabelPara(labelParaList);
        }
        if (!this.isAdminStructProjectTree() && HRStringUtils.isNotEmpty((String)(companyName = this.treeNodeNameSetter.createCompanySuffix(dyn)))) {
            node.setText(String.format("%s\uff08%s\uff09", node.getText(), companyName));
        }
    }

    private DynamicObject getRootDynamicObject() {
        if (this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            return this.getRootNodeDyn();
        }
        QFilter permFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
        QFilter orgTreeFilter = this.getOrgTreeFilter();
        DynamicObject rootNodeDynamicObj = TreeTemplateHelper.getCurTreeRootNodeDynamicObj((String)this.orgTreeModel.getEntityName(), (String)CUR_TREE_ROOT_STRUCT_FIELDS, (QFilter)permFilter, (QFilter)orgTreeFilter, (QFilter)this.getCurTreeBizCommonQFilter());
        if (null == rootNodeDynamicObj) {
            return this.getRootDynByRootId();
        }
        return rootNodeDynamicObj;
    }

    QFilter getCurTreeBizCommonQFilter() {
        if (this.isAdminStructProjectTree()) {
            return this.getDataStatusAndBSedFilter().and(this.getOrgEnableFilter());
        }
        QFilter curTreeBizCommonQFilter = this.getDataStatusAndBSedFilter().and(this.getOrgTreeEnableFilter());
        if (this.structProjectCapable.enableStructProjectCode()) {
            curTreeBizCommonQFilter.and(this.getTreeStructProjectFilter());
        }
        return curTreeBizCommonQFilter;
    }

    protected QFilter getOrgTreeEnableFilter() {
        if (this.isShowDisable()) {
            return QFilterHelper.create1Equals1Filter();
        }
        return new QFilter("adminorg.enable", "in", (Object)new String[]{"1", "10"});
    }

    protected QFilter getOrgEnableFilter() {
        this.orgEnableFilter = new QFilter("enable", "=", (Object)"1");
        if (this.isShowDisable()) {
            QFilter disableFilter = new QFilter("enable", "=", (Object)"0");
            this.orgEnableFilter.or(disableFilter);
        }
        return this.orgEnableFilter;
    }

    protected QFilter getDataStatusAndBSedFilter() {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)this.orgTreeModel.getDataStatusList());
        if (StringUtils.isNotBlank((CharSequence)this.orgTreeModel.getInitStatus())) {
            dataStatusFilter.and(new QFilter("initstatus", "=", (Object)this.orgTreeModel.getInitStatus()));
        }
        this.dataStatusAndBSedFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        this.dataStatusAndBSedFilter.and(dataStatusFilter);
        return this.dataStatusAndBSedFilter;
    }

    private DynamicObject getRootDynByRootId() {
        return HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryOriginalOne(CUR_TREE_ROOT_STRUCT_FIELDS, new QFilter("adminorg.id", "=", (Object)100000L).toArray());
    }

    protected QFilter getTreeStructProjectFilter() {
        QFilter result = new QFilter("structproject", "in", (Object)this.structProjectCapable.getStructProjectIdSet());
        if (!TreeTemplateConstants.SYSTEM_STRUCT_PROJECT.contains(this.structProjectCapable.getStructProject().getLong("id"))) {
            result.and(new QFilter("enable", "=", (Object)"1"));
        } else {
            result.and(new QFilter("enable", "in", (Object)new String[]{"1", "0"}));
        }
        return result;
    }

    private QFilter getOrgTreeFilter() {
        QFilter orgTreeFilter = this.getOrgCommonFilter();
        if (this.structProjectCapable.enableStructProjectCode()) {
            orgTreeFilter.and(this.getTreeStructProjectFilter());
        }
        return orgTreeFilter;
    }

    private boolean isShowDisable() {
        if (this.isShowDisable != null) {
            return this.isShowDisable;
        }
        String cacheStrShowDisable = this.getView().getPageCache().get("chkshowdisableorg_tree_filter");
        this.isShowDisable = cacheStrShowDisable == null ? Boolean.FALSE : Boolean.parseBoolean(cacheStrShowDisable);
        return this.isShowDisable;
    }

    private DynamicObject getRootNodeDyn() {
        QFilter orgTreeFilter = this.getOrgRootTreeFilter();
        if (orgTreeFilter == null) {
            return this.getRootDynByRootId();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.orgTreeModel.getEntityName());
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray("structlongnumber", new QFilter[]{orgTreeFilter});
        if (null == dynamicObjects || 1 > dynamicObjects.length) {
            return this.getRootDynByRootId();
        }
        String commonParentStructLongNumber = TreeTemplateHelper.getParentOrgStructLongNumberByOrgArray((DynamicObject[])dynamicObjects);
        QFilter[] filters = new QFilter[]{new QFilter("structlongnumber", "=", (Object)commonParentStructLongNumber), this.getDataStatusAndBSedFilter()};
        return serviceHelper.queryOriginalOne(CUR_TREE_ROOT_STRUCT_FIELDS, filters);
    }

    public QFilter getOrgRootTreeFilter() {
        QFilter treeFilter = this.getOrgCommonFilter();
        if (this.structProjectCapable.enableStructProjectCode()) {
            treeFilter.and(this.getTreeStructProjectFilter());
        }
        return treeFilter;
    }

    private QFilter getOrgCommonFilter() {
        QFilter dataStatusAndBSedFilter = this.getDataStatusAndBSedFilter();
        dataStatusAndBSedFilter.and(this.getOrgEnableFilter());
        return dataStatusAndBSedFilter;
    }

    private QFilter getDataStatusFilter() {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)this.orgTreeModel.getDataStatusList());
        if (StringUtils.isNotBlank((CharSequence)this.orgTreeModel.getInitStatus())) {
            dataStatusFilter.and(new QFilter("initstatus", "=", (Object)this.orgTreeModel.getInitStatus()));
        }
        dataStatusFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        return dataStatusFilter;
    }

    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        Long userId = RequestContext.get().getCurrUserId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map permParams = (Map)formShowParameter.getCustomParam("permParams");
        String permEntityId = "haos_adminorgdetail";
        String permItemId = "47150e89000000ac";
        permEntityId = QueryEntityServiceHelper.getDataEntityNumber((String)permEntityId);
        String appId = AbstractReportPlugin.getAppIdFromShowParam(this.getView().getFormShowParameter());
        String propKey = "boid";
        if (permParams != null) {
            permEntityId = (String)permParams.get("permEntityId");
            permItemId = (String)permParams.get("permItemId");
            appId = (String)permParams.get("appId");
            propKey = (String)permParams.get("propKey");
        }
        AuthorizedOrgResultWithSub permResult = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{userId, appId, permEntityId, permItemId, propKey, this.getStructProjectCustomInParamWithDate(propKey)});
        this.resetPermOrgResultWitchSub(permResult);
        permResult = this.orgAuthToOrgAuthSub(permResult);
        return permResult;
    }

    private AuthorizedOrgResultWithSub orgAuthToOrgAuthSub(AuthorizedOrgResultWithSub authorizedOrgResult) {
        AuthorizedOrgResultWithSub orgResultWithSub = new AuthorizedOrgResultWithSub(authorizedOrgResult.isHasAllOrgPerm());
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            ArrayList<OrgSubInfo> hasPermOrgsWithSub = new ArrayList<OrgSubInfo>(authorizedOrgResult.getHasPermOrgsWithSub().size());
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("haos_adminorgstruct");
            QFilter structProjectFilter = new QFilter("structproject", "=", (Object)this.structProjectCapable.getStructProject().getLong("id"));
            QFilter adminOrgFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)authorizedOrgResult, (String)"adminorg.boid");
            DynamicObject[] orgDyArr = hrBaseServiceHelper.query("adminorg.boid,isleaf,structlongnumber", new QFilter[]{adminOrgFilter, structProjectFilter, this.getDataStatusAndBSedFilter()});
            for (int i = 0; i < orgDyArr.length; ++i) {
                OrgSubInfo orgSubInfo = new OrgSubInfo();
                DynamicObject orgDy = orgDyArr[i];
                orgSubInfo.setOrgId(Long.valueOf(orgDy.getLong("adminorg.boid")));
                String structlongnumber = orgDy.getString("structlongnumber");
                orgSubInfo.setContainsSub(Boolean.FALSE.booleanValue());
                orgSubInfo.setLongStructNumber(structlongnumber);
                if (structlongnumber.indexOf("!") == -1) {
                    orgSubInfo.setStructNumber(structlongnumber);
                } else {
                    orgSubInfo.setStructNumber(structlongnumber.substring(structlongnumber.lastIndexOf("!") + 1));
                }
                hasPermOrgsWithSub.add(orgSubInfo);
            }
            orgResultWithSub.setHasPermOrgsWithSub(hasPermOrgsWithSub);
        }
        return orgResultWithSub;
    }

    protected void resetPermOrgResultWitchSub(AuthorizedOrgResultWithSub permOrgResultWithSub) {
        if (permOrgResultWithSub.isHasAllOrgPerm()) {
            return;
        }
        for (OrgSubInfo orgSubInfo : permOrgResultWithSub.getHasPermOrgsWithSub()) {
            if (OrgServiceUtil.getAdminRootOrgId() != orgSubInfo.getOrgId() || !orgSubInfo.isContainsSub()) continue;
            permOrgResultWithSub.setHasAllOrgPerm(true);
            break;
        }
    }

    public Date getDateParam() {
        String searchDateStr = this.getPageCache().get("searchdate");
        if (searchDateStr == null) {
            return new Date();
        }
        LocalDate searchDate = (LocalDate)JSON.parseObject((String)searchDateStr, LocalDate.class);
        return HRDateTimeUtils.localDate2Date((LocalDate)searchDate);
    }

    public static String getAppIdFromShowParam(FormShowParameter showParameter) {
        String appNumber = showParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        return appInfo != null ? appInfo.getId() : null;
    }

    private Map<Long, Supplier<TreeNode>> getDefinedDyVsCustomNode() {
        HashMap<Long, Supplier<TreeNode>> map = new HashMap<Long, Supplier<TreeNode>>();
        map.put(-1L, this::noDataVirtualNode);
        map.put(-2L, () -> {
            TreeNode treeNode = this.parentVirtualNode("");
            treeNode.setIsOpened(true);
            return treeNode;
        });
        return map;
    }

    private TreeNode noDataVirtualNode() {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("-1");
        treeNode.setText(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u65e0\u6570\u636e", (String)"TreeListTemplateBase_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        treeNode.setParentid("");
        treeNode.setLeaf(Boolean.TRUE.booleanValue());
        return treeNode;
    }

    private TreeNode parentVirtualNode(String parentNodeId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId("999999999");
        treeNode.setText(ResManager.loadKDString((String)"\u5f53\u524d\u65e5\u671f\u65e0\u7236\u8282\u70b9", (String)"TreeListTemplateBase_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        treeNode.setParentid(parentNodeId);
        treeNode.setLeaf(Boolean.FALSE.booleanValue());
        treeNode.setChildren(new ArrayList());
        return treeNode;
    }

    public void queryTreeNodeChildren(TreeNodeEvent event) {
        if (event.getNodeId() == null) {
            return;
        }
        String nodeId = event.getNodeId().toString();
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        QFilter qFilter = new QFilter("adminorg", "=", (Object)Long.valueOf(nodeId));
        DynamicObject dynamicObject = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryOne("structlongnumber", new QFilter[]{this.getOrgTreeFilter(), qFilter});
        if (dynamicObject != null) {
            TreeNode treeNode = new TreeNode();
            treeNode.setId(nodeId);
            treeNode.setLongNumber(dynamicObject.getString("structlongnumber"));
            List<TreeNode> childNodesWrap = this.getChildNodesWrap(treeNode);
            if (!CollectionUtils.isEmpty(childNodesWrap)) {
                TreeView allOrgTreeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
                childNodesWrap.stream().forEach(nod -> nod.setParentid(nodeId));
                allOrgTreeView.addNodes(childNodesWrap);
                TreeNode node = OrgTreeUtils.getNode((TreeNode)this.rootNode, (Object)nodeId);
                if (node != null) {
                    node.addChildren(childNodesWrap);
                }
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        HashMap<String, List<Object>> param = new HashMap<String, List<Object>>();
        String includeChild = this.getView().getPageCache().get(CHK_INCLUDE_CHILD);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        if (includeChild != null && Boolean.TRUE.toString().equals(includeChild)) {
            QFilter qFilter = new QFilter("adminorg", "=", (Object)Long.valueOf((String)evt.getNodeId()));
            DynamicObject dynamicObject = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryOne("structlongnumber", new QFilter[]{this.getOrgTreeFilter(), qFilter});
            String longNumber = dynamicObject.getString("structlongnumber");
            QFilter longNumberLike = new QFilter("structlongnumber", "like", (Object)(longNumber + "%"));
            QFilter enabledFilter = new QFilter("enable", "=", (Object)"1");
            if (this.isShowDisable()) {
                enabledFilter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
            }
            List permOrgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(per -> per.getOrgId()).collect(Collectors.toList());
            QFilter permQFilter = permOrgResultWithSub.isHasAllOrgPerm() ? new QFilter("1", "=", (Object)1) : new QFilter("adminorg.id", "in", permOrgIds);
            DynamicObjectCollection dynamicObjectCollection = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl("adminorg.id", new QFilter[]{this.getOrgTreeFilter(), longNumberLike, permQFilter, enabledFilter}, null);
            List ids = dynamicObjectCollection.stream().map(dyn -> dyn.getLong("adminorg.id")).collect(Collectors.toList());
            if (permOrgResultWithSub.isHasAllOrgPerm()) {
                ids.add(Long.valueOf((String)evt.getNodeId()));
            } else {
                List permIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(OrgSubInfo::getOrgId).collect(Collectors.toList());
                if (permIds.contains(Long.valueOf((String)evt.getNodeId()))) {
                    ids.add(Long.valueOf((String)evt.getNodeId()));
                }
            }
            param.put("orgIds", ids);
        } else if (permOrgResultWithSub.isHasAllOrgPerm()) {
            param.put("orgIds", Collections.singletonList(Long.valueOf((String)evt.getNodeId())));
        } else {
            List orgIds = permOrgResultWithSub.getHasPermOrgsWithSub().stream().map(OrgSubInfo::getOrgId).collect(Collectors.toList());
            if (orgIds.contains(Long.valueOf((String)evt.getNodeId()))) {
                param.put("orgIds", Collections.singletonList(Long.valueOf((String)evt.getNodeId())));
            } else {
                param.put("orgIds", Collections.singletonList(-1L));
            }
        }
        this.getQueryParam().setCustomParam(param);
        this.getView().refresh();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String properName = beforeF7SelectEvent.getProperty().getName();
        if ("structproject".equals(properName)) {
            List<QFilter> structProjectControlFilterList = this.getStructProjectAllFilter();
            structProjectControlFilterList.forEach(arg_0 -> ((BeforeF7SelectEvent)beforeF7SelectEvent).addCustomQFilter(arg_0));
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setOrderBy("issyspreset desc, number asc");
        }
    }

    public List<QFilter> getStructProjectAllFilter() {
        if (!this.structProjectCapable.enableStructProjectCode()) {
            return Collections.emptyList();
        }
        QFilter structProjectIdFilter = this.structProjectCapable.getStructProjectIdFilter();
        if (structProjectIdFilter != null) {
            return Stream.of(structProjectIdFilter, this.structProjectCapable.getStructProjectFilterFromConfigFilter()).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Stream.of(this.structProjectCapable.getEnableStructProjectControlFilter(), this.structProjectCapable.getOtClassifyStructProjectFilter(), this.structProjectCapable.getStructProjectFilterFromConfigFilter()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Map<String, Object> getStructProjectCustomInParamWithDate(String prop) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("hr_dataperm_structprojectid_prop_" + prop, Collections.singletonList(this.structProjectCapable.getStructProject().getLong("id")));
        map.put("hr_dataperm_bsedtime", this.getDateParam());
        map.put("hr_dataperm_bsledtime", this.getDateParam());
        return map;
    }
}

