/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.adminorg.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.util.DyCollectors;

public class TreeNodeNameSetter {
    Map<Long, String> idVsCompanyName = new HashMap<Long, String>();
    Map<Long, Boolean> idVsShowCompany = new HashMap<Long, Boolean>();
    Predicate<Long> filterSHowOrgType = AdminOrgConstants.ADMIN_ORG_TYPE_COMPANY_AND_AREA::contains;

    public void beforeEncapsulationTreeMap(DynamicObjectCollection dyColl, Date queryDate) {
        if (dyColl != null) {
            Set idSet = (Set)dyColl.stream().collect(DyCollectors.toIdSet());
            this.packageData(idSet, queryDate);
        }
    }

    public void beforeEncapsulationNode(DynamicObject dy, Date queryDate) {
        if (dy != null) {
            this.packageData(new HashSet<Long>(Collections.singletonList(dy.getLong("id"))), queryDate);
        }
    }

    public String createCompanySuffix(DynamicObject rootDy) {
        long id = rootDy.getLong("id");
        return this.getCompanySuffix(id);
    }

    public String createCompanySuffix(Map<String, String> nodeMap) {
        long id = Long.parseLong(nodeMap.getOrDefault("id", "0"));
        return this.getCompanySuffix(id);
    }

    private void packageData(Set<Long> idSet, Date queryDate) {
        DynamicObject[] adminOrgDys = AdOrgRepository.getInstance().queryOriginalByPks("id, belongcompany.id, adminorgtype.adminorgtypestd.id", idSet);
        Map filteredIdVsCompanyBo = Arrays.stream(adminOrgDys).filter(adminOrg -> this.filterSHowOrgType.test(adminOrg.getLong("adminorgtype.adminorgtypestd.id"))).collect(Collectors.toMap(DyCollectors.getIdMapper(), dy -> dy.getLong("belongcompany.id")));
        if (filteredIdVsCompanyBo.size() == 0) {
            return;
        }
        DynamicObject[] belongAdminOrgs = this.isHis(queryDate) ? AdOrgRepository.getInstance().queryOriginalByBoAndEffDate("boid, name", filteredIdVsCompanyBo.values(), queryDate) : AdOrgRepository.getInstance().queryOrgInfoByBoId("boid, name", new ArrayList<Long>(filteredIdVsCompanyBo.values()));
        Map<Long, String> companyIdVsName = Arrays.stream(belongAdminOrgs).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getString("name")));
        this.idVsCompanyName = filteredIdVsCompanyBo.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> companyIdVsName.getOrDefault(entry.getValue(), "")));
        this.idVsShowCompany = Arrays.stream(adminOrgDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> !AdminOrgConstants.ADMIN_ORG_TYPE_COMPANY_AND_GROUP.contains(dy.getLong("adminorgtype.adminorgtypestd.id"))));
    }

    private String getCompanySuffix(long id) {
        if (this.idVsShowCompany.getOrDefault(id, false).booleanValue()) {
            return this.idVsCompanyName.getOrDefault(id, "");
        }
        return "";
    }

    private boolean isHis(Date queryDate) {
        return queryDate != null;
    }
}

