/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamEmpRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRoleRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class CustAdminOrgTeamListPlugin
extends HRDataBaseList
implements ItemClickListener {
    private static final Log LOGGER = LogFactory.getLog(CustAdminOrgTeamListPlugin.class);
    private Map<Long, Integer> orgTeamRoleCountMap = new HashMap<Long, Integer>(16);
    private Map<Long, Integer> orgTeamEmpCountMap = new HashMap<Long, Integer>(16);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        IFormView formView = this.getView();
        String operateKey = source.getOperateKey();
        LOGGER.info("beforeDoOperation operateKey:{}", (Object)operateKey);
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_ot_change") && (listSelectedData = args.getListSelectedData()).size() != 1) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u3002", (String)"CustAdminOrgTeamListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        LOGGER.info("afterDoOperation operateKey:{}", (Object)operateKey);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        IListView listView = (IListView)this.getView();
        switch (operateKey) {
            case "donothing_ot_change": {
                ListSelectedRowCollection rows = this.getSelectedRows();
                Object primaryKeyValue = rows.get(0).getPrimaryKeyValue();
                String billFormId = listView.getBillFormId();
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setStatus(OperationStatus.EDIT);
                baseShowParameter.setPkId(primaryKeyValue);
                baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                baseShowParameter.setFormId(billFormId);
                listView.showForm((FormShowParameter)baseShowParameter);
                break;
            }
            case "his_disable": 
            case "enable": {
                ITreeListView orgTeamTreeView = listView.getTreeListView();
                orgTeamTreeView.focusRootNode();
                orgTeamTreeView.refresh();
                listView.invokeOperation("refresh");
                break;
            }
            case "donothing_ot_addbyorg": {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("haos_cusotaddbyorg");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setPageId("haos_cusotaddbyorg_" + listView.getPageId());
                FormShowParameter listFormShowParameter = listView.getFormShowParameter();
                formShowParameter.setCustomParam("struct_project_ids", listFormShowParameter.getCustomParam("struct_project_ids"));
                ITreeModel treeModel = listView.getTreeListView().getTreeModel();
                TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)treeModel.getRoot(), (Object)treeModel.getCurrentNodeId());
                formShowParameter.setCustomParam("adminorg", (Object)treeNode.getText());
                formShowParameter.setCustomParam("entitytype.number", (Object)listView.getBillFormId());
                formShowParameter.setHasRight(true);
                long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)listFormShowParameter);
                formShowParameter.setCustomParam("structproject", (Object)structProjectId);
                DynamicObject structProject = CustomStructProjectRepository.getRepository().queryOne("name", (Object)structProjectId);
                formShowParameter.setCaption(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4ece\u884c\u653f\u7ec4\u7ec7\u6dfb\u52a0-%s", (String)"CustAdminOrgTeamListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), structProject.getString("name")));
                listView.showForm(formShowParameter);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Long primaryKeyValue = (Long)list.getFocusRowPkId();
        switch (fieldName) {
            case "number": {
                IFormView formView = this.getView();
                if (!(formView instanceof IListView)) break;
                IListView listView = (IListView)formView;
                String billFormId = listView.getBillFormId();
                ListShowParameter formShowParameter = (ListShowParameter)listView.getFormShowParameter();
                if (primaryKeyValue == null || formShowParameter.isLookUp()) break;
                BaseShowParameter baseShowParameter = new BaseShowParameter();
                baseShowParameter.setFormId(billFormId);
                baseShowParameter.setStatus(OperationStatus.VIEW);
                baseShowParameter.setPkId((Object)primaryKeyValue);
                baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                listView.showForm((FormShowParameter)baseShowParameter);
                args.setCancel(true);
                break;
            }
            case "rolenum": {
                this.showRoleOrPersonViewList(primaryKeyValue, "haos_custroleview");
                args.setCancel(true);
                break;
            }
            case "personnum": {
                this.showRoleOrPersonViewList(primaryKeyValue, "haos_custempview");
                args.setCancel(true);
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        List filters = event.getQFilters();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)formShowParameter);
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            long otClassifyId = CustomStructHelper.getOtClassifyId((FormShowParameter)formShowParameter);
            String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(Long.valueOf(otClassifyId));
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                QFilter filter = (QFilter)it.next();
                if (filter == null) continue;
                switch (filter.getProperty()) {
                    case "teamtype.id": {
                        it.remove();
                        break;
                    }
                    case "number": {
                        String number = filter.getValue().toString();
                        String cp = filter.getCP();
                        if (!HRStringUtils.equals((String)cp, (String)"=") && !HRStringUtils.equals((String)cp, (String)"!=")) break;
                        filter.__setValue((Object)CustomStructHelper.showNumberToRealNumber((String)number, (String)numberPrefix));
                        break;
                    }
                }
            }
            filters.add(new QFilter("otclassify.id", "=", (Object)otClassifyId));
        }
        CustomOrgTeamStructRepository customOrgTeamStructRepository = CustomOrgTeamStructRepository.getRepository();
        DynamicObject rootOrgTeamStruct = customOrgTeamStructRepository.getRootOrgTeamStruct("structlongnumber", structProjectId);
        QFilter filter = new QFilter("structlongnumber", "ftlike", (Object)rootOrgTeamStruct.getString("structlongnumber"));
        filters.add(filter);
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        event.setOrderBy("sortcode");
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String name = args.getFieldName();
        if (HRStringUtils.equals((String)name, (String)"parent.name")) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(2);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            customParams.put("struct_project_ids", formShowParameter.getCustomParam("struct_project_ids"));
            customParams.put("struct_project_classify_id", formShowParameter.getCustomParam("struct_project_classify_id"));
            args.setCustomParams(customParams);
            List customQFilters = args.getCustomQFilters();
            QFilter filter = CustRoleEmpRepository.getInstance().getFilterByStructProject(Long.valueOf(CustomStructHelper.getStructProjectId((FormShowParameter)formShowParameter)), "id");
            customQFilters.add(filter);
        }
    }

    private void showRoleOrPersonViewList(Long orgTeamId, String formId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("orgteam", (Object)orgTeamId);
        this.getView().showForm(formShowParameter);
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "haos_structprojecttab".equals(parentView.getEntityId())) {
            parentView.invokeOperation("close");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection rows = event.getPageData();
        if (rows.isEmpty()) {
            return;
        }
        List orgTeamIds = rows.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        this.orgTeamRoleCountMap = CustomOrgTeamRoleRepository.getRepository().countByOrgTeamIds(orgTeamIds);
        this.orgTeamEmpCountMap = CustomOrgTeamEmpRepository.getRepository().countByOrgTeamIds(orgTeamIds);
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        String fieldKey = columnDesc.getFieldKey();
        DynamicObject rowData = event.getRowData();
        if (HRStringUtils.equals((String)"rolenum", (String)fieldKey)) {
            Integer roleCount = this.orgTeamRoleCountMap.get(rowData.getLong("id"));
            event.setFormatValue((Object)(roleCount != null ? roleCount : 0));
        } else if (HRStringUtils.equals((String)"personnum", (String)fieldKey)) {
            Integer personCount = this.orgTeamEmpCountMap.get(rowData.getLong("id"));
            event.setFormatValue((Object)(personCount != null ? personCount : 0));
        }
    }
}

