/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ITreeListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamStructRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class CustAdminOrgTeamPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(CustAdminOrgTeamPlugin.class);
    private static final List<String> SUCCESS_REFRESH_PARENT_OPERATE_KEY = Lists.newArrayList((Object[])new String[]{"ot_his_newsave", "donothing_ot_confirm_change"});

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit parent = (BasedataEdit)this.getView().getControl("parent");
        parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        BaseShowParameter baseShowParameter = (BaseShowParameter)args.getFormShowParameter();
        OperationStatus status = baseShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            baseShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7", (String)"CustAdminOrgTeamPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView formView = this.getView();
        long structProjectId = this.getStructProjectId();
        IDataModel dataModel = this.getModel();
        dataModel.setValue("structproject", (Object)structProjectId);
        FormShowParameter showParameter = formView.getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            IFormView parentView = formView.getParentView();
            if (parentView instanceof ListView) {
                ITreeListView treeListView = ((ListView)parentView).getTreeListView();
                Object currentNodeId = treeListView.getTreeModel().getCurrentNodeId();
                this.getModel().setValue("parent", currentNodeId);
                FieldEdit parentField = (FieldEdit)formView.getControl("parent");
                parentField.setMustInput(true);
            }
        } else {
            DynamicObject dataEntity = dataModel.getDataEntity();
            String realNumber = dataEntity.getString("number");
            long otClassifyId = dataEntity.getLong("otclassify.id");
            String showNumber = CustomStructHelper.realNumberToShowNumber((String)realNumber, (long)otClassifyId);
            this.getModel().setValue("number", (Object)showNumber);
            long orgTeamId = dataEntity.getLong("id");
            boolean isRoot = CustomOrgTeamStructRepository.getRepository().isRoot(orgTeamId);
            formView.setEnable(Boolean.valueOf(!isRoot), new String[]{"parent"});
            FieldEdit parentField = (FieldEdit)formView.getControl("parent");
            parentField.setMustInput(!isRoot);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        LOGGER.info("beforeDoOperation operateKey:{}", (Object)operateKey);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        if (SUCCESS_REFRESH_PARENT_OPERATE_KEY.contains(operateKey)) {
            IFormView formView = this.getView();
            IFormView parentView = formView.getParentView();
            parentView.invokeOperation("refresh");
            formView.sendFormAction(parentView);
            this.getModel().setDataChanged(false);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_ot_change")) {
            this.getView().setStatus(OperationStatus.EDIT);
        }
        LOGGER.info("afterDoOperation operateKey:{}", (Object)operateKey);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IFormView parentView;
        String name = beforeF7SelectEvent.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"parent") && (parentView = this.getView().getParentView()) != null) {
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.setCustomParam("struct_project_ids", this.getParentViewCustomParam("struct_project_ids"));
            formShowParameter.setCustomParam("struct_project_classify_id", this.getParentViewCustomParam("struct_project_classify_id"));
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            QFilter filter = CustRoleEmpRepository.getInstance().getFilterByStructProject(Long.valueOf(this.getStructProjectId()), "id");
            customQFilters.add(filter);
        }
    }

    private <T> T getParentViewCustomParam(String name) {
        IFormView parentView = this.getView().getParentView();
        return (T)parentView.getFormShowParameter().getCustomParam(name);
    }

    private long getStructProjectId() {
        String structProjectIdsStr = (String)this.getParentViewCustomParam("struct_project_ids");
        List structProjectIds = JSONArray.parseArray((String)structProjectIdsStr, Long.class);
        return (Long)structProjectIds.get(0);
    }
}

