/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.customstruct;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.customstruct.NumberPrefixRepository;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.util.OperateLogUtil;
import kd.hr.haos.common.constants.customstruct.CustomOrgTeamAddByOrgConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.formplugin.web.customstruct.CustomOrgStructTreeView;
import kd.hr.haos.formplugin.web.customstruct.CustomStructTreeView;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class CustomOrgTeamAddByOrgEditPlugin
extends HRDataBaseEdit
implements StructProjectConstants,
CustomOrgTeamAddByOrgConstants,
TreeNodeDragListener,
TreeNodeClickListener {
    private static final Log LOGGER = LogFactory.getLog(CustomOrgTeamAddByOrgEditPlugin.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)CustomOrgTeamAddByOrgEditPlugin.class.getName(), (int)2);
    private static final List<String> checkBoxList = Arrays.asList("orgcheckbox", "othercheckbox");

    public void initialize() {
        super.initialize();
        this.addLabelShowTypeAction("org_tree");
        this.addLabelShowTypeAction("other_tree");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"org_tree_filter", "struct_tree_filter", "clean_org", "clean_struct", "btn_addnode", "btn_delnode", "add_org", "retract", "expand", "vectorap_retract", "vectorap_expand"});
        this.addSearchControlListener();
        TreeView otherTree = (TreeView)this.getView().getControl("other_tree");
        otherTree.addTreeNodeDragListener((TreeNodeDragListener)this);
        otherTree.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void beforeBindData(EventObject evt) {
        IFormView formView = this.getView();
        formView.getPageCache().put("chkshowdisableorg_tree_filter", "false");
        FormShowParameter formShowParameter = formView.getFormShowParameter();
        long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)formShowParameter);
        IDataModel dataModel = this.getModel();
        dataModel.setValue("structproject", (Object)structProjectId);
        String currentNodeName = (String)formShowParameter.getCustomParam("adminorg");
        Future orgTreeFuture = THREAD_POOL.submit(() -> {
            try {
                CustomOrgStructTreeView orgStructTreeView = this.getOrgStructTreeView(true);
                orgStructTreeView.initTree();
            }
            catch (Exception e) {
                LOGGER.error("init org struct view error", (Throwable)e);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        Future otherTreeFuture = THREAD_POOL.submit(() -> {
            try {
                CustomStructTreeView customStructTreeView = this.getCustomStructTreeView(true);
                customStructTreeView.initTree();
                if (StringUtils.isNotEmpty((CharSequence)currentNodeName)) {
                    customStructTreeView.search(currentNodeName);
                }
            }
            catch (Exception e) {
                LOGGER.error("init custom org struct view error", (Throwable)e);
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        try {
            orgTreeFuture.get();
            otherTreeFuture.get();
        }
        catch (Exception exception) {
            LOGGER.error("load tree error", (Throwable)exception);
        }
        this.setStructProjectEffDate();
        Label otherLap = (Label)formView.getControl("otherlap");
        String structProjectName = dataModel.getDataEntity().getString("structproject.name");
        otherLap.setText(structProjectName);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"continue_close") && evt.getResult() == MessageBoxResult.Yes) {
            IFormView formView = this.getView();
            IPageCache pageCache = formView.getPageCache();
            pageCache.remove("struct_project_date");
            FormShowParameter showParameter = formView.getFormShowParameter();
            showParameter.setStatus(OperationStatus.VIEW);
            pageCache.put("close_confirmed_cache_key", "true");
            formView.close();
        } else if (HRStringUtils.equals((String)callBackId, (String)"btn_delnode") && evt.getResult() == MessageBoxResult.Yes) {
            this.deleteNodes(this.getCustomStructTreeView(false));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        if (checkBoxList.contains(name)) {
            String treeName = "orgcheckbox".equals(name) ? "org_tree" : "other_tree";
            this.setCcn((Boolean)args.getChangeSet()[0].getNewValue(), treeName);
        } else if ("bsed".equals(name)) {
            this.getView().getPageCache().put("struct_project_date", "true");
        } else if ("chkshowdisable".equals(name)) {
            Boolean checkShowDisable = (Boolean)args.getChangeSet()[0].getNewValue();
            this.getPageCache().put("chkshowdisableorg_tree_filter", Boolean.toString(checkShowDisable));
            TreeView orgTreeView = (TreeView)this.getControl("org_tree");
            orgTreeView.deleteAllNodes();
            this.getOrgStructTreeView(false).initTree();
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (HRStringUtils.equals((String)"clean_org", (String)key) || HRStringUtils.equals((String)"clean_struct", (String)key)) {
            TreeView treeView = HRStringUtils.equals((String)"clean_org", (String)key) ? (TreeView)this.getControl("org_tree") : (TreeView)this.getControl("other_tree");
            List selectIds = treeView.getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)selectIds)) {
                return;
            }
            treeView.uncheckNodes(selectIds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        CustomStructTreeView customStructTreeView = this.getCustomStructTreeView(false);
        switch (key) {
            case "btn_delnode": {
                if (this.checkDelete(customStructTreeView)) {
                    evt.setCancel(true);
                    break;
                }
                this.deleteNodes(customStructTreeView);
                break;
            }
            case "btn_addnode": {
                TreeView orgTreeView = (TreeView)this.getControl("org_tree");
                if (this.checkAdd(customStructTreeView, orgTreeView)) {
                    evt.setCancel(true);
                    return;
                }
                List selectedList = orgTreeView.getTreeState().getSelectedNodeId();
                customStructTreeView.addNodes(selectedList);
                orgTreeView.uncheckNodes(selectedList);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"btnsave")) {
            IFormView formView = this.getView();
            CustomStructTreeView customStructTreeView = this.getCustomStructTreeView(false);
            List<OtherStructVO> otherStructVos = customStructTreeView.getOtherStructList();
            if (CollectionUtils.isEmpty(otherStructVos)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u4fe1\u606f\u4fee\u6539\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CustomOrgTeamAddByOrgEditPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                String appId = formView.getFormShowParameter().getAppId();
                String permEntityNumber = this.getPermEntityNumber();
                boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)permEntityNumber, (String)"3ZD+BCF49Q+6");
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)permEntityNumber);
                String displayName = dataEntityType.getDisplayName().getLocaleValue();
                if (!hasPermission) {
                    formView.showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u4ece\u884c\u653f\u7ec4\u7ec7\u6dfb\u52a0\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CustomOrgTeamAddByOrgEditPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), displayName));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"btnsave")) {
            return;
        }
        CustomStructTreeView customStructTreeView = this.getCustomStructTreeView(false);
        List<OtherStructVO> otherStructVos = customStructTreeView.getOtherStructList();
        if (!CollectionUtils.isEmpty(otherStructVos)) {
            List vos = otherStructVos.stream().filter(vo -> vo.getChangeTypeId() == 1010L).collect(Collectors.toList());
            int size = vos.size();
            Set parentIds = vos.stream().map(OtherStructVO::getParentId).collect(Collectors.toSet());
            CustomOrgTeamRepository customOrgTeamRepository = CustomOrgTeamRepository.getRepository();
            Map parentNodeOrgTeamMap = customOrgTeamRepository.queryByIds(new ArrayList(parentIds), null);
            String newNodeInfoMapStr = this.getPageCache().get("newNodeInfo_cache_key");
            Map orgMap = (Map)SerializationUtils.fromJsonString((String)newNodeInfoMapStr, Map.class);
            ArrayList<DynamicObject> orgTeams = new ArrayList<DynamicObject>(size);
            long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)this.getView().getFormShowParameter());
            DynamicObject structProject = CustomStructProjectRepository.getRepository().queryOne("otclassify.id", (Object)structProjectId);
            long[] orgTeamIds = ORM.create().genLongIds("haos_cusadminorgteam", size);
            for (int i = 0; i < size; ++i) {
                OtherStructVO vo2 = (OtherStructVO)vos.get(i);
                DynamicObject orgTeam = customOrgTeamRepository.generateEmptyDynamicObject();
                orgTeams.add(orgTeam);
                long orgId = vo2.getOrgId();
                long orgTeamId = orgTeamIds[i];
                orgTeam.set("id", (Object)orgTeamId);
                parentNodeOrgTeamMap.put(orgId, orgTeam);
                Long parentId = vo2.getParentId();
                DynamicObject parentOrgTeam = (DynamicObject)parentNodeOrgTeamMap.get(parentId);
                orgTeam.set("parent", (Object)parentOrgTeam);
                Map org = (Map)orgMap.get(String.valueOf(orgId));
                orgTeam.set("number", org.get("number"));
                orgTeam.set("name", org.get("name"));
                orgTeam.set("bsed", (Object)HRDateTimeUtils.truncateDate((Date)new Date()));
                orgTeam.set("parent", (Object)parentOrgTeam);
                orgTeam.set("structproject", (Object)structProject);
            }
            String numberPrefix = NumberPrefixRepository.getRepository().getNumberPrefixById(Long.valueOf(structProject.getLong("otclassify.id")));
            String customOrgTeamEntityName = CustomStructHelper.getCustomOrgTeamEntityName((String)numberPrefix);
            OperationResult result = OperationServiceHelper.executeOperate((String)"ot_his_newsave", (String)customOrgTeamEntityName, (DynamicObject[])orgTeams.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            IFormView formView = this.getView();
            if (result.isSuccess()) {
                IFormView parentView = formView.getParentView();
                if (parentView instanceof ListView) {
                    IListView listView = (IListView)parentView;
                    ITreeListView treeListView = listView.getTreeListView();
                    treeListView.focusRootNode();
                    IPageCache pageCache = parentView.getPageCache();
                    TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)pageCache);
                    pageCache.put("treeConditionChanged", "true");
                    treeListView.refresh();
                    listView.invokeOperation("refresh");
                    String opDescription = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"CustomOrgTeamAddByOrgEditPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                    listView.showSuccessNotification(opDescription);
                    formView.sendFormAction((IFormView)listView);
                    MultiLangEnumBridge langEnumBridge = new MultiLangEnumBridge("\u4fdd\u5b58", "GenMetaDataHelper_0", "hrmp-haos-business");
                    OperateLogUtil.addOperateLog((String)operateKey, (String)"haos_cusotaddbyorg", (MultiLangEnumBridge)langEnumBridge);
                }
                IPageCache pageCache = formView.getPageCache();
                pageCache.put("close_confirmed_cache_key", "true");
                pageCache.remove("struct_project_date");
                formView.close();
            } else {
                formView.showOperationResult(result);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        super.beforeClosed(evt);
        IFormView formView = this.getView();
        IPageCache pageCache = formView.getPageCache();
        String closeConfirmed = pageCache.get("close_confirmed_cache_key");
        if (HRStringUtils.equals((String)closeConfirmed, (String)"true")) {
            return;
        }
        String dateChg = pageCache.get("struct_project_date");
        CustomStructTreeView customStructTreeView = this.getCustomStructTreeView(false);
        List<OtherStructVO> otherStructVos = customStructTreeView.getOtherStructList();
        if (HRStringUtils.isNotEmpty((String)dateChg) || !CollectionUtils.isEmpty(otherStructVos)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"HRBaseDataCommonBillEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"HRBaseDataCommonBillEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = MessageFormat.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f{0}\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HRBaseDataCommonBillEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), System.lineSeparator());
            formView.showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            evt.setCancel(Boolean.TRUE.booleanValue());
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent treeNodeDragEvent) {
        String nodeId = (String)treeNodeDragEvent.getNodeId();
        String toParentId = (String)treeNodeDragEvent.getToParentId();
        this.getCustomStructTreeView(false).treeNodeDragged(nodeId, toParentId);
    }

    private void setStructProjectEffDate() {
        IDataModel dataModel = this.getModel();
        DynamicObject dynamicObject = dataModel.getDataEntity().getDynamicObject("structproject");
        Date date = HRDateTimeUtils.getNowDate();
        if (dynamicObject != null && HRStringUtils.equals((String)"10", (String)dynamicObject.getString("enable"))) {
            date = dynamicObject.getDate("effdt");
        }
        dataModel.setValue("bsed", (Object)date);
    }

    private boolean checkDelete(CustomStructTreeView customStructTreeView) {
        List selectedList = customStructTreeView.getTreeView().getTreeState().getSelectedNodes();
        if (CollectionUtils.isEmpty((Collection)selectedList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean checkAdd(CustomStructTreeView customStructTreeView, TreeView orgTreeView) {
        List srcSelectedList = orgTreeView.getTreeState().getSelectedNodeId();
        IFormView formView = this.getView();
        if (CollectionUtils.isEmpty((Collection)srcSelectedList)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (customStructTreeView.getRootNode() == null) {
            if (srcSelectedList.size() > 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4ece\u5de6\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u6dfb\u52a0\u4e3a\u6839\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"OtherStructDetailEditPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[]{srcSelectedList.size()}));
                return true;
            }
        } else {
            List targetSelectedList = customStructTreeView.getTreeView().getTreeState().getSelectedNodeId();
            if (CollectionUtils.isEmpty((Collection)targetSelectedList)) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\u3002", (String)"OtherStructDetailEditPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                return true;
            }
            if (targetSelectedList.size() > 1) {
                formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u4f5c\u4e3a\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a%s\u3002", (String)"OtherStructDetailEditPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[]{targetSelectedList.size()}));
                return true;
            }
        }
        return customStructTreeView.checkPerm(srcSelectedList);
    }

    private void addSearchControlListener() {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (!HRStringUtils.isEmpty((String)searchText)) {
                this.getOrgStructTreeView(false).search(searchText);
            }
        });
        ((Search)this.getControl("othersearch")).addEnterListener(searchEnterEvt -> {
            String searchText = searchEnterEvt.getText();
            if (!HRStringUtils.isEmpty((String)searchText)) {
                this.getCustomStructTreeView(false).search(searchText);
            }
        });
    }

    private void addLabelShowTypeAction(String value) {
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("key", value);
        map.put("labelShowType", 1);
        service.addAction("u", map);
    }

    private void deleteNodes(CustomStructTreeView customStructTreeView) {
        customStructTreeView.deleteNodes();
    }

    private void setCcn(boolean flag, String name) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("ccn", flag);
        map.put("cpn", Boolean.FALSE);
        this.getView().updateControlMetadata(name, map);
    }

    private CustomOrgStructTreeView getOrgStructTreeView(boolean isInitTree) {
        String permEntityNumber = this.getPermEntityNumber();
        return new CustomOrgStructTreeView((TreeView)this.getControl("org_tree"), isInitTree, permEntityNumber);
    }

    private CustomStructTreeView getCustomStructTreeView(boolean isInitTree) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String permEntityNumber = (String)formShowParameter.getCustomParam("entitytype.number");
        Long structProjectId = (Long)formShowParameter.getCustomParam("structproject");
        return new CustomStructTreeView((TreeView)this.getControl("other_tree"), isInitTree, permEntityNumber, structProjectId);
    }

    private String getPermEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        return (String)formShowParameter.getCustomParam("entitytype.number");
    }
}

