/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.custroleemprel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.metadata.edit.PersonEdit;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.i18n.api.model.TelephoneParseResult;
import kd.bos.i18n.mservice.I18nServiceHelper;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.StructProjectPermUitl;
import kd.hr.haos.business.domain.repository.CommonRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomStructProjectRepository;
import kd.hr.haos.business.domain.repository.custroleemp.CustRoleEmpRepository;
import kd.hr.haos.business.util.CustomRoleEmpUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class CustRoleEmpRelPlugin
extends HRDynamicFormBasePlugin
implements RowClickEventListener,
BeforeF7SelectListener {
    private static Log LOGGER = LogFactory.getLog(CustRoleEmpRelPlugin.class);
    private static final String INDEX_DESC = "index desc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid billList = (EntryGrid)this.getView().getControl("entryentity");
        billList.addRowClickListener((RowClickEventListener)this);
        BasedataEdit enOrgTeam = (BasedataEdit)this.getView().getControl("enorgteam");
        enOrgTeam.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit enCustomorole = (BasedataEdit)this.getView().getControl("encustomorole");
        enCustomorole.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Boolean datasource = (Boolean)showParameter.getCustomParam("datasource");
        String key = (String)showParameter.getCustomParam("operateKey");
        if (Boolean.TRUE.equals(datasource) && "addperson".equals(key)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u4f01\u4e1a\u5185\u5458\u5de5", (String)"CustRoleEmpRelListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
        if (Boolean.FALSE.equals(datasource) && "addperson".equals(key)) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u5916\u90e8\u4eba\u5458", (String)"CustRoleEmpRelListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Boolean datasource = (Boolean)showParameter.getCustomParam("datasource");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (Boolean.TRUE.equals(datasource)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"name", "outpernumber"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"phone", "gender", "perdesc"});
            PersonEdit depempEdit = (PersonEdit)this.getView().getControl("depemp");
            depempEdit.setMustInput(true);
            if (dataEntity.getDynamicObject("depemp") != null) {
                DynamicObject depempDy = dataEntity.getDynamicObject("depemp");
                this.fillInerPerInfo(depempDy.getLong("person.id"), depempDy.getLong("employee.id"));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"depemp"});
            DynamicObject outPerson = dataEntity.getDynamicObject("outperson");
            if (outPerson != null) {
                this.getModel().setValue("outpernumber", outPerson.get("number"));
                this.getModel().setValue("gender", outPerson.get("gender"));
                this.getModel().setValue("perdesc", outPerson.get("description"));
                this.getModel().setValue("phone", outPerson.get("phone"));
            }
            TextEdit textEdit = (TextEdit)this.getView().getControl("name");
            textEdit.setMustInput(true);
            TextEdit numberEdit = (TextEdit)this.getView().getControl("outpernumber");
            numberEdit.setMustInput(true);
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)status) || OperationStatus.EDIT.equals((Object)status)) {
            DynamicObject[] entryDys;
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
            DynamicObject dy = this.getModel().getDataEntity(true);
            this.getView().getModel().beginInit();
            QFilter filter = null;
            if (Boolean.TRUE.equals(datasource)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"perdesc", "depemp"});
                filter = new QFilter("depemp.employee.id", "=", (Object)dy.getLong("depemp.employee.id")).and(QFilterHelper.createValidHisCurrentDataFilter());
            } else {
                filter = new QFilter("outperson.id", "=", (Object)dy.getLong("outperson.id")).and(QFilterHelper.createValidHisCurrentDataFilter());
            }
            if (this.getView().getParentView() != null) {
                long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)this.getView().getParentView().getFormShowParameter());
                filter.and(CustRoleEmpRepository.getInstance().getFilterByStructProject(Long.valueOf(structProjectId), "orgteam.id"));
            }
            if ((entryDys = CommonRepository.queryDynamicObjects((String)"haos_cusempposorgrel", (String)"", (String)INDEX_DESC, (QFilter[])new QFilter[]{filter})) == null || entryDys.length == 0) {
                return;
            }
            this.getModel().beginInit();
            int[] rows = this.getModel().batchCreateNewEntryRow("entryentity", entryDys.length);
            for (int i = 0; i < entryDys.length; ++i) {
                DynamicObject entryDy = entryDys[i];
                this.getModel().setValue("enorgteam", (Object)entryDy.getLong("orgteam.id"), rows[i]);
                this.getModel().setValue("encustomorole", (Object)entryDy.getLong("customorole.id"), rows[i]);
                this.getModel().setValue("enischarge", entryDy.get("ischarge"), rows[i]);
                this.getModel().setValue("enstartdate", (Object)entryDy.getDate("startdate"), rows[i]);
                this.getModel().setValue("ensysenddate", (Object)entryDy.getDate("sysenddate"), rows[i]);
                this.getModel().setValue("endescription", entryDy.get("description"), rows[i]);
                this.getModel().setValue("enindex", entryDy.get("index"), rows[i]);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        if (OperationStatus.ADDNEW.equals((Object)status) && this.getView().getParentView() != null && this.getView().getParentView() instanceof ListView) {
            Object currentNodeId = ((ListView)this.getView().getParentView()).getTreeListView().getTreeModel().getCurrentNodeId();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", 0);
            if (entryRowEntity != null) {
                this.getModel().deleteEntryRow("entryentity", 0);
            }
            this.getView().getModel().beginInit();
            int[] row = this.getModel().batchCreateNewEntryRow("entryentity", 1);
            this.getModel().setValue("enorgteam", currentNodeId, row[0]);
            this.getView().getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void afterBindData(EventObject e) {
        String key;
        String title;
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnrolemodify"});
            Boolean datasource = (Boolean)showParameter.getCustomParam("datasource");
            if (Boolean.TRUE.equals(datasource)) {
                title = ResManager.loadKDString((String)"\u6dfb\u52a0\u4f01\u4e1a\u5185\u5458\u5de5", (String)"CustRoleEmpRelListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                this.getView().setFormTitle(new LocaleString(title));
            } else {
                title = ResManager.loadKDString((String)"\u6dfb\u52a0\u5916\u90e8\u4eba\u5458", (String)"CustRoleEmpRelListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                this.getView().setFormTitle(new LocaleString(title));
            }
        }
        if ("his_modifyopen".equals(key = (String)showParameter.getCustomParam("operateKey"))) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getView().setStatus(OperationStatus.EDIT);
        }
        if (OperationStatus.VIEW.equals((Object)status)) {
            title = ResManager.loadKDString((String)"\u6210\u5458", (String)"CustRoleEmpRelPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            String name = this.getModel().getDataEntity().getString("name");
            this.getView().setFormTitle(new LocaleString(title.concat("-").concat(name)));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (e.getChangeSet() == null || e.getChangeSet().length == 0) {
            return;
        }
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObject dynamicObject = changeData.getDataEntity();
        switch (fieldKey) {
            case "depemp": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (HRObjectUtils.isEmpty((Object)newValue)) {
                    this.getModel().setValue("perdesc", (Object)"");
                    return;
                }
                if (!(newValue instanceof DynamicObject)) break;
                DynamicObject depempDy = (DynamicObject)newValue;
                this.getModel().setValue("name", depempDy.get("person.name"));
                this.fillInerPerInfo(depempDy.getLong("person.id"), depempDy.getLong("employee.id"));
                break;
            }
            case "encustomorole": {
                ChangeData[] changeDataArr = e.getChangeSet();
                int rowIndex = changeDataArr[0].getRowIndex();
                Object enRole = e.getChangeSet()[0].getNewValue();
                if (enRole instanceof DynamicObject) {
                    DynamicObject enRoleDy = (DynamicObject)enRole;
                    this.getModel().setValue("enorgteam", enRoleDy.get("orgteam"), rowIndex);
                    break;
                }
            }
            case "enstartdate": {
                if (changeData.getNewValue() == null || dynamicObject == null || dynamicObject.getDate("ensysenddate") == null || !dynamicObject.getDate("ensysenddate").before((Date)changeData.getNewValue())) break;
                this.getModel().beginInit();
                this.getModel().setValue("enstartdate", null, changeData.getRowIndex());
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u5e94\u65e9\u4e8e\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u3002", (String)"CustRoleEmpRelListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                break;
            }
            case "ensysenddate": {
                if (changeData.getNewValue() == null || dynamicObject == null || dynamicObject.getDate("enstartdate") == null || !dynamicObject.getDate("enstartdate").after((Date)changeData.getNewValue())) break;
                this.getModel().beginInit();
                this.getModel().setValue("ensysenddate", null, changeData.getRowIndex());
                this.getModel().endInit();
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4efb\u804c\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u4efb\u804c\u5f00\u59cb\u65e5\u671f\u3002", (String)"CustRoleEmpRelListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                break;
            }
            case "outpernumber": {
                String number;
                if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus()) || !HRStringUtils.isNotEmpty((String)(number = dynamicObject.getString("outpernumber")))) break;
                QFilter outFilter = new QFilter("number", "=", (Object)number).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
                DynamicObject[] dys = CommonRepository.queryDynamicObjects((String)"haos_outperson", (String)"name,phone,gender,description", (QFilter[])new QFilter[]{outFilter});
                if (dys != null && dys.length > 0) {
                    DynamicObject outPerson = dys[0];
                    this.getModel().setValue("name", outPerson.get("name"));
                    this.getModel().setValue("gender", outPerson.get("gender"));
                    this.getModel().setValue("perdesc", outPerson.get("description"));
                    this.getModel().setValue("phone", outPerson.get("phone"));
                    break;
                }
                this.getModel().setValue("name", null);
                this.getModel().setValue("gender", null);
                this.getModel().setValue("perdesc", null);
                this.getModel().setValue("phone", null);
                break;
            }
        }
    }

    private void fillInerPerInfo(long personId, long employeeId) {
        Map result;
        HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
        paramMap.put("searchType", Arrays.asList("001", "003"));
        paramMap.put("identifyId", Collections.singletonList(String.valueOf(personId)));
        paramMap.put("identifyIdType", "PERID");
        String phone = null;
        String gener = null;
        String perdesc = null;
        try {
            Map contentMap;
            result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonGenericQueryService", (String)"queryEmployeeInfo", (Object[])new Object[]{paramMap});
            if (result != null && (contentMap = (Map)result.get(String.valueOf(personId))) != null) {
                List percontactMaps;
                List pernontspropMaps;
                if (contentMap.get("hrpi_pernontsprop") instanceof List && !CollectionUtils.isEmpty((Collection)(pernontspropMaps = (List)contentMap.get("hrpi_pernontsprop"))) && ((Map)pernontspropMaps.get(0)).get("gender_id") != null) {
                    gener = ((Map)pernontspropMaps.get(0)).get("gender_id").toString();
                }
                if (contentMap.get("hrpi_percontact") instanceof List && !CollectionUtils.isEmpty((Collection)(percontactMaps = (List)contentMap.get("hrpi_percontact"))) && ((Map)percontactMaps.get(0)).get("phone") != null) {
                    phone = ((Map)percontactMaps.get(0)).get("phone").toString();
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("queryEmployeeInfo_ex", (Throwable)exception);
        }
        try {
            result = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"getEmpentrel", (Object[])new Object[]{employeeId});
            LOGGER.info("getEmpentrel_result:{}", (Object)result);
            if (result != null && result.get("description") instanceof String) {
                perdesc = result.get("description").toString();
            }
        }
        catch (Exception exception) {
            LOGGER.error("getEmpentrel_ex", (Throwable)exception);
        }
        this.getModel().setValue("phone", phone);
        this.getModel().setValue("gender", gener);
        this.getModel().setValue("perdesc", perdesc);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        switch (operateKey) {
            case "btnsave": {
                IDataModel model = this.getModel();
                model.setValue("bsed", (Object)new Date());
                model.setValue("datasource", showParameter.getCustomParam("datasource"));
                break;
            }
            case "modify": {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().updateView("entryentity");
                break;
            }
            case "his_rolemodify": {
                String name = this.getModel().getDataEntity().getLocaleString("name").getLocaleValue();
                ArrayList<String> tipMsgList = new ArrayList<String>(8);
                StringBuilder tipMsg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199", (String)"CustRoleEmpRelPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                if (HRStringUtils.isEmpty((String)name)) {
                    tipMsgList.add(ResManager.loadKDString((String)"\u201c\u59d3\u540d\u201d", (String)"CustRoleEmpRelPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                }
                if (CollectionUtils.isEmpty(tipMsgList)) break;
                for (int i = 0; i < tipMsgList.size(); ++i) {
                    if (i == tipMsgList.size() - 1) {
                        tipMsg.append((String)tipMsgList.get(i));
                        continue;
                    }
                    tipMsg.append((String)tipMsgList.get(i)).append('\u3001');
                }
                this.getView().showTipNotification(tipMsg.toString());
                args.setCancel(true);
                break;
            }
        }
    }

    private String validPhone(String phone) {
        TelephoneParseResult telephoneParseResult = I18nServiceHelper.parseTelephone((String)phone);
        if (!telephoneParseResult.isSuccess()) {
            return ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d", (String)"CustRoleEmpRelPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        }
        List countryList = telephoneParseResult.getCountryList();
        Map result = I18nServiceHelper.verifyTelephoneNumberFormat((String)telephoneParseResult.getTelephone(), (String[])countryList.toArray(new String[0]));
        if (HRObjectUtils.isEmpty((Object)result)) {
            return ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d", (String)"CustRoleEmpRelPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        }
        if (!HRStringUtils.equals((String)Boolean.TRUE.toString(), (String)((String)result.get("code")))) {
            return ResManager.loadKDString((String)"\u201c\u8054\u7cfb\u7535\u8bdd\u201d", (String)"CustRoleEmpRelPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null) {
            String msg;
            if (operationResult.isSuccess() && "btnsave".equals(operateKey)) {
                this.getModel().setDataChanged(false);
                msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"CustRoleEmpRelPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                CustomRoleEmpUtils.showMsg((String)msg, (IFormView)this.getView(), (boolean)true);
            }
            if (operationResult.isSuccess() && "his_rolemodify".equals(operateKey)) {
                this.getModel().setDataChanged(false);
                msg = ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f", (String)"CustomRoleListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
                CustomRoleEmpUtils.showMsg((String)msg, (IFormView)this.getView(), (boolean)true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        if (dataEntity == null || customQFilters == null) {
            return;
        }
        switch (name) {
            case "enorgteam": {
                long orgTeamId;
                this.roleEmpBeforeF7Qfilter(beforeF7SelectEvent, "id");
                Object enRoleDy = this.getModel().getValue("encustomorole");
                if (enRoleDy instanceof DynamicObject && (orgTeamId = ((DynamicObject)enRoleDy).getLong("orgteam.id")) != 0L) {
                    customQFilters.add(new QFilter("id", "=", (Object)orgTeamId));
                }
                if (this.getView().getParentView() != null) {
                    Map hasPermOrgTeamMap;
                    String numberPrefix = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("numberprefix");
                    String customParam = (String)this.getView().getParentView().getFormShowParameter().getCustomParam("struct_project_ids");
                    List ids = SerializationUtils.fromJsonStringToList((String)customParam, Long.class);
                    AuthorizedOrgTeamResult authorizedOrgResult = StructProjectPermUitl.getPermOrgResult((String)("haos_cusadminorgteam_" + numberPrefix));
                    if (!authorizedOrgResult.isHasAllOrgPerm() && (hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap()) != null && !hasPermOrgTeamMap.isEmpty()) {
                        List hasPermOrgIds = (List)hasPermOrgTeamMap.get(ids.get(0));
                        if (hasPermOrgIds != null && hasPermOrgIds.size() > 0) {
                            customQFilters.add(new QFilter("id", "in", (Object)hasPermOrgIds));
                        } else {
                            customQFilters.add(new QFilter("id", "=", (Object)-1L));
                        }
                    }
                }
                this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"orgteam");
                this.getView().cacheFormShowParameter();
                break;
            }
            case "encustomorole": {
                this.roleEmpBeforeF7Qfilter(beforeF7SelectEvent, "orgteam.id");
                Object orgTeam = this.getModel().getValue("enorgteam");
                if (orgTeam instanceof DynamicObject) {
                    long orgTeamId = ((DynamicObject)orgTeam).getLong("id");
                    customQFilters.add(new QFilter("orgteam.id", "=", (Object)orgTeamId));
                }
                ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                listShowParameter.setFormId("bos_listf7");
                break;
            }
        }
    }

    private void roleEmpBeforeF7Qfilter(BeforeF7SelectEvent beforeF7SelectEvent, String selKey) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            FormShowParameter formShowParameter = parentView.getFormShowParameter();
            String structProjectIdsStr = (String)formShowParameter.getCustomParam("struct_project_ids");
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_ids", (Object)structProjectIdsStr);
            List ids = SerializationUtils.fromJsonStringToList((String)structProjectIdsStr, Long.class);
            DynamicObject customStructProject = CustomStructProjectRepository.getRepository().queryOne("otclassify", ids.get(0));
            if (!HRObjectUtils.isEmpty((Object)customStructProject)) {
                DynamicObject otClassify = customStructProject.getDynamicObject("otclassify");
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("struct_project_classify_id", (Object)otClassify.getLong("id"));
            }
            List customQFilters = beforeF7SelectEvent.getCustomQFilters();
            long structProjectId = CustomStructHelper.getStructProjectId((FormShowParameter)formShowParameter);
            QFilter filter = CustRoleEmpRepository.getInstance().getFilterByStructProject(Long.valueOf(structProjectId), selKey);
            customQFilters.add(filter);
        }
    }
}

