/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.iexport;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.KeyValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamEmpRepository;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRoleRepository;

public class CustomOrgTeamExport
implements HRExportPlugin {
    private static Log LOGGER = LogFactory.getLog(CustomOrgTeamExport.class);

    public void beforeWriteData(BeforeWriteDataEventArgs args) {
        List keys = args.getFieldCaptions();
        List dataRows = args.getListDataRows();
        Map rowDataPkIds = args.getRowDataPkIds();
        int rolenumIndex = -1;
        int personnumIndex = -1;
        if (!(keys == null || keys.isEmpty() || dataRows == null || dataRows.isEmpty() || rowDataPkIds == null || rowDataPkIds.isEmpty())) {
            try {
                for (KeyValue keyVal : keys) {
                    if ("rolenum".equals(keyVal.key)) {
                        rolenumIndex = keyVal.seq + 1;
                        continue;
                    }
                    if (!"personnum".equals(keyVal.key)) continue;
                    personnumIndex = keyVal.seq + 1;
                }
                if (rolenumIndex == -1 && personnumIndex == -1) {
                    return;
                }
                List orgTeamIds = rowDataPkIds.values().stream().map(val -> val.getOrDefault("default", 0L)).collect(Collectors.toList());
                Map orgTeamRoleCountMap = CustomOrgTeamRoleRepository.getRepository().countByOrgTeamIds(orgTeamIds);
                Map orgTeamEmpCountMap = CustomOrgTeamEmpRepository.getRepository().countByOrgTeamIds(orgTeamIds);
                for (int index = 0; index < dataRows.size(); ++index) {
                    Integer count;
                    List dataRow = (List)dataRows.get(index);
                    if (rowDataPkIds.get(index + 1) == null || ((Map)rowDataPkIds.get(index + 1)).get("default") == null) continue;
                    Long id = ((Map)rowDataPkIds.get(index + 1)).getOrDefault("default", 0L);
                    if (rolenumIndex != -1) {
                        count = (Integer)orgTeamRoleCountMap.get(id);
                        dataRow.set(rolenumIndex, count != null ? count : 0);
                    }
                    if (personnumIndex == -1) continue;
                    count = (Integer)orgTeamEmpCountMap.get(id);
                    dataRow.set(personnumIndex, count != null ? count : 0);
                }
            }
            catch (Exception exception) {
                LOGGER.error("beforeWriteData ex:", (Throwable)exception);
            }
        }
    }
}

