/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.iexport;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.customstruct.CustomOrgTeamRepository;
import kd.hr.haos.formplugin.web.iexport.CustomImportBase;
import kd.hr.haos.formplugin.web.iexport.util.CustomeImportUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.impt.common.dto.ImportBillData;
import kd.hr.impt.common.plugin.AfterConvertDynamicObjectsEventArgs;
import kd.hr.impt.common.plugin.AfterInitContextArgs;
import kd.hr.impt.common.plugin.AfterParseBillDataEventArgs;
import kd.hr.impt.common.plugin.AfterQueryRefBdEventArgs;
import kd.hr.impt.common.plugin.BeforeCallOperationEventArgs;
import kd.hr.impt.common.plugin.BeforeValidateEventArgs;

public class CustomOrgTeamImport
extends CustomImportBase {
    private static Log LOGGER = LogFactory.getLog(CustomOrgTeamImport.class);
    private static final HRBaseServiceHelper STRUCT_PROJECT = new HRBaseServiceHelper("haos_customstructproject");
    private static final HRBaseServiceHelper CUS_ADMINORGTEAM = new HRBaseServiceHelper("haos_cusadminorgteam");
    private static final HRBaseServiceHelper OT_STRUCT = new HRBaseServiceHelper("haos_customotstruct");
    private static final String NO_PERM = "no_perm";
    private static final String HASPERM_ORGNUMBER = "hasPermOrgNumber";
    private static final String HASPERM_ORGTEAMBOID = "hasPermOrgTeamBoId";
    private static final String REPLACEORG_MAP = "replaceOrgMap";

    public void afterInitContext(AfterInitContextArgs args) {
        args.setEnableSequenceInstore(true);
    }

    public void afterQueryRefBd(AfterQueryRefBdEventArgs args) {
        super.afterQueryRefBd(args);
        if ("haos_cusadminorgteam".equals(args.getBaseDataName()) && !args.isImportInvoke()) {
            args.setDatas(null);
        }
    }

    public void afterParseBillData(AfterParseBillDataEventArgs args) {
        String parentNumber;
        JSONObject parentOrg;
        ImportBillData importBillData = args.getData();
        String exParams = args.getExtParams();
        if (importBillData == null || importBillData.getData() == null || importBillData.getMainEntityId() == null || HRStringUtils.isEmpty((String)exParams)) {
            LOGGER.error("afterParseBillData");
            return;
        }
        String numberPrefix = CustomeImportUtil.getNumberPrefixFromExParams(exParams);
        if (HRStringUtils.isEmpty((String)numberPrefix)) {
            LOGGER.error("afterParseBillData numberPrefix is empty");
            return;
        }
        JSONObject jsonObject = importBillData.getData().getJSONObject(importBillData.getMainEntityId());
        if (jsonObject == null) {
            return;
        }
        String number = jsonObject.getString("number");
        if (HRStringUtils.isNotEmpty((String)number)) {
            jsonObject.put("number", (Object)(numberPrefix.toUpperCase(Locale.ROOT) + "_" + number));
        }
        if ((parentOrg = jsonObject.getJSONObject("parent")) != null && HRStringUtils.isNotEmpty((String)(parentNumber = parentOrg.getString("number")))) {
            parentOrg.put("number", (Object)(numberPrefix.toUpperCase(Locale.ROOT) + "_" + parentNumber));
        }
    }

    public void beforeValidate(BeforeValidateEventArgs args) {
        if ("new".equals(args.getContext().getImporttype())) {
            List datas = args.getBillDatas();
            if (datas == null) {
                LOGGER.info("beforeValidate datas is null");
                return;
            }
            String exParams = args.getExtParams();
            String numberPrefix = CustomeImportUtil.getNumberPrefixFromExParams(exParams);
            if (HRStringUtils.isEmpty((String)numberPrefix)) {
                LOGGER.error("beforeValidate numberPrefix is null");
                return;
            }
            Long structProjectId = CustomeImportUtil.getStructProjectFromExParams(exParams);
            ConcurrentHashMap<String, Object> customParams = args.getCustomParams();
            if (customParams == null) {
                customParams = new ConcurrentHashMap<String, Object>(2);
                args.setCustomParams(customParams);
            }
            String hasPermOrgNumber = (String)customParams.get(HASPERM_ORGNUMBER);
            Long hasPermOrgTeamBoId = (Long)customParams.get(HASPERM_ORGTEAMBOID);
            if (hasPermOrgNumber == null || hasPermOrgTeamBoId == null) {
                String orgMetaData = "haos_cusadminorgteam_" + numberPrefix.toLowerCase(Locale.ROOT);
                DynamicObject hasPermOrgTeam = this.getHasPermOrgTeam(orgMetaData, structProjectId);
                if (hasPermOrgTeam == null) {
                    customParams.put(NO_PERM, Boolean.TRUE);
                    hasPermOrgTeam = this.getRootOrgTeam(structProjectId);
                }
                if (hasPermOrgTeam != null) {
                    hasPermOrgNumber = hasPermOrgTeam.getString("number");
                    hasPermOrgTeamBoId = hasPermOrgTeam.getLong("id");
                    LOGGER.info("hasPermOrgNumber:{} hasPermOrgTeamBoId:{}", (Object)hasPermOrgNumber, (Object)hasPermOrgTeamBoId);
                }
                customParams.put(HASPERM_ORGNUMBER, hasPermOrgNumber);
                customParams.put(HASPERM_ORGTEAMBOID, hasPermOrgTeamBoId);
            }
            Set<String> existNumbersDb = this.getExistNumbersDb(datas);
            for (ImportBillData importBillData : datas) {
                JSONObject parentOrg;
                JSONObject jsonObject = importBillData.getData().getJSONObject(importBillData.getMainEntityId());
                if (jsonObject == null || (parentOrg = jsonObject.getJSONObject("parent")) == null) continue;
                jsonObject.put("boid", (Object)hasPermOrgTeamBoId);
                String parentNumber = parentOrg.getString("number");
                if (existNumbersDb != null && existNumbersDb.contains(parentNumber)) continue;
                parentOrg.put("number", (Object)hasPermOrgNumber);
                Map replaceOrgMap = (Map)customParams.computeIfAbsent(REPLACEORG_MAP, val -> new HashMap(2));
                replaceOrgMap.put(jsonObject.getString("number"), parentNumber);
            }
        }
    }

    private Set<String> getExistNumbersDb(List<ImportBillData> datas) {
        Set parentNumbers = datas.stream().filter(val -> val.getData().getJSONObject(val.getMainEntityId()) != null).filter(val -> val.getData().getJSONObject(val.getMainEntityId()).getJSONObject("parent") != null).map(val -> val.getData().getJSONObject(val.getMainEntityId()).getJSONObject("parent").getString("number")).collect(Collectors.toSet());
        if (!parentNumbers.isEmpty()) {
            QFilter qFilter = new QFilter("number", "in", parentNumbers);
            DynamicObject[] orgDys = CUS_ADMINORGTEAM.loadDynamicObjectArray(new QFilter[]{qFilter, QFilterHelper.createHisCurrentDataFilter(), QFilterHelper.createInitFinishedFilter()});
            if (orgDys != null) {
                return Arrays.stream(orgDys).map(val -> val.getString("number")).collect(Collectors.toSet());
            }
        }
        return null;
    }

    private AuthorizedOrgTeamResult getPermOrgResult(String permEntityNumber) {
        Long userId = RequestContext.get().getCurrUserId();
        String appId = "homs";
        String propKey = "boid";
        return (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{userId, appId, permEntityNumber, "47150e89000000ac", propKey});
    }

    private DynamicObject getHasPermOrgTeam(String permEntityNumber, Long structProjectId) {
        List hasPermOrgIds;
        AuthorizedOrgTeamResult authorizedOrgResult = this.getPermOrgResult(permEntityNumber);
        if (authorizedOrgResult.isHasAllOrgPerm()) {
            return this.getRootOrgTeam(structProjectId);
        }
        Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
        if (hasPermOrgTeamMap != null && !hasPermOrgTeamMap.isEmpty() && !CollectionUtils.isEmpty((Collection)(hasPermOrgIds = (List)hasPermOrgTeamMap.get(structProjectId)))) {
            for (Long orgId : hasPermOrgIds) {
                if (orgId <= 0L) continue;
                return CUS_ADMINORGTEAM.queryOne((Object)orgId);
            }
        }
        return null;
    }

    private DynamicObject getRootOrgTeam(Long structProjectId) {
        QFilter qFilter = new QFilter("structproject", "=", (Object)structProjectId).and("isroot", "=", (Object)Boolean.TRUE).and(QFilterHelper.createValidHisCurrentDataFilter());
        DynamicObject rootOrgTeamStruct = OT_STRUCT.queryOne("orgteam", new QFilter[]{qFilter});
        if (rootOrgTeamStruct != null) {
            return rootOrgTeamStruct.getDynamicObject("orgteam");
        }
        LOGGER.error("getRootOrgNumber is null");
        return null;
    }

    public void afterConvertDynamicObjects(AfterConvertDynamicObjectsEventArgs args) {
        Map<Object, ImportBillData> map = CustomeImportUtil.initIdAndbillDataMap(args.getImportBillDatas());
        HashMap newMap = new HashMap();
        HashMap<String, List> tempMap = new HashMap<String, List>();
        Map dynamicObjects = args.getDynamicObjects();
        DynamicObject structProjectDy = null;
        Map<String, Object> extParamsMap = CustomeImportUtil.convertExtParamsMap(args.getExtParams());
        Object structProjectId = extParamsMap.get("structproject");
        if (structProjectId != null) {
            structProjectDy = STRUCT_PROJECT.queryOne(structProjectId);
        }
        String numberPrex = (extParamsMap.get("numberprefix") + "_").toUpperCase(Locale.ROOT);
        ConcurrentHashMap customParams = args.getCustomParams();
        for (Map.Entry entry : dynamicObjects.entrySet()) {
            DynamicObject[] dys = (DynamicObject[])entry.getValue();
            Map<String, DynamicObject> numberMap = null;
            Map replaceOrgMap = null;
            if ("new".equals(args.getContext().getImporttype())) {
                if (customParams != null && customParams.get(REPLACEORG_MAP) != null) {
                    replaceOrgMap = (Map)customParams.get(REPLACEORG_MAP);
                }
                numberMap = this.getNumberMap(dys, replaceOrgMap);
            }
            for (DynamicObject dy : dys) {
                ImportBillData billData = map.get(dy.getPkValue());
                dy.set("structproject", (Object)structProjectDy);
                dy.set("structproject_id", structProjectId);
                String orgNumber = dy.getString("number");
                if (orgNumber != null && orgNumber.startsWith(numberPrex)) {
                    dy.set("number", (Object)orgNumber.substring(numberPrex.length()));
                }
                if ("new".equalsIgnoreCase(billData.getOpType())) {
                    String orginalParentNumber;
                    if (numberMap != null && replaceOrgMap != null && (orginalParentNumber = (String)replaceOrgMap.get(orgNumber)) != null) {
                        dy.set("parent", (Object)numberMap.get(orginalParentNumber));
                    }
                    List newdys = tempMap.computeIfAbsent("new", val -> new LinkedList());
                    dy.set("boid", (Object)0L);
                    newdys.add(dy);
                    continue;
                }
                if (!"update".equalsIgnoreCase(billData.getOpType())) continue;
                List updatedys = tempMap.computeIfAbsent("update", val -> new LinkedList());
                updatedys.add(dy);
            }
        }
        for (Map.Entry next : tempMap.entrySet()) {
            if (next == null || next.getValue() == null || ((List)next.getValue()).size() <= 0) continue;
            List values = (List)next.getValue();
            newMap.put(next.getKey(), values.toArray(new DynamicObject[values.size()]));
        }
        args.setDynamicObjects(newMap);
    }

    private Map<String, DynamicObject> getNumberMap(DynamicObject[] dys, Map<String, String> replaceOrgMap) {
        Map<String, DynamicObject> numberMap = Arrays.stream(dys).collect(Collectors.toMap(val -> val.getString("number"), val -> val, (oldObj, newObj) -> newObj));
        ArrayList<String> notCurBatchNunbers = new ArrayList<String>(dys.length);
        if (replaceOrgMap != null) {
            for (DynamicObject dy : dys) {
                String orgNumber = dy.getString("number");
                String orginalParentNumber = replaceOrgMap.get(orgNumber);
                if (orginalParentNumber == null || numberMap.get(orginalParentNumber) != null) continue;
                notCurBatchNunbers.add(orginalParentNumber);
            }
        }
        if (!notCurBatchNunbers.isEmpty()) {
            QFilter filter = new QFilter("number", "in", notCurBatchNunbers);
            filter.and(QFilterHelper.createValidHisCurrentDataFilter());
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject[] dyArray = CustomOrgTeamRepository.getRepository().loadDynamicObjectArray(filters);
            if (dyArray != null && dyArray.length > 0) {
                numberMap.putAll(Arrays.stream(dyArray).collect(Collectors.toMap(val -> val.getString("number"), val -> val, (v1, v2) -> v1)));
            }
        }
        return numberMap;
    }

    public void beforeCallOperation(BeforeCallOperationEventArgs args) {
        Map submitOPs = args.getSubmitOPs();
        switch (args.getGroupName()) {
            case "new": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "ot_his_newsave");
                break;
            }
            case "update": {
                submitOPs.put(submitOPs.keySet().stream().findFirst().get(), "donothing_ot_confirm_change");
                break;
            }
        }
    }
}

