/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.orgteam;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamSearchExactMatchDataProvider
extends ListDataProvider {
    public Set<Long> orgTeamTypes = Sets.newHashSet((Object[])new Long[]{1010L, 1020L, 1030L});
    private Set<Object> searchFields;
    private Set<Object> searchValues;
    private static final String PREFIX = "_";

    public OrgTeamSearchExactMatchDataProvider(Set<Object> searchFields, Set<Object> searchValues) {
        this.searchFields = searchFields;
        this.searchValues = searchValues;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        List qFilters = this.getQFilters();
        List searchFilter = qFilters.stream().filter(qFilter -> HRStringUtils.equalsIgnoreCase((String)"ftlike", (String)qFilter.getCP())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(searchFilter) || this.searchValues == null) {
            return new DynamicObjectCollection(super.getData(start, 1).getDynamicObjectType(), null);
        }
        ArrayList filters = Lists.newArrayListWithCapacity((int)4);
        HashSet prefixSets = Sets.newHashSetWithExpectedSize((int)this.orgTeamTypes.size());
        this.orgTeamTypes.forEach(type -> prefixSets.add(OrgTeamSynService.getOrgTeamNumberPrefix((Long)type) + PREFIX));
        this.searchValues.forEach(value -> {
            QFilter filter = null;
            for (Object searchField : this.searchFields) {
                if ("name".equals(searchField)) {
                    if (filter == null) {
                        filter = new QFilter(String.valueOf(searchField), "=", value);
                        continue;
                    }
                    filter.or(new QFilter(String.valueOf(searchField), "=", value));
                    continue;
                }
                if (filter == null) {
                    for (String prefix : prefixSets) {
                        if (filter == null) {
                            filter = new QFilter(String.valueOf(searchField), "=", (Object)(prefix + value));
                            continue;
                        }
                        filter.or(new QFilter(String.valueOf(searchField), "=", (Object)(prefix + value)));
                    }
                    continue;
                }
                for (String prefix : prefixSets) {
                    filter.or(new QFilter(String.valueOf(searchField), "=", (Object)(prefix + value)));
                }
            }
            filters.add(filter);
        });
        QFilter hisQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        filters.add(hisQFilter);
        filters.add(new QFilter("otclassify.id", "in", this.orgTeamTypes));
        filters.add(new QFilter("enable", "=", (Object)"1"));
        QFilter basicFilter = new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        filters.add(basicFilter);
        this.setQFilters(filters);
        DynamicObjectCollection rows = super.getData(start, limit);
        for (DynamicObject row : rows) {
            String number = OrgTeamSearchExactMatchDataProvider.removePrefix(row.getString("number"));
            row.set("number", (Object)number);
        }
        return rows;
    }

    private static String removePrefix(String number) {
        if (HRStringUtils.isEmpty((String)number)) {
            return number;
        }
        if (number.contains(PREFIX)) {
            number = number.substring(number.indexOf(PREFIX) + 1);
        }
        return number;
    }
}

