/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.orgteam;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.template.OrgTeamTreeListTemplate;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.commons.lang.StringUtils;

public class OrgTeamTreeListBase
extends OrgTeamTreeListTemplate {
    public OrgTeamTreeListBase(OrgTreeModel orgTreeModel) {
        super(orgTreeModel);
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent buildTreeListFilterEvent) {
        String nodeId = (String)buildTreeListFilterEvent.getNodeId();
        if (StringUtils.isBlank((String)nodeId)) {
            return null;
        }
        QFilter hasVirtualNodeFilter = this.buildHasVirtualNodeFilter(nodeId);
        if (hasVirtualNodeFilter != null) {
            return hasVirtualNodeFilter;
        }
        return this.buildNormalNodeFilter(nodeId);
    }

    private QFilter buildNormalNodeFilter(String nodeId) {
        QFilter filter;
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)nodeId);
        if (null == treeNode) {
            return null;
        }
        long currentBoId = Long.parseLong((String)treeNode.getData());
        QFilter adminOrgFilter = null;
        QFilter adminBoIdFilter = null;
        ArrayList permOrgIds = null;
        if (this.orgTreeModel.isFilterTreePerm() && !this.isHasAllOrgPerm()) {
            Set permOrgTeamIdResult = this.getPermOrgTeamIdResult();
            permOrgIds = new ArrayList(permOrgTeamIdResult);
            adminOrgFilter = new QFilter("orgteam", "in", (Object)permOrgTeamIdResult);
            adminBoIdFilter = new QFilter("boid", "in", permOrgIds);
        }
        String currentStructLongNumber = treeNode.getLongNumber();
        if (this.isInCludeChild()) {
            QFilter parentStructFilter = new QFilter("structlongnumber", "like", (Object)(currentStructLongNumber + "%"));
            DynamicObjectCollection dynamicObjects = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("orgteam", new QFilter[]{parentStructFilter, adminOrgFilter, this.getOrgEnableFilter(), this.getDataStatusAndBSedFilter()}, null);
            Set adminOrgIds = dynamicObjects.stream().map(adminOrg -> adminOrg.getLong("orgteam")).collect(Collectors.toSet());
            filter = new QFilter("boid", "in", adminOrgIds);
        } else {
            filter = this.getStructNumberFilter(currentStructLongNumber, permOrgIds != null && permOrgIds.contains(currentBoId));
            filter.and(adminBoIdFilter);
        }
        return filter;
    }

    private QFilter buildHasVirtualNodeFilter(String nodeId) {
        if (HRStringUtils.equals((String)"-1", (String)nodeId)) {
            return new QFilter("id", "=", (Object)-1);
        }
        String doNotHaveParentOrgStructLongNumberStr = this.getPageCache().get("do_not_have_parent_org_structlongnumber");
        if (doNotHaveParentOrgStructLongNumberStr != null) {
            if (this.isInCludeChild()) {
                String rootId = this.getTreeModel().getRoot().getId();
                if (rootId.equals(nodeId)) {
                    String conditionalOrgIdStr = this.getPageCache().get("all_conditional_org");
                    if (conditionalOrgIdStr == null) {
                        return new QFilter("id", "=", (Object)-1);
                    }
                    List conditionalOrgIds = (List)SerializationUtils.fromJsonString((String)conditionalOrgIdStr, List.class);
                    return new QFilter("boid", "in", (Object)conditionalOrgIds);
                }
                if (HRStringUtils.equals((String)"-1", (String)nodeId) || HRStringUtils.equals((String)"999999999", (String)nodeId)) {
                    DynamicObject[] dynObjArr = this.queryConditionalOrgAtSearchDate();
                    Set noParentStructLongNumberSet = Arrays.stream(dynObjArr).filter(dynObj -> dynObj.getLong("parent") == 0L).map(dynObj -> dynObj.getString("structlongnumber")).collect(Collectors.toSet());
                    PatriciaTrie patriciaTrieDynObjColl = Arrays.stream(dynObjArr).collect(Collectors.toMap(dyn -> dyn.getString("structlongnumber"), dyn -> dyn, (value, value2) -> value, PatriciaTrie::new));
                    HashSet adminOrgIdSet = new HashSet(dynObjArr.length);
                    for (String noParentStructLongNumber : noParentStructLongNumberSet) {
                        SortedMap sortedMap = patriciaTrieDynObjColl.prefixMap((Object)noParentStructLongNumber);
                        if (sortedMap.isEmpty()) continue;
                        adminOrgIdSet.addAll(sortedMap.values().stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet()));
                    }
                    return new QFilter("boid", "in", adminOrgIdSet);
                }
            } else {
                Set doNotHaveParentOrgStructLongNumber = (Set)SerializationUtils.fromJsonString((String)doNotHaveParentOrgStructLongNumberStr, Set.class);
                return new QFilter("structnumber", "in", (Object)doNotHaveParentOrgStructLongNumber);
            }
        }
        return null;
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.getQFilters().add(this.getOrgEnableFilter());
        setFilterEvent.getQFilters().add(this.getDataStatusAndBSedFilter());
        setFilterEvent.getQFilters().add(new QFilter("teamtype.id", "=", (Object)1010));
    }

    public Long getCurNodeIdByRowClick(ListRowClickEvent evt) {
        return Long.valueOf(evt.getCurrentListSelectedRow().getPrimaryKeyValue().toString());
    }

    private QFilter getStructNumberFilter(String parentStructLongNumber, boolean includeOwn) {
        if (!this.orgTreeModel.isFilterTreePerm() || this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            List allPermissionStructLongNumbers = this.getAllPermissionStructLongNumbers();
            List subStructNumbers = OrgTreeUtils.getSubStructNumbers((String)parentStructLongNumber, (List)allPermissionStructLongNumbers, (boolean)true);
            return new QFilter("structnumber", "in", (Object)subStructNumbers);
        }
        List structLongNumbers = TreeTemplateHelper.getPermissionStructLongNumbersWithSub((AuthorizedOrgResultWithSub)this.permOrgResultWithSub, (String)this.getEntityName(), (QFilter)this.getOrgTreeFilter(), (String)"orgteam.boid", null);
        List subStructNumbers = OrgTreeUtils.getSubStructNumbers((String)parentStructLongNumber, (List)structLongNumbers, (boolean)includeOwn);
        return new QFilter("structnumber", "in", (Object)subStructNumbers);
    }

    protected QFilter getCurTreeBizQFilter() {
        String qFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("bizQFilterKey");
        if (!HRStringUtils.isEmpty((String)qFilterStr)) {
            QFilter curTreeBizQFilter = QFilter.fromSerializedString((String)qFilterStr);
            return curTreeBizQFilter.and(new QFilter("orgteam.teamtype.id", "=", (Object)1010));
        }
        return new QFilter("orgteam.teamtype.id", "=", (Object)1010);
    }
}

