/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.form;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ProjectGroupDisableEdit
extends HRDataBaseEdit
implements ProjectGroupMDConstants {
    private static final String CONFIRM_DISABLE = "confirm_disable";
    private static final Log log = LogFactory.getLog(ProjectGroupDisableEdit.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue("changetype", (Object)CHANGETYPE_DISABLE_ID);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("startdate".equals(name)) {
            this.getModel().setDataChanged(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        List selectIds = (List)customParam.get("selectIds");
        if ("donothing".equals(operateKey)) {
            this.getModel().setValue("startdate", this.getModel().getValue("bsed"));
            this.disableProTeam(formOperate, selectIds);
        } else if ("disable_donothing".equals(operateKey)) {
            this.getModel().setValue("selectIds", (Object)selectIds.stream().map(Objects::toString).collect(Collectors.joining(",")));
            this.getModel().setDataChanged(false);
        }
    }

    private void disableProTeam(FormOperate formOperate, List<Long> selectIds) {
        Date date = this.getModel().getDataEntity().getDate("bsed");
        date = date == null ? new Date() : date;
        OperateOption operateOption = formOperate.getOption();
        operateOption.setVariableValue("bsed", String.valueOf(date.getTime()));
        long changeReasonId = this.getModel().getDataEntity().getLong("changereason.id");
        operateOption.setVariableValue("changereason", String.valueOf(changeReasonId));
        operateOption.setVariableValue("changeoperate", "1030");
        OperationResult operationResult = this.getView().getParentView().invokeOperation("disable_donothing", operateOption);
        FormShowParameter showParameter = this.getView().getParentView().getFormShowParameter();
        showParameter.setCustomParam("selectIds", selectIds);
        showParameter.setCustomParam("effectDate", (Object)date);
        if (operationResult.isSuccess()) {
            this.getView().close();
        } else if (!ObjectUtils.isEmpty((Object)operationResult.getSuccessPkIds())) {
            this.getView().showOperationResult(operationResult);
            this.getView().close();
        } else if (!operationResult.isSuccess() && operationResult.getInteractionContext() != null) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_DISABLE, (IFormPlugin)this);
            this.getView().showConfirm(operationResult.getInteractionContext().getSimpleMessage(), MessageBoxOptions.OKCancel, listener);
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void disable() {
        DynamicObject params = this.getModel().getDataEntity();
        if (null == params) {
            return;
        }
        FormShowParameter showParameter = this.getView().getParentView().getFormShowParameter();
        Map customParam = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParam) {
            log.info("ProjectGroupDisableEdit-confirm-can-not-get-customParam");
            return;
        }
        List selectIds = (List)customParam.get("selectIds");
        log.info(MessageFormat.format("ProjectGroupDisableEdit-confirm-selectId-{0}", selectIds));
        List projectList = ProjectGroupServiceHelper.getAllProjectList((List)selectIds, (DynamicObject)params);
        DynamicObject[] projectRoles = ProjectGroupServiceHelper.queryProjectRoleByProjectTeam((DynamicObject[])projectList.toArray(new DynamicObject[0]));
        String msg = String.format(ResManager.loadKDString((String)"\u7981\u7528\u9009\u4e2d\u7684\u9879\u76ee\u56e2\u961f\uff0c\u4e1a\u52a1\u72b6\u6001\u53d8\u4e3a\u201c\u5df2\u7981\u7528\u201d\uff1b\u540c\u65f6\u7981\u7528\u4e0b\u7ea7\u9879\u76ee\u56e2\u961f\uff08\u7981\u7528\u4e2a\u6570\uff1a%1$s\uff09\u548c\u9879\u76ee\u89d2\u8272\uff08\u7981\u7528\u4e2a\u6570\uff1a%2$s\uff09\u3002", (String)"ProjectGroupDisableEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), projectList.size() - selectIds.size(), projectRoles.length);
        ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_DISABLE, (IFormPlugin)this);
        showParameter.setCustomParam("selectIds", (Object)selectIds);
        showParameter.setCustomParam("effectDate", (Object)((DynamicObject)projectList.get(0)).getDate("bsed"));
        this.getView().getParentView().cacheFormShowParameter();
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, listener);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key = evt.getCallBackId();
        if (CONFIRM_DISABLE.equals(key) && "Yes".equals(evt.getResultValue())) {
            this.getModel().setDataChanged(false);
            HashMap callbackMap = Maps.newHashMap();
            callbackMap.put("bsed", this.getModel().getDataEntity().getDate("bsed").getTime());
            callbackMap.put("changescene", this.getModel().getDataEntity().getLong("changescene.id"));
            callbackMap.put("changereason", this.getModel().getDataEntity().getLong("changereason.id"));
            callbackMap.put("changeoperate", this.getModel().getDataEntity().getLong("changeoperate.id"));
            this.getView().returnDataToParent((Object)callbackMap);
            this.getView().close();
        }
    }

    private void getCountByProjectId() {
        ArrayList<Long> projectGroupIds = new ArrayList<Long>();
        projectGroupIds.add(1479596547707517952L);
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(2022, 7, 26);
        Date roleDate = calendar.getTime();
        List result = (List)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"getCountByProjectId", (Object[])new Object[]{projectGroupIds, roleDate});
        System.out.println(result);
    }
}

