/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ProjectGroupMDEdit
extends HRDataBaseEdit
implements BeforeF7SelectListener,
AfterF7SelectListener,
ProjectGroupMDConstants {
    private static final List<String> REGISTER_BEFORE_F7_LISTENER = new ArrayList<String>();
    private static final List<String> REGISTER_AFTER_F7_LISTENER = new ArrayList<String>();
    private static final List<String> NEED_GET_FROM_PAREN = new ArrayList<String>();

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        REGISTER_BEFORE_F7_LISTENER.forEach(propertyName -> {
            Control control = this.getView().getControl(propertyName);
            if (control instanceof BasedataEdit) {
                ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
        REGISTER_AFTER_F7_LISTENER.forEach(propertyName -> {
            Control control = this.getView().getControl(propertyName);
            if (control instanceof BasedataEdit) {
                ((BasedataEdit)control).addAfterF7SelectListener((AfterF7SelectListener)this);
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs event) {
        String operationKey = event.getProperty().getName();
        if (HRStringUtils.equals((String)operationKey, (String)"parentorg")) {
            this.parentOrgCasCode(operationKey);
        } else if (HRStringUtils.equals((String)"parentprojectteam", (String)operationKey)) {
            this.getModel().setValue("parentorg", this.getModel().getValue("parentprojectteam"));
        } else if ("index".equals(operationKey)) {
            Integer newIdx = (Integer)event.getChangeSet()[0].getNewValue();
            if (newIdx != null && (newIdx < 1 || newIdx > IDX_MAX)) {
                this.getModel().setValue("index", (Object)IDX_MAX);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u51651-99999\u7684\u6574\u6570\u3002", (String)"ProjectGroupAddEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            }
        } else if ("changescene".equals(operationKey)) {
            DynamicObject newValue = (DynamicObject)event.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                HRBaseServiceHelper projChangeScene = new HRBaseServiceHelper("haos_projchangescene");
                DynamicObject originalOne = projChangeScene.queryOriginalOne("changeoperate", newValue.get("id"));
                this.getModel().setValue("changeoperate", originalOne.get("changeoperate"));
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"changereason"});
            } else {
                this.getModel().setValue("changescene", null);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"changereason"});
            }
            this.getModel().setValue("changereason", null);
        }
    }

    private void parentOrgCasCode(String operationKey) {
        IDataModel model = this.getModel();
        DynamicObject parentOrg = (DynamicObject)model.getValue(operationKey);
        if (parentOrg == null) {
            return;
        }
        long otClassifyId = parentOrg.getLong("otclassify.id");
        if (otClassifyId == 1020L) {
            long parentOrgId = parentOrg.getLong("id");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
            DynamicObject parentProjectGroupDyn = serviceHelper.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)parentOrgId)});
            NEED_GET_FROM_PAREN.forEach(field -> model.setValue(field, parentProjectGroupDyn.get(field)));
            this.getView().setEnable(Boolean.FALSE, new String[]{"project"});
        } else if (otClassifyId == 1010L) {
            model.setValue("project", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"project"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if ("addNew".equals(this.getView().getFormShowParameter().getCustomParam("operate_type"))) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String currentNodeId = (String)formShowParameter.getCustomParam("currentNodeId");
            this.getModel().setValue("parentorg", (Object)currentNodeId);
            this.getModel().setValue("org", (Object)((DynamicObject)this.getModel().getValue("parentorg")).getDynamicObject("org"));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        if (Objects.isNull(this.getModel().getValue("parentorg"))) {
            this.getModel().setValue("project", null);
        } else {
            DynamicObject parentOrg = (DynamicObject)this.getModel().getValue("parentorg");
            long otClassifyId = parentOrg.getLong("otclassify.id");
            if (otClassifyId == 1010L) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"project"});
            }
        }
        if (!((BillShowParameter)this.getView().getFormShowParameter()).getBillStatus().equals((Object)BillOperationStatus.AUDIT)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelrightcontainer"});
        }
        if (this.getModel().getValue("changescene") == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"changereason"});
        }
        this.getModel().setValue("bsed", (Object)new Date());
        this.getModel().setValue("startdate", (Object)new Date());
        Object orgObj = this.getModel().getValue("org");
        if (orgObj == null) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
        this.setChangeScene();
        this.setChangeOperate();
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        if (!StringUtils.equals((CharSequence)this.getView().getEntityId(), (CharSequence)"haos_projectgroupchange")) {
            BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
            Object pkId = billShowParameter.getPkId();
            if (MutexHelper.isOpenIntentLocks()) {
                StringBuilder errMsg = new StringBuilder();
                this.requestIntentLock(pkId, errMsg);
            } else {
                StringBuilder errMsg = new StringBuilder();
                boolean isStrict = !billShowParameter.isEnableUserReentrant();
                MainEntityType dataEntityType = this.getModel().getDataEntityType();
                String billNo = this.getModel().getDataEntity().getString(((BillEntityType)dataEntityType).getBillNo());
                MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkId), billNo, (String)null, "haos_projectgroupchange", "modify", isStrict, "default");
                boolean isSuccess = MutexHelper.require((MutexLockInfo)lockInfo, (StringBuilder)errMsg);
                if (!isSuccess) {
                    billShowParameter.setStatus(OperationStatus.VIEW);
                    this.getView().showTipNotification(errMsg.toString());
                } else {
                    this.setPageCacheMutexInfo();
                }
            }
        }
    }

    private boolean requestIntentLock(Object pkId, StringBuilder errMsg) {
        boolean isSuccess = true;
        String entityId = this.getView().getEntityId();
        if (StringUtils.isNotBlank((CharSequence)entityId) && StringUtils.isNotBlank((Object)pkId)) {
            String intentKey = MutexHelper.requireIntent((IFormView)this.getView(), (String)entityId, (Object)String.valueOf(pkId), (StringBuilder)errMsg);
            if (StringUtils.isBlank((CharSequence)intentKey)) {
                return false;
            }
        } else {
            errMsg.append("apply for intent lock fail");
            isSuccess = false;
        }
        return isSuccess;
    }

    private void setChangeScene() {
        QFilter buFilter;
        long changeTypeID;
        QFilter changeTyeFilter;
        QFilter enableFilter;
        QFilter statusFilter;
        HRBaseServiceHelper serviceHelper;
        DynamicObject[] changeSceneDyns;
        List changeLists;
        IDataModel model = this.getModel();
        if (model.getValue("org") == null) {
            return;
        }
        DynamicObject changeSence = model.getDataEntity().getDynamicObject("changescene");
        if (changeSence == null && (changeLists = Arrays.stream(changeSceneDyns = (serviceHelper = new HRBaseServiceHelper("haos_projchangescene")).loadDynamicObjectArray(new QFilter[]{statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1')), changeTyeFilter = new QFilter("changetype", "=", (Object)(changeTypeID = model.getDataEntity().getLong("changetype.id"))), buFilter = BaseDataHelper.getBaseDataFilter((String)"haos_projchangescene", (long)((DynamicObject)model.getValue("org")).getLong("id"))})).collect(Collectors.toList())) != null && changeLists.size() == 1) {
            model.setValue("changescene", changeLists.get(0));
        }
    }

    public void setChangeOperate() {
        Object operateType = this.getView().getFormShowParameter().getCustomParam("operate_type");
        if ("coopreltype".equals(operateType.toString())) {
            this.getModel().setValue("changeoperate", (Object)1050L);
        } else if ("changeparent".equals(operateType.toString())) {
            this.getModel().setValue("changeoperate", (Object)1020L);
        } else if ("changeinfo".equals(operateType.toString())) {
            this.getModel().setValue("changeoperate", (Object)1030L);
        } else if ("donothing_disable".equals(operateType.toString())) {
            this.getModel().setValue("changeoperate", (Object)1040L);
        } else if ("addNew".equals(operateType.toString())) {
            this.getModel().setValue("changeoperate", (Object)1010L);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        Set exclude = Stream.of("donothing_save_rel", "donothing", "disable_donothing", "newentry", "deleteentry").collect(Collectors.toSet());
        if (!exclude.contains(operateKey)) {
            this.getModel().setValue("bsed", this.getModel().getValue("startdate"));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && ("donothing_save".equals(operateKey) || "donothing_saveandnew".equals(operateKey) || "donothing_confirmchangeparent".equals(operateKey) || "donothing_confirmchangeinfo".equals(operateKey))) {
            this.closeCurrentPageAfterSave(afterDoOperationEventArgs, operateKey);
            this.saveAttachment(this.getBoId(operateKey));
        }
    }

    private void saveAttachment(Object pkId) {
        IPageCache cache = (IPageCache)this.getView().getService(IPageCache.class);
        String cacheJsonString = cache.get("TampAttCache" + this.getView().getPageId());
        HRBaseServiceHelper attachmentHelper = new HRBaseServiceHelper("bos_attachment");
        DynamicObject[] oldAttachmentArr = this.getAttachmentByPkId(pkId, attachmentHelper, "haos_projectgroupchange", false);
        if (!StringUtils.isEmpty((CharSequence)cacheJsonString)) {
            String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
            Map attachmentInfo = (Map)SerializationUtils.fromJsonString((String)cacheJsonString, Map.class);
            AttachmentServiceHelper.saveTempAttachments((String)"haos_projectgroupchange", (Object)pkId, (String)appId, (Map)attachmentInfo);
        }
        Set<String> oldAttachmentNUmber = Arrays.stream(oldAttachmentArr).map(attachment -> attachment.getString("fnumber")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjectBaseArr = this.getAttachmentByPkId(pkId, attachmentHelper, "haos_projectgroupchange", true);
        DynamicObject[] attachmentChangeArr = this.getAttachmentByPkId(pkId, attachmentHelper, "haos_projteambaseinfo", true);
        Map<String, DynamicObject> attachmentChangeMap = Arrays.stream(attachmentChangeArr).collect(Collectors.toMap(attachment -> attachment.getString("fnumber"), attachment -> attachment));
        this.newAndUpdateAttachment(pkId, attachmentHelper, oldAttachmentNUmber, dynamicObjectBaseArr, attachmentChangeMap);
        this.deleteAttachment(attachmentHelper, oldAttachmentNUmber, attachmentChangeMap);
    }

    private Object getBoId(String operateKey) {
        if ("donothing_save".equals(operateKey) || "donothing_saveandnew".equals(operateKey)) {
            return this.getModel().getDataEntity().getPkValue();
        }
        if ("donothing_confirmchangeparent".equals(operateKey) || "donothing_confirmchangeinfo".equals(operateKey)) {
            return this.getModel().getDataEntity().getLong("boid");
        }
        throw new RuntimeException(String.format("operatekey no valid: %s", operateKey));
    }

    private void newAndUpdateAttachment(Object pkId, HRBaseServiceHelper attachmentHelper, Set<String> oldAttachmentNUmber, DynamicObject[] dynamicObjectBaseArr, Map<String, DynamicObject> attachmentChangeMap) {
        ArrayList newAttachmentList = Lists.newArrayListWithExpectedSize((int)dynamicObjectBaseArr.length);
        ArrayList updateAttachmentList = Lists.newArrayListWithExpectedSize((int)dynamicObjectBaseArr.length);
        long[] ids = ORM.create().genLongIds("bos_attachment", dynamicObjectBaseArr.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjectBaseArr) {
            String number = dynamicObject.getString("fnumber");
            if (!oldAttachmentNUmber.contains(number)) {
                DynamicObject emptyDynamicObject = attachmentHelper.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)emptyDynamicObject);
                emptyDynamicObject.set("id", (Object)ids[index++]);
                emptyDynamicObject.set("finterid", (Object)pkId.toString());
                emptyDynamicObject.set("fbilltype", (Object)"haos_projteambaseinfo");
                emptyDynamicObject.set("fcreatetime", (Object)new Date());
                newAttachmentList.add(emptyDynamicObject);
                continue;
            }
            DynamicObject attachmentChange = attachmentChangeMap.get(number);
            this.getAttachCopyKeys().forEach(propertyName -> attachmentChange.set(propertyName, dynamicObject.get(propertyName)));
            updateAttachmentList.add(attachmentChange);
        }
        if (!CollectionUtils.isEmpty((Collection)newAttachmentList)) {
            attachmentHelper.save(newAttachmentList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)updateAttachmentList)) {
            attachmentHelper.update(updateAttachmentList.toArray(new DynamicObject[0]));
        }
    }

    private void deleteAttachment(HRBaseServiceHelper attachmentHelper, Set<String> oldAttachmentNUmber, Map<String, DynamicObject> attachmentChangeMap) {
        HashSet<String> attachmentKeySet = new HashSet<String>(attachmentChangeMap.keySet());
        attachmentKeySet.removeAll(oldAttachmentNUmber);
        if (!CollectionUtils.isEmpty(attachmentKeySet)) {
            HashSet deleteIds = Sets.newHashSetWithExpectedSize((int)attachmentKeySet.size());
            attachmentKeySet.forEach(number -> {
                DynamicObject deleteAttachment = (DynamicObject)attachmentChangeMap.get(number);
                if (deleteAttachment != null) {
                    deleteIds.add(deleteAttachment.getLong("id"));
                }
            });
            QFilter filter = new QFilter("id", "in", (Object)deleteIds);
            attachmentHelper.deleteByFilter(new QFilter[]{filter});
        }
    }

    private DynamicObject[] getAttachmentByPkId(Object pkId, HRBaseServiceHelper attachmentHelper, String billType, boolean isLoad) {
        QFilter filter = new QFilter("fbilltype", "=", (Object)billType);
        filter.and("finterid", "=", (Object)pkId.toString());
        if (isLoad) {
            return attachmentHelper.loadDynamicObjectArray(new QFilter[]{filter});
        }
        return attachmentHelper.queryOriginalArray("id, fnumber", new QFilter[]{filter});
    }

    private Set<String> getAttachCopyKeys() {
        HashSet<String> set = new HashSet<String>(4);
        set.add("fattachmentname");
        set.add("fcreatetime");
        set.add("fmodifymen");
        set.add("faliasfilename");
        set.add("fmodifytime");
        set.add("fattachmentdes");
        set.add("fdescription");
        return set;
    }

    private void closeCurrentPageAfterSave(AfterDoOperationEventArgs afterDoOperationEventArgs, String operateKey) {
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            this.getModel().setDataChanged(false);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexcooprelap", "operationcolumnap"});
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                ITreeListView treeListView = ((IListView)parentView).getTreeListView();
                ITreeModel treeModel = treeListView.getTreeModel();
                TreeView treeView = treeListView.getTreeView();
                String rootId = treeListView.getTreeModel().getRoot().getId();
                String currentNodeId = (String)treeModel.getCurrentNodeId();
                if (!HRStringUtils.isEmpty((String)rootId) && !HRStringUtils.isEmpty((String)currentNodeId)) {
                    TreeNode treeNode;
                    int ORG_TREE_MAX_LEVEL = 20;
                    if ("donothing_confirmchangeparent".equals(operateKey) || "donothing_confirmchangeinfo".equals(operateKey)) {
                        treeModel.setCurrentNodeId((Object)rootId);
                        treeNode = treeListView.getTreeModel().getRoot().getTreeNode(rootId, ORG_TREE_MAX_LEVEL);
                    } else {
                        treeModel.setCurrentNodeId((Object)currentNodeId);
                        treeNode = treeListView.getTreeModel().getRoot().getTreeNode(currentNodeId, ORG_TREE_MAX_LEVEL);
                    }
                    if (treeNode != null) {
                        treeView.updateNode(treeNode);
                        treeView.focusNode(treeNode);
                    }
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("coopreltype".equals(propertyName)) {
            QFilter filter = new QFilter("id", "!=", (Object)1010L);
            DynamicObject adminOrgDyn = (DynamicObject)this.getModel().getValue("belongadminorg");
            QFilter qFilter = ProjectGroupBaseService.getInstance().getOrgTeamTypeFilter(adminOrgDyn, "haos_teamcoopreltype", "orgteamtype.fbasedataid", Long.valueOf(1020L));
            filter.and(qFilter);
            listShowParameter.getListFilterParameter().setFilter(filter);
        } else if ("parentorg".equals(propertyName)) {
            QFilter filter = new QFilter("iscurrentversion", "=", (Object)"1");
            filter.and("teamtype.id", "=", (Object)1010L);
            filter.and("orgtype.id", "in", (Object)new Long[]{1010L, 1020L});
            filter.and("otclassify.id", "in", (Object)new Long[]{1010L, 1020L});
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.setCaption(this.getPropertyDisplayName(propertyName));
        } else if ("city".equals(propertyName)) {
            DynamicObject country = (DynamicObject)this.getModel().getValue("country");
            if (country != null) {
                long countryId = country.getLong("id");
                QFilter listFilter = new QFilter("country", "=", (Object)countryId);
                listShowParameter.getListFilterParameter().setFilter(listFilter);
            }
            listShowParameter.setCaption(this.getPropertyDisplayName(propertyName));
        } else if ("workplace".equals(propertyName)) {
            Object city = this.getModel().getValue("city");
            if (city != null) {
                QFilter filter = new QFilter("city", "=", city);
                listShowParameter.getListFilterParameter().setFilter(filter);
            }
        } else if ("cooporgteam".equals(propertyName)) {
            this.getView().getFormShowParameter().setCustomParam("customHREntityNumber", null);
            String coOpOrgTeam = ResManager.loadKDString((String)"\u534f\u4f5c\u7ec4\u7ec7", (String)"ProjectGroupMDEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            listShowParameter.setCaption(coOpOrgTeam);
            listShowParameter.setFormId("haos_proteamcoopf7");
            listShowParameter.setPermissionItemId("47150e89000000ac");
            QFilter proTeamCoopOrgPermFilter = ProjectGroupBaseService.getInstance().getProTeamCoopOrgPermFilter("homs", "haos_projteambaseinfo", "parentorg");
            beforeF7SelectEvent.getCustomQFilters().add(proTeamCoopOrgPermFilter);
        } else if ("changescene".equals(propertyName)) {
            Long changeType = this.getModel().getDataEntity().getLong("changetype.id");
            QFilter filter = new QFilter("changetype", "=", (Object)changeType);
            listShowParameter.getListFilterParameter().setFilter(filter);
        } else if ("changereason".equals(propertyName)) {
            DynamicObject changeSceneDyn = (DynamicObject)this.getModel().getValue("changescene");
            if (Objects.nonNull(changeSceneDyn)) {
                Set changeReasonSet = changeSceneDyn.getDynamicObjectCollection("changereason").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
                QFilter changeReasonFilter = new QFilter("id", "in", changeReasonSet);
                beforeF7SelectEvent.getCustomQFilters().add(changeReasonFilter);
            } else {
                QFilter changeReasonFilter = new QFilter("id", "in", null);
                beforeF7SelectEvent.getCustomQFilters().add(changeReasonFilter);
            }
        } else if ("parentprojectteam".equals(propertyName)) {
            Long boId = this.getModel().getDataEntity().getLong("boid");
            QFilter filter = new QFilter("boid", "!=", (Object)boId);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRow listSelectedRow;
        Object source = afterF7SelectEvent.getSource();
        IDataModel model = this.getModel();
        if (source instanceof BasedataEdit && "city".equals(((BasedataEdit)source).getFieldKey()) && model.getValue("country") == null && (listSelectedRow = afterF7SelectEvent.getListSelectedRow()) != null) {
            Object cityId = listSelectedRow.getPrimaryKeyValue();
            HRBaseServiceHelper adminDivisionHelper = new HRBaseServiceHelper("bd_admindivision");
            QFilter idFilter = new QFilter("id", "=", cityId);
            DynamicObject cityInfo = adminDivisionHelper.queryOriginalOne("country", idFilter);
            model.setValue("country", cityInfo.get("country"));
        }
    }

    private String getPropertyDisplayName(String propertyName) {
        IDataEntityType dataEntityType = this.getModel().getDataEntity().getDataEntityType();
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        return ((IDataEntityProperty)properties.get((Object)propertyName)).getDisplayName().getLocaleValue();
    }

    private void setPageCacheMutexInfo() {
        this.getPageCache().put("MUTEX_TRANSFER_COMPLETE", "true");
        this.getPageCache().put("MUTEX_OBJ_ID", this.getModel().getDataEntity(true).getPkValue().toString());
        this.getPageCache().put("MUTEX_ENTITY_KEY", "haos_projectgroupchange");
        this.getPageCache().put("MUTEX_OPER_KEY", "modify");
    }

    static {
        REGISTER_BEFORE_F7_LISTENER.add("coopreltype");
        REGISTER_BEFORE_F7_LISTENER.add("parentorg");
        REGISTER_BEFORE_F7_LISTENER.add("project");
        REGISTER_BEFORE_F7_LISTENER.add("city");
        REGISTER_BEFORE_F7_LISTENER.add("cooporgteam");
        REGISTER_BEFORE_F7_LISTENER.add("changescene");
        REGISTER_BEFORE_F7_LISTENER.add("changereason");
        REGISTER_BEFORE_F7_LISTENER.add("parentprojectteam");
        REGISTER_AFTER_F7_LISTENER.add("city");
        NEED_GET_FROM_PAREN.add("project");
        NEED_GET_FROM_PAREN.add("country");
        NEED_GET_FROM_PAREN.add("city");
        NEED_GET_FROM_PAREN.add("workplace");
    }
}

