/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.projectgroup.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.business.util.PrjTeamPermUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;

public class PrjOrgPermHelper {
    public static final QFilter ALL_PERM_FILTER = new QFilter("1", "=", (Object)1);
    private static final String APP_ID = "homs";
    public static final String PERM_ITEM_ID = "47150e89000000ac";
    private static final Log LOG = LogFactory.getLog(PrjOrgPermHelper.class);

    public static AuthorizedOrgResult getAuthorizedAdOrgResult() {
        long userId = RequestContext.get().getCurrUserId();
        return (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{userId, APP_ID, "haos_projteambaseinfo", PERM_ITEM_ID, "boid"});
    }

    public static HasPermOrgResult getOrgPermResult() {
        HasPermOrgResult result = OrgPermHelper.getHRPermOrg((String)"haos_projteambaseinfo");
        LOG.info("PrjOrgPermHelper.getOrgPermResult:{}", (Object)JSONObject.toJSONString((Object)result));
        return result;
    }

    public static QFilter getAdOrgPermFilterWithBU(long orgId) {
        return PrjOrgPermHelper.getPermFilter("belongadminorg", orgId);
    }

    public static QFilter getAdOrgPermFilterWithBU() {
        return PrjOrgPermHelper.getPermFilter("belongadminorg", true);
    }

    public static QFilter getAdOrgPermFilterWithoutBU() {
        return PrjOrgPermHelper.getPermFilter("belongadminorg", false);
    }

    public static QFilter getPrjOrgPermFilterWithBU(long orgId) {
        return PrjOrgPermHelper.getPermFilter("boid", orgId);
    }

    public static QFilter getPrjOrgPermFilterWithBU() {
        return PrjOrgPermHelper.getPermFilter("boid", true);
    }

    public static QFilter getPrjOrgPermFilterWithoutBU() {
        return PrjOrgPermHelper.getPermFilter("boid", false);
    }

    private static QFilter getPermFilter(String field, boolean withBU) {
        QFilter permFilter = ALL_PERM_FILTER.copy();
        Optional.ofNullable(PrjTeamPermUtils.getDataRuleForBdProp((String)field)).ifPresent(arg_0 -> ((QFilter)permFilter).and(arg_0));
        if (withBU) {
            HasPermOrgResult hrPermOrg = PrjOrgPermHelper.getOrgPermResult();
            Optional.of(hrPermOrg).filter(orgPermResult -> !orgPermResult.hasAllOrgPerm()).ifPresent(orgPermResult -> permFilter.and("org", "in", (Object)orgPermResult.getHasPermOrgs()));
        }
        return permFilter;
    }

    private static QFilter getPermFilter(String field, long orgId) {
        QFilter permFilter = ALL_PERM_FILTER.copy();
        Optional.ofNullable(PrjTeamPermUtils.getDataRuleForBdProp((String)field)).ifPresent(arg_0 -> ((QFilter)permFilter).and(arg_0));
        permFilter.and("org", "=", (Object)orgId);
        return permFilter;
    }
}

