/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgParameterConsoleValidatorEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    private static final String STAFF_EFFECT_OCCUPATION = "effectoccupation";
    private static final String STAFF_OCCUPATION_ACTIVITY = "occupationactivity";
    private static final String STAFF_EFFECT_RELEASE = "effectrelease";
    private static final String STAFF_RELEASE_ACTIVITY = "releaseactivity";
    private Map<String, String> mustInputFieldMap = Maps.newHashMapWithExpectedSize((int)16);

    public OrgParameterConsoleValidatorEdit() {
        this.mustInputFieldMap.put(STAFF_OCCUPATION_ACTIVITY, ResManager.loadKDString((String)"\u5360\u7528\u8d77\u59cb\u6d3b\u52a8", (String)"OrgParameterConsoleValidatorEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        this.mustInputFieldMap.put(STAFF_RELEASE_ACTIVITY, ResManager.loadKDString((String)"\u91ca\u653e\u8d77\u59cb\u6d3b\u52a8", (String)"OrgParameterConsoleValidatorEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
    }

    public void initialize() {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObject releaseActivity;
        boolean effectRelease;
        DynamicObject occupationActivity;
        String itemKey = evt.getItemKey();
        if (!HRStringUtils.equals((String)"save", (String)itemKey)) {
            return;
        }
        DynamicObject configDyn = this.getConfigDyn();
        ArrayList mustInputFieldList = Lists.newArrayListWithExpectedSize((int)16);
        boolean effectOccupation = configDyn.getBoolean(STAFF_EFFECT_OCCUPATION);
        if (!effectOccupation && Objects.isNull(occupationActivity = configDyn.getDynamicObject(STAFF_OCCUPATION_ACTIVITY))) {
            mustInputFieldList.add(STAFF_OCCUPATION_ACTIVITY);
        }
        if (!(effectRelease = configDyn.getBoolean(STAFF_EFFECT_RELEASE)) && Objects.isNull(releaseActivity = configDyn.getDynamicObject(STAFF_RELEASE_ACTIVITY))) {
            mustInputFieldList.add(STAFF_RELEASE_ACTIVITY);
        }
        if (!CollectionUtils.isEmpty((Collection)mustInputFieldList)) {
            evt.setCancel(true);
            StringBuilder mustInputFieldSb = new StringBuilder();
            mustInputFieldList.stream().forEach(mustInputField -> mustInputFieldSb.append(this.mustInputFieldMap.get(mustInputField)).append("\u3001"));
            mustInputFieldSb.delete(mustInputFieldSb.length() - 1, mustInputFieldSb.length());
            String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c%s\u201d\u3002", (String)"OrgParameterConsoleValidatorEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), mustInputFieldSb.toString());
            this.getView().showErrorNotification(msg);
        }
    }

    private DynamicObject getConfigDyn() {
        IFormView parameterView = this.getView().getViewNoPlugin(this.getPageCache().get("TabParaSettings_PageId"));
        IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
        return parameterModel.getDataEntity();
    }
}

