/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffAddEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) {
            this.getModel().setValue("id", (Object)ID.genLongId());
            Object org = this.getView().getFormShowParameter().getCustomParam("SELECT_ORG_ID");
            Object orgFromPage = this.getView().getModel().getValue("org");
            if (Objects.isNull(orgFromPage)) {
                this.getModel().beginInit();
                this.getModel().setValue("org", org);
                this.getModel().endInit();
                DynamicObject orgDyn = (DynamicObject)this.getModel().getValue("org");
                Date year = (Date)this.getModel().getValue("year");
                DynamicObject staffRuleConfig = StaffCommonService.getOrgStaffRuleConfig((DynamicObject)orgDyn, (Date)year);
                StaffFormService.create(this.getView(), this.getModel()).staffRuleInit(staffRuleConfig, false);
                this.getModel().setDataChanged(false);
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs args) {
        BaseShowParameter showParameter = (BaseShowParameter)args.getSource();
        if (OperationStatus.ADDNEW.equals((Object)showParameter.getStatus())) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u7f16\u5236\u4fe1\u606f", (String)"OrgStaffAddEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        } else if (OperationStatus.VIEW.equals((Object)showParameter.getStatus())) {
            HRBaseServiceHelper staffHelper = new HRBaseServiceHelper("haos_staff");
            Long pkIdLong = 0L;
            Object pkId = showParameter.getPkId();
            if (pkId instanceof String) {
                pkIdLong = Long.parseLong((String)pkId);
            } else if (showParameter.getPkId() instanceof Long) {
                pkIdLong = (Long)pkId;
            }
            QFilter idFilter = new QFilter("id", "=", (Object)pkIdLong);
            DynamicObject staff = staffHelper.queryOne("id,name,number", new QFilter[]{idFilter});
            showParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u5236\u4fe1\u606f-", (String)"OrgStaffAddEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]).concat(staff.getString("name")));
        }
    }

    public void afterBindData(EventObject event) {
        OperationStatus operateStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)operateStatus)) {
            this.setVisible();
        }
        this.getModel().setDataChanged(false);
    }

    private void setVisible() {
        DynamicObject staffCycle;
        DynamicObjectCollection useOrgInfos = this.getModel().getEntryEntity("bentryentity");
        this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty((Collection)useOrgInfos)), new String[]{"flexnodata1", "flexnodata2"});
        this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)useOrgInfos)), new String[]{"tabap", "bentryentity", "tabpage_position", "tabpage_job", "tabpage_laborreltype"});
        for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
            String dimension = extDim.getString("staffdimension");
            this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)useOrgInfos)), new String[]{"tabpage_" + dimension});
        }
        StaffFormService.create(this.getView()).setDimensionBtnVisible();
        this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)useOrgInfos)), new String[]{"bentryentity", "tabap"});
        if (!CollectionUtils.isEmpty((Collection)useOrgInfos)) {
            DynamicObjectCollection dimensionInfos = ((DynamicObject)useOrgInfos.get(0)).getDynamicObjectCollection("bstaffdimension");
            Set dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            this.getView().setVisible(Boolean.valueOf(CollectionUtils.isEmpty(dimensionIds)), new String[]{"flexnodata2"});
            this.getView().setVisible(Boolean.valueOf(!CollectionUtils.isEmpty(dimensionIds)), new String[]{"tabap"});
        }
        if ((staffCycle = (DynamicObject)this.getModel().getValue("staffcycle")) == null) {
            List yearStaffList = StaffCommonService.getYearStaff(null, (String)"num");
            yearStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            List monthStaffList = StaffCommonService.getMonthStaff(null, (String)"num");
            monthStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
        } else {
            long staffCycleId = staffCycle.getLong("id");
            if (staffCycleId == 1010L) {
                List yearStaffList = StaffCommonService.getYearStaff(null, (String)"num");
                yearStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            } else {
                List monthStaffList = StaffCommonService.getMonthStaff(null, (String)"num");
                monthStaffList.forEach(propertyName -> this.getView().setVisible(Boolean.valueOf(false), new String[]{propertyName}));
            }
        }
    }
}

