/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffEntryCopyEdit
extends HRDataBaseEdit
implements OrgStaffConstants {
    public static final String SOURCE_CYCLE = "sourcecycle";
    public static final String TARGET_CYCLE = "targetcycle";
    public static final String SAME_TIME_COPY = "sametimecopy";
    public static final String BTNOK = "btnok";
    public List<String> months = Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12");
    private Map<String, String> tabNameVsPrefixMap = Maps.newHashMapWithExpectedSize((int)3);
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    private Map<String, String> getTabNameVsPrefixMap() {
        if (this.tabNameVsPrefixMap.size() == 0) {
            this.tabNameVsPrefixMap.put("tabpage_position", "c");
            this.tabNameVsPrefixMap.put("tabpage_job", "d");
            this.tabNameVsPrefixMap.put("tabpage_laborreltype", "e");
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                String dimension = extDim.getString("staffdimension");
                this.tabNameVsPrefixMap.put("tabpage_" + dimension, this.staffExtEntryHelper.getExtDimPrefix(dimension));
            }
        }
        return this.tabNameVsPrefixMap;
    }

    public void beforeBindData(EventObject e) {
        DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
        DynamicObject staffCycleDyn = dataEntity.getDynamicObject("staffcycle");
        long id = staffCycleDyn.getLong("id");
        Date now = new Date();
        Date year = this.getView().getParentView().getModel().getDataEntity().getDate("year");
        LocalDate nowLocalDate = TimeConvertUtil.date2LocalDate((Date)now);
        LocalDate yearLocalDate = TimeConvertUtil.date2LocalDate((Date)year);
        int curYearInt = nowLocalDate.getYear();
        int yearInt = yearLocalDate.getYear();
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        DynamicObject staffDyn = this.getView().getParentView().getModel().getDataEntity();
        String staffEnable = staffDyn.getString("enable");
        long orgId = staffDyn.getLong("org.id");
        Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter((Long)orgId);
        if (curYearInt == yearInt && id == STAFF_CYCLE_MONTH && !HRStringUtils.equals((String)staffEnable, (String)"10") && !enableModify.booleanValue()) {
            int nowOfMonth = nowLocalDate.getMonth().getValue();
            for (String month : this.months) {
                if (Integer.parseInt(month) < nowOfMonth) continue;
                data.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"OrgStaffEntryCopyEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), month)), month));
            }
            ((MulComboEdit)this.getControl(TARGET_CYCLE)).setComboItems(data);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        switch (name) {
            case "sourcecycle": {
                String newValue = (String)changeSet[0].getNewValue();
                ArrayList<ComboItem> data = new ArrayList<ComboItem>();
                DynamicObject dataEntity = this.getView().getParentView().getModel().getDataEntity();
                DynamicObject staffCycleDyn = dataEntity.getDynamicObject("staffcycle");
                long id = staffCycleDyn.getLong("id");
                Date now = new Date();
                Date year = this.getView().getParentView().getModel().getDataEntity().getDate("year");
                LocalDate nowLocalDate = TimeConvertUtil.date2LocalDate((Date)now);
                LocalDate yearLocalDate = TimeConvertUtil.date2LocalDate((Date)year);
                int curYearInt = nowLocalDate.getYear();
                int yearInt = yearLocalDate.getYear();
                DynamicObject staffDyn = this.getView().getParentView().getModel().getDataEntity();
                String staffEnable = staffDyn.getString("enable");
                long orgId = staffDyn.getLong("org.id");
                Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter((Long)orgId);
                if (curYearInt == yearInt && id == STAFF_CYCLE_MONTH && !HRStringUtils.equals((String)staffEnable, (String)"10") && !enableModify.booleanValue()) {
                    int nowOfMonth = nowLocalDate.getMonth().getValue();
                    for (String month : this.months) {
                        if (Integer.parseInt(month) < nowOfMonth) continue;
                        data.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"OrgStaffEntryCopyEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), month)), month));
                    }
                } else {
                    for (String month : this.months) {
                        if (newValue.equals(month)) continue;
                        data.add(new ComboItem(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u6708", (String)"OrgStaffEntryCopyEdit_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), month)), month));
                    }
                }
                ((MulComboEdit)this.getControl(TARGET_CYCLE)).setComboItems(data);
                break;
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnok = (Button)this.getControl(BTNOK);
        btnok.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals(BTNOK)) {
            this.init();
            this.setEntryValueOrShowConfirm();
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private void init() {
        this.removeViewCache();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity();
        String sourceCycle = dataEntity.getString(SOURCE_CYCLE);
        this.getView().getPageCache().put(SOURCE_CYCLE, sourceCycle);
        ArrayList targetCycleList = Lists.newArrayListWithExpectedSize((int)12);
        String targetCycle = dataEntity.getString(TARGET_CYCLE);
        String[] split = targetCycle.split(",");
        targetCycleList.addAll(Arrays.asList(split));
        targetCycleList.remove("");
        this.getView().getPageCache().put(TARGET_CYCLE, SerializationUtils.toJsonString((Object)targetCycleList));
        Boolean sameTimeCopy = dataEntity.getBoolean(SAME_TIME_COPY);
        this.getView().getPageCache().put(SAME_TIME_COPY, sameTimeCopy.toString());
    }

    private void removeViewCache() {
        this.getView().getPageCache().remove(SOURCE_CYCLE);
        this.getView().getPageCache().remove(TARGET_CYCLE);
        this.getView().getPageCache().remove(SAME_TIME_COPY);
    }

    private void setEntryValueOrShowConfirm() {
        String sourceCycle = this.getView().getPageCache().get(SOURCE_CYCLE);
        List targetCycleList = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get(TARGET_CYCLE), String.class);
        Boolean sameTimeCopy = Boolean.valueOf(this.getView().getPageCache().get(SAME_TIME_COPY));
        AtomicReference<Boolean> isHasValue = new AtomicReference<Boolean>(false);
        String entityName = this.getView().getModel().getDataEntityType().getName();
        if (entityName.equals("haos_useorgcyclecopy")) {
            this.isHasValueForUseOrgEntry(targetCycleList, sameTimeCopy, isHasValue);
            if (!isHasValue.get().booleanValue()) {
                this.copyEntryValueForUseOrgEntry(sourceCycle, targetCycleList, sameTimeCopy);
                this.getView().close();
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8986\u76d6\u76ee\u6807\u5468\u671f\u539f\u6709\u7f16\u5236\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u590d\u5236\uff1f", (String)"OrgStaffEntryCopyEdit_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copy_use_org_detail_confirm", (IFormPlugin)this));
            }
        } else {
            this.isHasValueForMulEntry(targetCycleList, sameTimeCopy, isHasValue);
            if (!isHasValue.get().booleanValue()) {
                this.copyEntryValueForMulEntry(sourceCycle, targetCycleList, sameTimeCopy);
                this.getView().close();
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u8986\u76d6\u76ee\u6807\u5468\u671f\u539f\u6709\u7f16\u5236\u6570\u636e\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u590d\u5236\uff1f", (String)"OrgStaffEntryCopyEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("copy_muldimen_detail_confirm", (IFormPlugin)this));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String sourceCycle = this.getView().getPageCache().get(SOURCE_CYCLE);
        List targetCycleList = SerializationUtils.fromJsonStringToList((String)this.getView().getPageCache().get(TARGET_CYCLE), String.class);
        Boolean sameTimeCopy = Boolean.valueOf(this.getView().getPageCache().get(SAME_TIME_COPY));
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("copy_use_org_detail_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.copyEntryValueForUseOrgEntry(sourceCycle, targetCycleList, sameTimeCopy);
            this.getView().close();
        } else if ("copy_muldimen_detail_confirm".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            this.copyEntryValueForMulEntry(sourceCycle, targetCycleList, sameTimeCopy);
            this.getView().close();
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private void isHasValueForUseOrgEntry(List<String> targetCycleList, boolean sameTimeCopy, AtomicReference<Boolean> isHasValue) {
        DynamicObjectCollection useOrgEntryCol = this.getView().getParentView().getModel().getEntryEntity("bentryentity");
        List<Integer> selectRowList = this.getParentViewSelectRowList("bentryentity");
        for (int i = 0; i < useOrgEntryCol.size(); ++i) {
            Object positionEntry2;
            if (!selectRowList.contains(i)) continue;
            DynamicObject useOrgEntryDyn = (DynamicObject)useOrgEntryCol.get(i);
            this.setIsHasValue(targetCycleList, isHasValue, useOrgEntryDyn, "b");
            if (!sameTimeCopy || isHasValue.get().booleanValue()) continue;
            DynamicObjectCollection positionEntryCol = useOrgEntryDyn.getDynamicObjectCollection("centryentity");
            for (Object positionEntry2 : positionEntryCol) {
                this.setIsHasValue(targetCycleList, isHasValue, (DynamicObject)positionEntry2, "c");
            }
            DynamicObjectCollection jobEntryCol = useOrgEntryDyn.getDynamicObjectCollection("dentryentity");
            positionEntry2 = jobEntryCol.iterator();
            while (positionEntry2.hasNext()) {
                DynamicObject jobEntry = (DynamicObject)positionEntry2.next();
                this.setIsHasValue(targetCycleList, isHasValue, jobEntry, "d");
            }
            DynamicObjectCollection labEntryCol = useOrgEntryDyn.getDynamicObjectCollection("eentryentity");
            for (DynamicObject labEntry : labEntryCol) {
                this.setIsHasValue(targetCycleList, isHasValue, labEntry, "e");
            }
            for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                DynamicObjectCollection extEntryCol = useOrgEntryDyn.getDynamicObjectCollection(prefix + "entryentity");
                for (DynamicObject extEntry : extEntryCol) {
                    this.setIsHasValue(targetCycleList, isHasValue, extEntry, prefix);
                }
            }
        }
    }

    private void isHasValueForMulEntry(List<String> targetCycleList, boolean sameTimeCopy, AtomicReference<Boolean> isHasValue) {
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("tabpage_position".equals(currentTab)) {
            this.isHasValueForSubEntry(targetCycleList, isHasValue, this.getParentViewSelectRowList("centryentity"), "centryentity", "c");
        } else if ("tabpage_job".equals(currentTab)) {
            this.isHasValueForSubEntry(targetCycleList, isHasValue, this.getParentViewSelectRowList("dentryentity"), "dentryentity", "d");
        } else if ("tabpage_laborreltype".equals(currentTab)) {
            this.isHasValueForSubEntry(targetCycleList, isHasValue, this.getParentViewSelectRowList("eentryentity"), "eentryentity", "e");
        } else {
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                String dimension = extDim.getString("staffdimension");
                if (!HRStringUtils.equals((String)currentTab, (String)("tabpage_" + dimension))) continue;
                String prefix = this.staffExtEntryHelper.getExtDimPrefix(extDim.getString("staffdimension"));
                this.isHasValueForSubEntry(targetCycleList, isHasValue, this.getParentViewSelectRowList(prefix + "entryentity"), prefix + "entryentity", prefix);
            }
        }
        if (sameTimeCopy && !isHasValue.get().booleanValue()) {
            Long orgTeamId = this.getView().getParentView().getModel().getDataEntity().getLong("orgteam.id");
            DynamicObjectCollection useOrgEntryCol = this.getView().getParentView().getModel().getEntryEntity("bentryentity");
            for (int i = 0; i < useOrgEntryCol.size(); ++i) {
                DynamicObject useOrgEntryDyn = (DynamicObject)useOrgEntryCol.get(i);
                long useOrgId = useOrgEntryDyn.getLong("buseorg.id");
                if (orgTeamId != useOrgId) continue;
                this.setIsHasValue(targetCycleList, isHasValue, useOrgEntryDyn, "b");
            }
        }
    }

    private void isHasValueForSubEntry(List<String> targetCycleList, AtomicReference<Boolean> isHasValue, List<Integer> selectRowList, String subEntryName, String prefix) {
        DynamicObjectCollection positionEntryCol = this.getView().getParentView().getModel().getEntryEntity(subEntryName);
        for (int i = 0; i < positionEntryCol.size(); ++i) {
            if (!selectRowList.contains(i)) continue;
            DynamicObject positionEntry = (DynamicObject)positionEntryCol.get(i);
            this.setIsHasValue(targetCycleList, isHasValue, positionEntry, prefix);
        }
    }

    private void setIsHasValue(List<String> targetCycleList, AtomicReference<Boolean> isHasValue, DynamicObject entryDyn, String prefix) {
        for (String targetCycle : targetCycleList) {
            Object targetCycleValueObject = entryDyn.get(prefix + "monthstaff" + targetCycle);
            if (!Objects.nonNull(targetCycleValueObject)) continue;
            isHasValue.set(true);
        }
    }

    private void copyEntryValueForUseOrgEntry(String sourceCycle, List<String> targetCycleList, Boolean sameTimeCopy) {
        List<Integer> selectRowList = this.getParentViewSelectRowList("bentryentity");
        this.copyEntryValue(sourceCycle, targetCycleList, "bentryentity", "bmonthstaff", selectRowList);
        if (sameTimeCopy.booleanValue()) {
            DynamicObjectCollection useOrgEntryEntityCol = this.getView().getParentView().getModel().getEntryEntity("bentryentity");
            for (int i = 0; i < useOrgEntryEntityCol.size(); ++i) {
                if (!selectRowList.contains(i)) continue;
                DynamicObject useOrgEntryEntity = (DynamicObject)useOrgEntryEntityCol.get(i);
                this.copySubEntryValue(sourceCycle, targetCycleList, i, useOrgEntryEntity, "centryentity", "c");
                this.copySubEntryValue(sourceCycle, targetCycleList, i, useOrgEntryEntity, "dentryentity", "d");
                this.copySubEntryValue(sourceCycle, targetCycleList, i, useOrgEntryEntity, "eentryentity", "e");
                for (String prefix : this.staffExtEntryHelper.getExtDimPrefix()) {
                    this.copySubEntryValue(sourceCycle, targetCycleList, i, useOrgEntryEntity, prefix + "entryentity", prefix);
                }
            }
        }
    }

    private void copyEntryValueForMulEntry(String sourceCycle, List<String> targetCycleList, Boolean sameTimeCopy) {
        Tab tab = (Tab)this.getView().getParentView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String prefix = this.getTabNameVsPrefixMap().get(currentTab);
        List<Integer> selectRowListForMul = this.getParentViewSelectRowList(prefix + "entryentity");
        this.copyEntryValue(sourceCycle, targetCycleList, prefix + "entryentity", prefix + "monthstaff", selectRowListForMul);
        if (sameTimeCopy.booleanValue()) {
            long orgTeamId = this.getView().getParentView().getModel().getDataEntity().getLong("orgteam.id");
            ArrayList selectRowList = Lists.newArrayListWithExpectedSize((int)1);
            DynamicObjectCollection useOrgEntryCol = this.getView().getParentView().getModel().getEntryEntity("bentryentity");
            for (int i = 0; i < useOrgEntryCol.size(); ++i) {
                DynamicObject useOrgEntryDyn = (DynamicObject)useOrgEntryCol.get(i);
                long useOrgId = useOrgEntryDyn.getLong("buseorg.id");
                if (orgTeamId != useOrgId) continue;
                selectRowList.add(i);
                break;
            }
            this.copyEntryValue(sourceCycle, targetCycleList, "bentryentity", "bmonthstaff", selectRowList);
        }
    }

    private void copySubEntryValue(String sourceCycle, List<String> targetCycleList, int rowIndex, DynamicObject useOrgEntryEntity, String entry, String prefix) {
        DynamicObjectCollection subEntityCol = useOrgEntryEntity.getDynamicObjectCollection(entry);
        for (int j = 0; j < subEntityCol.size(); ++j) {
            Object sourceCycleValueObject = ((DynamicObject)subEntityCol.get(j)).get(prefix + "monthstaff" + sourceCycle);
            for (String targetCycle : targetCycleList) {
                this.getView().getParentView().getModel().setValue(prefix + "monthstaff" + targetCycle, sourceCycleValueObject, j, rowIndex);
            }
        }
    }

    private void copyEntryValue(String sourceCycle, List<String> targetCycleList, String centryentity, String cmonthstaff, List<Integer> selectIndexList) {
        DynamicObjectCollection positionEntryEntityCol = this.getView().getParentView().getModel().getEntryEntity(centryentity);
        for (int i = 0; i < positionEntryEntityCol.size(); ++i) {
            if (!selectIndexList.contains(i)) continue;
            DynamicObject positionEntryEntity = (DynamicObject)positionEntryEntityCol.get(i);
            Object sourceCycleValueObject = positionEntryEntity.get(cmonthstaff + sourceCycle);
            for (String targetCycle : targetCycleList) {
                this.getView().getParentView().getModel().setValue(cmonthstaff + targetCycle, sourceCycleValueObject, i);
            }
        }
    }

    private List<Integer> getParentViewSelectRowList(String entryName) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getParentView().getControl(entryName);
        int[] selectRows = entryGrid.getSelectRows();
        return Arrays.stream(selectRows).boxed().collect(Collectors.toList());
    }
}

