/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.form;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.haos.business.domain.repository.staff.StaffRuleConfigRepository;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.util.BaseDataHelper;
import kd.hr.haos.business.util.ConcurrentIdCreator;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.constants.staff.OrgStaffRuleConfigConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class OrgStaffRuleConfigEdit
extends HRDataBaseEdit
implements OrgStaffConstants,
OrgStaffRuleConfigConstants,
BeforeF7SelectListener {
    private String CALLBACK_ID_DELETE_ENTRY = "deleteentry";

    public void registerListener(EventObject event) {
        super.registerListener(event);
        BasedataEdit staffProjectEdit = (BasedataEdit)this.getView().getControl("staffproject");
        staffProjectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit staffRuleOrgEdit = (BasedataEdit)this.getView().getControl("staffruleorg");
        staffRuleOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        this.setFieldEnable();
        this.setFieldVisible();
        this.setButtonVisibleForPerm();
        this.setId();
    }

    private void setFieldVisible() {
        this.setRefStaffVisible();
    }

    private void setRefStaffVisible() {
        DynamicObjectCollection ruleConfigEntryEntity = this.getView().getModel().getEntryEntity("entryentity");
        Boolean needShowRefStaff = Boolean.TRUE;
        needShowRefStaff = CollectionUtil.isEmpty((Collection)ruleConfigEntryEntity) ? Boolean.FALSE : Boolean.valueOf(ruleConfigEntryEntity.stream().anyMatch(entry -> Objects.nonNull(entry.getDynamicObject("refstaff"))));
        this.getView().setVisible(needShowRefStaff, new String[]{"refstaff"});
        this.getView().setVisible(needShowRefStaff, new String[]{"refstaffenable"});
    }

    private void setId() {
        IDataModel model = this.getView().getModel();
        long id = model.getDataEntity().getLong("id");
        if (id == 0L) {
            ConcurrentIdCreator idCreator = new ConcurrentIdCreator();
            model.setValue("id", (Object)idCreator.getId());
        }
    }

    private void setButtonVisibleForPerm() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnsave"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnchangesave"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnchangesave"});
        }
    }

    private void setFieldEnable() {
        long ruleConfigId = this.getView().getModel().getDataEntity().getLong("id");
        boolean ruleConfigIsExist = StaffRuleConfigRepository.getInstance().isExist(new QFilter("id", "=", (Object)ruleConfigId));
        if (ruleConfigIsExist) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "year", "staffcycle"});
            this.setEntryEnable();
        }
    }

    private void setEntryEnable() {
        DynamicObjectCollection ruleConfigEntryCol = this.getModel().getEntryEntity("entryentity");
        if (ruleConfigEntryCol.size() > 0) {
            DataEntityPropertyCollection entryProperties = ((DynamicObject)ruleConfigEntryCol.get(0)).getDynamicObjectType().getProperties();
            List<String> entryPropertyNameList = entryProperties.stream().map(entryProperty -> entryProperty.getName()).collect(Collectors.toList());
            for (int i = 0; i < ruleConfigEntryCol.size(); ++i) {
                DynamicObject ruleConfigEntry2 = (DynamicObject)ruleConfigEntryCol.get(i);
                this.getView().setEnable(Boolean.valueOf(Objects.isNull(ruleConfigEntry2.getDynamicObject("refstaff"))), i, entryPropertyNameList.toArray(new String[0]));
            }
            ruleConfigEntryCol.stream().map(ruleConfigEntry -> ruleConfigEntry.getDynamicObjectType().getProperties());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"org")) {
            this.getView().getModel().deleteEntryData("entryentity");
            this.setRefStaffVisible();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter listForm = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("staffproject".equals(propertyName)) {
            QFilter filter = StaffCommonService.getBaseDataAuthByOrg((DynamicObject)((DynamicObject)this.getModel().getValue("org")), (String)"haos_staffproject");
            listForm.getListFilterParameter().setFilter(filter);
        } else if ("staffruleorg".equals(propertyName)) {
            long orgId = this.getModel().getDataEntity().getLong("org.id");
            QFilter orgIdFilter = new QFilter("org", "=", (Object)orgId);
            orgIdFilter.and(BaseDataHelper.getAdminOrgBaseDataFilter((String)"staffruleorg", Collections.singletonList(orgId)));
            orgIdFilter.and(this.getPageExistAdminOrgFilter());
            listForm.getListFilterParameter().setFilter(orgIdFilter);
        }
    }

    private QFilter getPageExistAdminOrgFilter() {
        ArrayList existAdminOrgIdList = Lists.newArrayListWithExpectedSize((int)16);
        DynamicObjectCollection ruleConfigEntryCol = this.getView().getModel().getEntryEntity("entryentity");
        ruleConfigEntryCol.stream().forEach(ruleConfigEntry -> {
            if (!HRStringUtils.equals((String)ruleConfigEntry.getString("refstaff.enable"), (String)"0")) {
                DynamicObjectCollection staffRuleOrgCol = ruleConfigEntry.getDynamicObjectCollection("staffruleorg");
                for (DynamicObject staffRuleOrg : staffRuleOrgCol) {
                    existAdminOrgIdList.add(staffRuleOrg.getLong("fbasedataid.id"));
                }
            }
        });
        if (CollectionUtil.isEmpty((Collection)existAdminOrgIdList)) {
            return new QFilter("1", "=", (Object)1);
        }
        return new QFilter("id", "not in", (Object)existAdminOrgIdList);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)"newentry", (String)operateKey)) {
            DynamicObject org = this.getView().getModel().getDataEntity().getDynamicObject("org");
            if (Objects.isNull(org)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u7ec4\u7ec7\u4f53\u7cfb\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"OrgStaffRuleConfigEdit_04", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)"deleteentry", (String)operateKey)) {
            int[] selectRowArray = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            if (selectRowArray.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"OrgStaffRuleConfigEdit_02", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                return;
            }
            Boolean needToShowTip = Boolean.FALSE;
            DynamicObjectCollection ruleConfigEntryEntity = this.getView().getModel().getEntryEntity("entryentity");
            for (int selectRow : selectRowArray) {
                DynamicObject ruleConfigEntry = (DynamicObject)ruleConfigEntryEntity.get(selectRow);
                if (!Objects.nonNull(ruleConfigEntry.getDynamicObject("refstaff"))) continue;
                needToShowTip = Boolean.TRUE;
            }
            if (needToShowTip.booleanValue()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684\u8bb0\u5f55\u540e\u5c06\u540c\u6b65\u5220\u9664\u5f85\u542f\u7528\u7684\u5173\u8054\u7f16\u5236\u4fe1\u606f\uff0c\u786e\u8ba4\u8981\u5220\u9664\u8bb0\u5f55\u5417\uff1f", (String)"OrgStaffRuleConfigEdit_01", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(this.CALLBACK_ID_DELETE_ENTRY, (IFormPlugin)this));
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)"save", (String)operateKey) || HRStringUtils.equals((String)"saveforchange", (String)operateKey)) {
            if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("entryentity"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u884c\u5206\u5f55\u6570\u636e\u3002", (String)"OrgStaffRuleConfigEdit_05", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
            this.setPermEntry(dataEntity);
        }
    }

    private void setPermEntry(DynamicObject dataEntity) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("orgpermentryentity");
        DynamicObjectCollection ruleConfigEntryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection ruleOrgPermEntryEntity = dataEntity.getDynamicObjectCollection("orgpermentryentity");
        ruleOrgPermEntryEntity.clear();
        if (CollectionUtils.isEmpty((Collection)ruleConfigEntryEntity)) {
            return;
        }
        ArrayList staffRuleOrgIdList = Lists.newArrayListWithExpectedSize((int)ruleConfigEntryEntity.size());
        for (DynamicObject ruleConfigEntry : ruleConfigEntryEntity) {
            DynamicObjectCollection staffRuleOrgDynCol = ruleConfigEntry.getDynamicObjectCollection("staffruleorg");
            staffRuleOrgIdList.addAll(staffRuleOrgDynCol.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toList()));
        }
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("staffruleorgperm", new Object[0]);
        for (Long staffRuleOrgId : staffRuleOrgIdList) {
            vs.addRow(new Object[]{staffRuleOrgId});
        }
        model.beginInit();
        model.batchCreateNewEntryRow("orgpermentryentity", vs);
        model.endInit();
        this.getView().updateView("orgpermentryentity");
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)this.CALLBACK_ID_DELETE_ENTRY) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            int[] selectRowArray = ((EntryGrid)this.getView().getControl("entryentity")).getSelectRows();
            DynamicObjectCollection ruleConfigEntryCol = this.getView().getModel().getEntryEntity("entryentity");
            ArrayList needToSelectRowList = Lists.newArrayListWithExpectedSize((int)16);
            for (int selectRow : selectRowArray) {
                DynamicObject ruleConfigEntry = (DynamicObject)ruleConfigEntryCol.get(selectRow);
                if (Objects.nonNull(ruleConfigEntry.getDynamicObject("refstaff"))) {
                    if (HRStringUtils.equals((String)"10", (String)ruleConfigEntry.getString("refstaff.enable"))) {
                        needToSelectRowList.add(selectRow);
                        continue;
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7f16\u5236\u4fe1\u606f\u4e0d\u4e3a\u201c\u5f85\u542f\u7528\u201d\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"OrgStaffRuleConfigEdit_03", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), this.getEntryRowOrgNameStr(ruleConfigEntry)));
                    continue;
                }
                needToSelectRowList.add(selectRow);
            }
            this.getView().getModel().deleteEntryRows("entryentity", needToSelectRowList.stream().mapToInt(i -> i).toArray());
            this.setRefStaffVisible();
            this.setFieldEnable();
        }
    }

    private String getEntryRowOrgNameStr(DynamicObject ruleConfigEntry) {
        StringBuilder orgNameSb = new StringBuilder();
        ruleConfigEntry.getDynamicObjectCollection("staffruleorg").stream().forEach(org -> orgNameSb.append(org.getString("fbasedataid.name")).append("\u3001"));
        return orgNameSb.deleteCharAt(orgNameSb.length() - 1).toString();
    }
}

