/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.list;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.list.column.IntegerColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.service.impl.staff.SyncPersonStaffServiceImpl;
import kd.hr.haos.business.domain.service.staff.ISyncPersonStaffService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class OrgStaffListPlugin
extends HRDataBaseList
implements OrgStaffConstants {
    private static final String DELETE_CONFIRM_CALL_BACK = "deleteConfirmCallBack";
    private ISyncPersonStaffService syncPersonStaffService = new SyncPersonStaffServiceImpl();
    private static final String TASKCLOSEBACK_ENABLE = "taskcloseback_enable";

    public void packageData(PackageDataEvent event) {
        Object source = event.getSource();
        if (source instanceof IntegerColumnDesc) {
            String key = ((IntegerColumnDesc)source).getKey();
            if ("staffelasticcount".equals(key)) {
                Integer count = event.getRowData().getInt("staffelasticcount");
                if ("2".equals(event.getRowData().getString("staffelasticcontrol"))) {
                    event.setFormatValue((Object)(count + "%"));
                }
            }
        } else if (source instanceof DynamicTextColumnDesc) {
            String key = ((DynamicTextColumnDesc)source).getKey();
            String enable = event.getRowData().getString("enable");
            if ("staffstatus".equals(key) && "1".equals(enable)) {
                Date staffYear = event.getRowData().getDate("year");
                if (this.isUsing(staffYear)) {
                    event.setFormatValue((Object)ResManager.loadKDString((String)"\u4f7f\u7528\u4e2d", (String)"OrgStaffListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                } else {
                    event.setFormatValue((Object)ResManager.loadKDString((String)"\u5df2\u7ed3\u675f", (String)"OrgStaffListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        List successPkIds;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if ("donothing_delete".equals(operateKey) && operationResult.isSuccess()) {
            FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
            OperateOption option = formOperate.getOption();
            if (option.containsVariable("title") && option.containsVariable("message") && option.containsVariable("showConfirm")) {
                String title = option.getVariableValue("title");
                String message = option.getVariableValue("message");
                String showConfirm = option.getVariableValue("showConfirm");
                if (HRStringUtils.equals((String)showConfirm, (String)String.valueOf(true))) {
                    this.getView().showTipNotification(message);
                    this.getView().invokeOperation("refresh");
                } else {
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DELETE_CONFIRM_CALL_BACK);
                    StaffFormService.create(this.getView()).showOperationResultPage(title, message, closeCallBack);
                }
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"OrgStaffListPlugin_0", (String)"hrmp-haos-opplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
        } else if ("donothing_modify".equals(operateKey)) {
            ListSelectedRowCollection listSelectedData = ((Donothing)afterDoOperationEventArgs.getSource()).getListSelectedData();
            if (listSelectedData.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e91\u6761\u6570\u636e\u8fdb\u884c\u53d8\u66f4\u3002", (String)"OrgStaffListPlugin_9", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
                return;
            }
            BaseShowParameter parameters = new BaseShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameters.setFormId("haos_staff");
            parameters.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u7f16\u5236\u4fe1\u606f-", (String)"OrgStaffListPlugin_7", (String)"hrmp-haos-formplugin", (Object[])new Object[0]).concat(listSelectedData.get(0).getName()));
            parameters.setPkId(((Donothing)afterDoOperationEventArgs.getSource()).getListFocusRow().getPrimaryKeyValue());
            parameters.setStatus(OperationStatus.EDIT);
            parameters.setCustomParam("opentype", (Object)"1");
            this.getView().showForm((FormShowParameter)parameters);
        } else if ("donothing_openreport".equals(operateKey)) {
            this.showRemainListView(afterDoOperationEventArgs);
        } else if ("enable".equals(operateKey) && !CollectionUtil.isEmpty((Collection)(successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds()))) {
            List staffIdList = successPkIds.stream().map(id -> Long.parseLong(id.toString())).collect(Collectors.toList());
            DynamicObject[] staffDynArr = StaffRepository.getInstance().queryStaffByIdList(staffIdList);
            Date minDate = (Date)Arrays.stream(staffDynArr).map(dyn -> dyn.getDate("year")).collect(Collectors.minBy(Date::compareTo)).get();
            Date firstDateOfYear = OrgDateTimeUtil.getFirstDateOfYear((Date)minDate);
            String taskName = ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f", (String)"OrgStaffListPlugin_8", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.syncPersonStaffService.batchDispatchSyncSpecialRuleStaffTaskStaffScope(new ArrayList(staffIdList), taskName, new CloseCallBack((IFormPlugin)this, TASKCLOSEBACK_ENABLE), this.getView(), firstDateOfYear);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (DELETE_CONFIRM_CALL_BACK.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if (TASKCLOSEBACK_ENABLE.equals(actionId)) {
            this.taskCallBack(closedCallBackEvent.getReturnData());
        }
    }

    private void showRemainListView(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        ListSelectedRowCollection listSelectedData = ((Donothing)afterDoOperationEventArgs.getSource()).getListSelectedData();
        if (listSelectedData.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u8be2\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7f16\u5236\u4fe1\u606f\u3002", (String)"OrgStaffListPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        if (listSelectedData.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u67e5\u8be2\u7684\u7f16\u5236\u4fe1\u606f\u3002", (String)"OrgStaffListPlugin_4", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        long staffId = (Long)((Donothing)afterDoOperationEventArgs.getSource()).getListFocusRow().getPrimaryKeyValue();
        DynamicObject staffDy = StaffRepository.getInstance().queryStaffById("year, enable", staffId);
        if (!"1".equals(staffDy.getString("enable"))) {
            String multiLangStr = ResManager.loadKDString((String)"\u672a\u542f\u7528\u7684\u7f16\u5236\u4fe1\u606f\u4e0d\u80fd\u67e5\u8be2\u4f7f\u7528\u60c5\u51b5\u3002", (String)"OrgStaffListPlugin_5", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(multiLangStr);
            return;
        }
        if (!this.isUsing(staffDy.getDate("year"))) {
            String multiLangStr = ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2\u7f16\u5236\u72b6\u6001\u4e3a\u4f7f\u7528\u4e2d\u7684\u7f16\u5236\u4fe1\u606f\u3002", (String)"OrgStaffListPlugin_6", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(multiLangStr);
            return;
        }
        ListShowParameter parameters = new ListShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameters.setBillFormId("haos_remainstafflist");
        parameters.setCustomParam("staff", (Object)staffId);
        this.getView().showForm((FormShowParameter)parameters);
    }

    private boolean isUsing(Date staffYear) {
        return HRDateTimeUtils.getYear((Date)staffYear) >= HRDateTimeUtils.getYear((Date)new Date());
    }

    private void taskCallBack(Object returnData) {
        if (!(returnData instanceof Map)) {
            return;
        }
        Map result = (Map)returnData;
        String taskInfoStr = (String)result.get("taskinfo");
        if (HRStringUtils.isBlank((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        if (!taskInfo.isTaskEnd()) {
            return;
        }
        String data = taskInfo.getData();
        Map dataMap = (Map)JSONObject.parseObject((String)data, Map.class);
        if (dataMap == null) {
            return;
        }
        Boolean success = (Boolean)dataMap.get("success");
        if (success != null && success.booleanValue()) {
            String msg = ResManager.loadKDString((String)"[\u6279\u91cf\u540c\u6b65]-\u5458\u5de5\u5360\u7f16\u4fe1\u606f\u4efb\u52a1\u5b8c\u6210", (String)"OrgParameterconsoleEdit_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(msg);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Object primaryKeyValue = hyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
        BillList billList = (BillList)hyperLinkClickEvent.getSource();
        String formId = billList.getBillFormId();
        args.setCancel(true);
        HRBaseServiceHelper staffHelper = new HRBaseServiceHelper("haos_staff");
        QFilter idFilter = new QFilter("id", "=", primaryKeyValue);
        DynamicObject staff = staffHelper.queryOne("id,name,number", new QFilter[]{idFilter});
        if (staff == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"OrgStaffListPlugin_10", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            return;
        }
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(primaryKeyValue);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setBillStatus(BillOperationStatus.VIEW);
        parameter.setFormId(formId);
        parameter.setPageId(this.getView().getPageId() + primaryKeyValue);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

