/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.list;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.service.staff.bean.OccupyStaffResult;
import kd.hr.haos.business.service.staff.bean.RemainStaffBO;
import kd.hr.haos.business.service.staff.bean.StaffCycle;
import kd.hr.haos.business.service.staff.bean.StaffCycleEnum;
import kd.hr.haos.business.service.staff.occupy.impl.StaffOccupyServiceImpl;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.formplugin.web.staff.list.RemainStaffRemainDataProvider;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class RemainStaffRemainListPlugin
extends HRDataBaseList {
    private RemainStaffBO staffBO;
    private Map<Long, String> idVsLongName;
    private TimeLogger timeLogger = TimeLogger.create();

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.setCaption(e.getFormShowParameter());
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new RemainStaffRemainDataProvider(this.getStaffBO()));
    }

    public void setFilter(SetFilterEvent e) {
        e.getQFilters().add(new QFilter("staff", "=", (Object)this.getStaffBO().getStaffId()));
        e.getQFilters().add(new QFilter("controlstrategy", "!=", (Object)"4"));
        e.getQFilters().add(new QFilter("datastatus", "in", (Object)new String[]{EnumHisDataVersionStatus.EFFECTING.getStatus()}));
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        this.timeLogger.check("beforePackageData");
        Set orgIdSet = event.getPageData().stream().map(dy -> dy.getLong("adminorg.id")).collect(Collectors.toSet());
        this.idVsLongName = OrgBatchBillHelper.getOrgLongNameByFid(orgIdSet, (Date)this.getStaffBO().getModifyTime(), null);
        this.timeLogger.check("getOrgLongNameByFid");
        this.setStaffCountValue(event.getPageData());
        this.timeLogger.check("queryUseStaffInfo");
    }

    private void setStaffCountValue(DynamicObjectCollection pageData) {
        if (pageData.size() == 0) {
            return;
        }
        StaffOccupyServiceImpl iStaffOccupyService = new StaffOccupyServiceImpl();
        OccupyStaffResult occupyStaffResult = iStaffOccupyService.queryUseAndDutyStaffInfo(new Date(), this.getStaffBO().getStaffId(), this.getStaffBO().getYear());
        HashMap<String, Integer> defaultMap = new HashMap<String, Integer>();
        defaultMap.put("staffcount", 0);
        defaultMap.put("remaincount", 0);
        defaultMap.put("occupycount", 0);
        for (DynamicObject pageDatum : pageData) {
            Map countMap = defaultMap;
            String orgBo = pageDatum.getString("adminorg.boid");
            if (HRStringUtils.equals((String)pageDatum.getString("stafftype"), (String)"1")) {
                countMap = occupyStaffResult.getDutyOrgMap().getOrDefault(orgBo, defaultMap);
            } else if (HRStringUtils.equals((String)pageDatum.getString("stafftype"), (String)"2")) {
                countMap = occupyStaffResult.getUseOrgMap().getOrDefault(orgBo, defaultMap);
            }
            pageDatum.set("staffcount", countMap.get("staffNum"));
            pageDatum.set("remaincount", countMap.get("remainStaffNum"));
            pageDatum.set("occupycount", (Object)(countMap.getOrDefault("holdStaff", 0) + countMap.getOrDefault("inTranHoldStaff", 0) + countMap.getOrDefault("inTranReleaseStaff", 0)));
            pageDatum.set("intranentrystaffcount", (Object)countMap.getOrDefault("entryInTransit", 0));
            pageDatum.set("intraninstaffcount", (Object)countMap.getOrDefault("transferInTransit", 0));
            pageDatum.set("intranoutstaffcount", (Object)countMap.getOrDefault("transferOutTransit", 0));
            pageDatum.set("intrandepartstaffcount", (Object)countMap.getOrDefault("departInTransit", 0));
        }
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        if ("parentorglongname".equals(columnDesc.getFieldKey())) {
            long parentOrgBo = event.getRowData().getLong("adminorg.id");
            event.setFormatValue((Object)this.getParentOrgLongName(parentOrgBo));
        }
    }

    private RemainStaffBO getStaffBO() {
        if (this.staffBO == null) {
            long staffId = this.getStaffId(this.getView().getFormShowParameter());
            this.initStaffBO(staffId);
        }
        return this.staffBO;
    }

    private long getStaffId(FormShowParameter formShowParameter) {
        return Long.parseLong(formShowParameter.getCustomParam("staff").toString());
    }

    private void initStaffBO(long staffId) {
        DynamicObject staffDy = StaffRepository.getInstance().queryStaffById("id, modifytime, staffcycle.id, org.id, year, name", staffId);
        RemainStaffBO remainStaffBO = new RemainStaffBO();
        remainStaffBO.setStaffId(staffDy.getLong("id"));
        remainStaffBO.setModifyTime(staffDy.getDate("modifytime"));
        remainStaffBO.setStaffCycle(StaffCycle.createWithToday((StaffCycleEnum)StaffCycleEnum.getInstance((long)staffDy.getLong("staffcycle.id"))));
        remainStaffBO.setOrgId(staffDy.getLong("org.id"));
        remainStaffBO.setYear(staffDy.getDate("year"));
        remainStaffBO.setName(staffDy.getString("name"));
        this.staffBO = remainStaffBO;
    }

    private String getParentOrgLongName(long orgBo) {
        return this.idVsLongName.getOrDefault(orgBo, "");
    }

    private void setCaption(FormShowParameter formShowParameter) {
        long staffId = this.getStaffId(formShowParameter);
        this.initStaffBO(staffId);
        String multiLangStr = ResManager.loadKDString((String)"%s-\u5f53\u524d\u7f16\u5236\u4f7f\u7528\u60c5\u51b5", (String)"RemainStaffRemainListPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        formShowParameter.setCaption(String.format(multiLangStr, this.getStaffBO().getName()));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        DynamicObject staffDyn = StaffRepository.getInstance().loadDynamicObject(Long.valueOf(this.getStaffBO().getStaffId()));
        if (!HRStringUtils.equals((String)staffDyn.getString("enable"), (String)"1")) {
            args.setCancel(true);
            String msg = "";
            if (HRStringUtils.equals((String)"refresh", (String)operateKey)) {
                msg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u7684\u7f16\u5236\u4fe1\u606f\u4e0d\u80fd\u67e5\u8be2\u4f7f\u7528\u60c5\u51b5\u3002", (String)"RemainStaffRemainListPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.equals((String)"exportlist", (String)operateKey)) {
                msg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u7684\u7f16\u5236\u4fe1\u606f\u4e0d\u80fd\u5bfc\u51fa\u6570\u636e\u3002", (String)"RemainStaffRemainListPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
            }
            if (HRStringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
            }
        } else if ("refresh".equals(operateKey)) {
            this.getPageCache().getAll().clear();
        }
    }
}

