/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.list;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.common.constants.staff.StaffCaseConstants;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class StaffCaseListPlugin
extends HRDataBaseList
implements StaffCaseConstants {
    String FULL_TIME_NUMBER = "1010_S";

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("createtime desc");
    }

    private List<Map<String, Object>> getPersonData(List<Long> personIdList) {
        List rtnList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"listEmpposorgrels", (Object[])new Object[]{this.FULL_TIME_NUMBER, personIdList});
        return rtnList;
    }

    public List<DynamicObject> getEmpOrgRelDyn(List<Long> depEmpIdList) {
        List rtnList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listEmpOrgrelDys", (Object[])new Object[]{depEmpIdList});
        return rtnList;
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        this.updateDepEmpAndCompany();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        this.updateDepEmpAndCompany();
    }

    private void updateDepEmpAndCompany() {
        DynamicObject[] allStaffCaseDyns = StaffCaseRepository.getInstance().queryAllDyns();
        List<Long> personIdList = Arrays.stream(allStaffCaseDyns).map(dyn -> dyn.getLong("person.id")).collect(Collectors.toList());
        List<Map<String, Object>> personDataList = this.getPersonData(personIdList);
        Map<Long, Long> personIdVsDepEmpIdMap = personDataList.stream().collect(Collectors.toMap(map -> Long.valueOf(map.get("person_id").toString()), map -> (Long)map.get("depemp_id"), (v1, v2) -> v2));
        ArrayList depEmpIdList = Lists.newArrayListWithExpectedSize((int)allStaffCaseDyns.length);
        Arrays.stream(allStaffCaseDyns).forEach(dyn -> {
            long personId = dyn.getLong("person.id");
            Long depEmpId = (Long)personIdVsDepEmpIdMap.get(personId);
            depEmpIdList.add(depEmpId);
        });
        List<DynamicObject> depEmpOrgRelDynList = this.getEmpOrgRelDyn(depEmpIdList);
        Map<Long, Long> depEmpIdVsCompanyIdMap = depEmpOrgRelDynList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("depemp_id"), dyn -> dyn.getLong("company.id")));
        for (DynamicObject staffCaseDyn : allStaffCaseDyns) {
            long personId = staffCaseDyn.getLong("person.id");
            Long depEmpId = personIdVsDepEmpIdMap.get(personId);
            if (depEmpId == null || depEmpId == 0L) continue;
            depEmpIdList.add(depEmpId);
            staffCaseDyn.set("personnel", (Object)depEmpId);
            Long companyId = depEmpIdVsCompanyIdMap.get(depEmpId);
            staffCaseDyn.set("adminorg", (Object)companyId);
        }
        StaffCaseRepository.getInstance().updateDyns(allStaffCaseDyns);
    }
}

