/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.staff.service;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.other.LaborRelTypeRepository;
import kd.hr.haos.business.service.staff.bean.StaffEntryParamBO;
import kd.hr.haos.business.service.staff.bean.StaffProjectBo;
import kd.hr.haos.business.service.staff.bean.UseOrgEntryParamBO;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.formplugin.web.staff.service.StaffFormService;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffInitEntryDataService
implements OrgStaffConstants {
    private static final Log logger = LogFactory.getLog(StaffInitEntryDataService.class);
    private IFormView formView;
    private IDataModel model;
    private OperationStatus operateStatus;
    private List<UseOrgEntryParamBO> useOrgEntryData;
    private List<UseOrgEntryParamBO> useOrgEntryDataFromDB;
    private List<UseOrgEntryParamBO> disableUseOrgEntryDataFromDB;
    private DynamicObject[] dutyOrgInfoArr;
    private StaffExtEntryHelper staffExtEntryHelper;
    private TimeLogger timeLogger = TimeLogger.create();

    private StaffInitEntryDataService(IFormView formView, IDataModel model) {
        this.timeLogger.startForError();
        this.staffExtEntryHelper = new StaffExtEntryHelper();
        this.formView = formView;
        this.model = model;
        this.operateStatus = formView.getFormShowParameter().getStatus();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        logger.info("StaffInitEntryDataService.init.orgId:{}, operateStatus:{}", (Object)orgId, (Object)this.operateStatus);
        if (OperationStatus.ADDNEW.equals((Object)this.operateStatus)) {
            this.useOrgEntryData = StaffCommonService.getStaffEntryInfo((IFormView)formView, (long)orgId, null, (boolean)false);
        }
        if (OperationStatus.EDIT.equals((Object)this.operateStatus) || OperationStatus.VIEW.equals((Object)this.operateStatus)) {
            long staffId = model.getDataEntity().getLong("id");
            this.dutyOrgInfoArr = StaffCommonService.queryStaffTempAndEffectData((String)"haos_dutyorgdetail", (Long)staffId, (String)"dutyorg, staffcount");
            QFilter permFilter = StaffCommonService.getOrgPermQFilterForUseOrgEntry();
            DynamicObject[] useOrgInfoArr = StaffCommonService.queryStaffTempAndEffectDataWithFilter((String)"haos_useorgdetail", (Long)staffId, (QFilter)permFilter, (String)"id, useorg.id, useorg.enable, useorg, useorgbo, dutyorg.id, sequence, pid,staffdimension.fbasedataid, controlstrategy, elasticcontrol, elasticcount, yearstaff, halfyearstaff1, halfyearstaff2, quarterstaff1, quarterstaff2, quarterstaff3, quarterstaff4, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12");
            logger.info("StaffInitEntryDataService#init model useOrgInfoArr size ={} ", (Object)useOrgInfoArr.length);
            this.useOrgEntryDataFromDB = StaffEntryHelper.buildUseOrgEntryParamBO((AbstractFormDataModel)((AbstractFormDataModel)model), (DynamicObject[])useOrgInfoArr, (DynamicObject[])this.dutyOrgInfoArr);
            logger.info("StaffInitEntryDataService#init model useOrgEntryDataFromDB size ={} ", (Object)this.useOrgEntryDataFromDB.size());
            if (OperationStatus.EDIT.equals((Object)this.operateStatus)) {
                this.useOrgEntryData = StaffCommonService.getStaffEntryInfo((IFormView)formView, (long)orgId, this.useOrgEntryDataFromDB, (boolean)true);
            }
        }
        logger.info("StaffInitEntryDataService.init.end!");
    }

    public static StaffInitEntryDataService create(IFormView formView, IDataModel model) {
        return new StaffInitEntryDataService(formView, model);
    }

    public void loadEntryData() {
        DynamicObject org = (DynamicObject)this.model.getValue("org");
        if (org == null) {
            return;
        }
        StaffFormService staffFormService = StaffFormService.create(this.formView, this.model);
        if (OperationStatus.ADDNEW.equals((Object)this.operateStatus)) {
            this.loadEntryDataNew();
        } else if (OperationStatus.EDIT.equals((Object)this.operateStatus) && !"true".equals(this.formView.getPageCache().get("isInit"))) {
            if (HRStringUtils.equals((String)this.formView.getPageCache().get("customLoadData"), (String)"1")) {
                this.model.deleteEntryData("bentryentity");
            } else {
                this.loadEntryDataChange();
                this.buildStaffNumWithSub(staffFormService);
            }
        } else if (OperationStatus.VIEW.equals((Object)this.operateStatus)) {
            this.loadEntryDataView();
            this.buildStaffNumWithSub(staffFormService);
        }
    }

    private void loadEntryDataNew() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.model;
        if (!CollectionUtils.isEmpty(this.useOrgEntryData)) {
            DynamicObjectCollection dimensionInfos = (DynamicObjectCollection)model.getValue("staffdimension");
            StaffProjectBo staffProjectBo = new StaffProjectBo(model.getValue("staffcontrolstrategy"), model.getValue("staffelasticcontrol"), model.getValue("staffelasticcount"), dimensionInfos);
            for (UseOrgEntryParamBO useOrgEntryParamBO : this.useOrgEntryData) {
                useOrgEntryParamBO.setStaffProjectBo(staffProjectBo);
            }
            StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)model, (IFormView)this.formView, this.useOrgEntryData);
            DynamicObjectCollection useOrgInfos = model.getEntryEntity("bentryentity");
            Set<Long> dimensionIds = dimensionInfos.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            this.setDimensionData(useOrgInfos, dimensionIds);
            StaffFormService.create(this.formView).setEntryLineEnableForPerm();
        }
    }

    public void setDimensionData(DynamicObjectCollection useOrgInfos, Set<Long> dimensionIds) {
        if (CollectionUtils.isEmpty((Collection)useOrgInfos) || CollectionUtils.isEmpty(dimensionIds)) {
            return;
        }
        Map<Long, DynamicObject> useOrgBoIdMap = useOrgInfos.stream().filter(dyn -> !CollectionUtils.isEmpty((Collection)dyn.getDynamicObjectCollection("bstaffdimension"))).collect(Collectors.toMap(dyn -> dyn.getLong("buseorg.boid"), dyn -> dyn));
        Map positionAndJobIdMap = StaffCommonService.getPositionAndJobIds(new ArrayList<Long>(useOrgBoIdMap.keySet()));
        DynamicObjectCollection positionListAll = new DynamicObjectCollection();
        DynamicObjectCollection jobListAll = new DynamicObjectCollection();
        DynamicObjectCollection laborListAll = new DynamicObjectCollection();
        Set laborRelTypeIds = LaborRelTypeRepository.getInstance().queryLaborRelType();
        String controlStrategy = (String)this.model.getValue("staffcontrolstrategy");
        StaffProjectBo staffProjectBo = new StaffProjectBo((Object)controlStrategy, this.model.getValue("staffelasticcontrol"), this.model.getValue("staffelasticcount"));
        for (DynamicObject useOrgInfo : useOrgInfos) {
            long useOrgBoId = useOrgInfo.getLong("buseorg.boid");
            HashSet[] positionAndJobIds = (HashSet[])positionAndJobIdMap.get(useOrgBoId);
            StaffEntryHelper.buildChildEntryData(dimensionIds, (HashSet[])positionAndJobIds, (DynamicObjectCollection)positionListAll, (DynamicObjectCollection)jobListAll, (DynamicObjectCollection)laborListAll, (Set)laborRelTypeIds, (StaffProjectBo)staffProjectBo, (DynamicObject)useOrgInfo);
        }
        this.formView.setVisible(Boolean.valueOf("3".equals(controlStrategy)), new String[]{"celasticcontrol", "celasticcount", "delasticcontrol", "delasticcount", "econtrolstrategy", "eelasticcontrol", "eelasticcount", "cgroup2", "dgroup2", "egroup2"});
        for (String extDimPrefix : this.staffExtEntryHelper.getExtDimPrefix()) {
            this.formView.setVisible(Boolean.valueOf("3".equals(controlStrategy)), new String[]{extDimPrefix + "elasticcontrol", extDimPrefix + "elasticcount", extDimPrefix + "group2"});
        }
        StaffFormService staffFormService = StaffFormService.create(this.model);
        staffFormService.fillReferenceData(positionListAll);
        staffFormService.fillReferenceData(jobListAll);
        staffFormService.fillReferenceData(laborListAll);
    }

    public void loadEntryDataChange() {
        Map<Long, UseOrgEntryParamBO> useOrgEntryBOIdMap = this.useOrgEntryData.stream().collect(Collectors.toMap(StaffEntryParamBO::getBoId, dyn -> dyn));
        Map<Long, UseOrgEntryParamBO> useOrgFromDBMap = this.useOrgEntryDataFromDB.stream().collect(Collectors.toMap(StaffEntryParamBO::getBoId, dyn -> dyn));
        List<UseOrgEntryParamBO> compareResult = this.compareForChange(useOrgEntryBOIdMap, useOrgFromDBMap);
        List adminOrgIds = compareResult.stream().map(StaffEntryParamBO::getAdminOrgId).collect(Collectors.toList());
        StaffProjectBo staffProjectBo = new StaffProjectBo(this.model.getValue("staffcontrolstrategy"), this.model.getValue("staffelasticcontrol"), this.model.getValue("staffelasticcount"), (DynamicObjectCollection)this.model.getValue("staffdimension"));
        ArrayList index = Lists.newArrayListWithExpectedSize((int)16);
        String roundType = (String)StaffCommonService.getSystemParam((long)((DynamicObject)this.model.getValue("org")).getLong("id"), (String)"elasticcountgroup");
        DynamicObject staffCycle = (DynamicObject)this.model.getValue("staffcycle");
        long orgId = this.model.getDataEntity().getLong("org.id");
        boolean transYearCount = (Boolean)StaffCommonService.getSystemParamBooleanValue((long)orgId, (String)"transyearcount", (boolean)Boolean.FALSE);
        boolean deductYearCount = (Boolean)StaffCommonService.getSystemParamBooleanValue((long)orgId, (String)"deductyearcount", (boolean)Boolean.FALSE);
        Map<String, Map<Long, List<UseOrgEntryParamBO>>> compareResultDataMap = this.getCompareResultDataMap(compareResult, transYearCount, deductYearCount);
        if (CollectionUtils.isEmpty(this.useOrgEntryData)) {
            this.model.deleteEntryData("bentryentity");
        }
        for (int i = 0; i < this.useOrgEntryData.size(); ++i) {
            UseOrgEntryParamBO useOrgEntryParamBO = this.useOrgEntryData.get(i);
            UseOrgEntryParamBO useOrgEntryParamBOFromDB = useOrgFromDBMap.get(useOrgEntryParamBO.getBoId());
            if (useOrgEntryParamBOFromDB != null) {
                useOrgEntryParamBO.setStaffProjectBo(useOrgEntryParamBOFromDB.getStaffProjectBo());
                useOrgEntryParamBO.setYearStaffNumWithSub(useOrgEntryParamBOFromDB.getYearStaffNumWithSub());
                useOrgEntryParamBO.setStaffNumWithSub(useOrgEntryParamBOFromDB.getStaffNumWithSub());
                useOrgEntryParamBO.setDyn(useOrgEntryParamBOFromDB.getDyn());
                useOrgEntryParamBO.setRoundType(roundType);
                this.handleYearStaffNum(useOrgEntryParamBO, compareResultDataMap);
            } else {
                useOrgEntryParamBO.setStaffProjectBo(staffProjectBo);
            }
            useOrgEntryParamBO.setStaffCycleId(staffCycle == null ? 0L : staffCycle.getLong("id"));
            if (adminOrgIds.contains(useOrgEntryParamBO.getAdminOrgId())) {
                index.add(i);
            }
            this.setYearStaffNullIfHaveNoChild(useOrgEntryParamBO);
        }
        StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)((AbstractFormDataModel)this.model), (IFormView)this.formView, this.useOrgEntryData);
        StaffFormService staffFormService = StaffFormService.create(this.formView);
        staffFormService.setColumnStyle("bentryentity", index, "buseorgnumber", "buseorgname");
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        long staffId = this.model.getDataEntity().getLong("id");
        this.setDimensionDataFromDB(staffId, useOrgInfos, false);
        if (!HRStringUtils.equals((String)this.formView.getPageCache().get("customLoadData"), (String)"1")) {
            this.syncPositionEntryData(useOrgInfos);
        }
    }

    public void syncPositionEntryData(DynamicObjectCollection useOrgInfos) {
        if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
            return;
        }
        List adminOrgBOIdList = useOrgInfos.stream().filter(useOrgInfo -> {
            String controlStrategy = useOrgInfo.getString("bcontrolstrategy");
            DynamicObjectCollection dimensions = useOrgInfo.getDynamicObjectCollection("bstaffdimension");
            Set dimensionIds = dimensions.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            return dimensionIds.contains(1010L) && !"4".equals(controlStrategy);
        }).map(useOrgInfo -> useOrgInfo.getLong("buseorg.boid")).collect(Collectors.toList());
        Map positionAndJobIds = StaffCommonService.getPositionAndJobIds(adminOrgBOIdList);
        DynamicObjectCollection positionListAll = new DynamicObjectCollection();
        for (DynamicObject useOrgEntry : useOrgInfos) {
            DynamicObjectCollection positionInfos = useOrgEntry.getDynamicObjectCollection("centryentity");
            HashSet[] positionAndJobIdArr = (HashSet[])positionAndJobIds.get(useOrgEntry.getLong("buseorg.boid"));
            if (positionAndJobIdArr == null) continue;
            Set dimensionIds = useOrgEntry.getDynamicObjectCollection("bstaffdimension").stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toSet());
            Set positionIds = positionInfos.stream().map(position -> position.getLong("cdutyworkrole.id")).collect(Collectors.toSet());
            StaffProjectBo staffProjectBo = new StaffProjectBo(useOrgEntry.get("bcontrolstrategy"), useOrgEntry.get("belasticcontrol"), useOrgEntry.get("belasticcount"));
            if (!dimensionIds.contains(1010L)) continue;
            HashSet positionIdAll = positionAndJobIdArr[0];
            positionIdAll.removeAll(positionIds);
            StaffEntryHelper.buildDimensionInfo((String)"c", (Set)positionIdAll, (DynamicObjectCollection)positionInfos, (StaffProjectBo)staffProjectBo);
            positionListAll.addAll((Collection)positionInfos);
        }
        StaffFormService staffFormService = StaffFormService.create(this.model);
        staffFormService.fillReferenceData(positionListAll);
    }

    private Map<String, Map<Long, List<UseOrgEntryParamBO>>> getCompareResultDataMap(List<UseOrgEntryParamBO> compareResult, boolean transYearCount, boolean deductYearCount) {
        List dataList;
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        if (CollectionUtils.isEmpty(compareResult)) {
            return dataMap;
        }
        Map<Long, UseOrgEntryParamBO> entryIdToParamBOMap = compareResult.stream().collect(Collectors.toMap(StaffEntryParamBO::getId, bo -> bo));
        for (UseOrgEntryParamBO bo2 : compareResult) {
            if (!deductYearCount && bo2.getChangeTypeId() == ChangeTransactionConstants.DISABLE.longValue() || !transYearCount && bo2.getChangeTypeId() == ChangeTransactionConstants.PARENT.longValue()) continue;
            Long oldParentDutyEntryId = bo2.getOldParentDutyEntryId();
            Map deductDataMap = dataMap.getOrDefault("del", Maps.newHashMap());
            dataList = deductDataMap.getOrDefault(oldParentDutyEntryId, Lists.newArrayList());
            dataList.add(bo2);
            deductDataMap.put(oldParentDutyEntryId, dataList);
            dataMap.put("del", deductDataMap);
            UseOrgEntryParamBO oldParentEntryParamBO = entryIdToParamBOMap.get(oldParentDutyEntryId);
            if (bo2.getChangeTypeId() != ChangeTransactionConstants.DISABLE.longValue() || oldParentEntryParamBO == null) continue;
            oldParentEntryParamBO.setMaxStaffNum(Integer.valueOf(oldParentEntryParamBO.getMaxStaffNum() - bo2.getMaxStaffNum()));
        }
        for (UseOrgEntryParamBO bo2 : compareResult) {
            if (!transYearCount && bo2.getChangeTypeId() == ChangeTransactionConstants.PARENT.longValue()) continue;
            Map addDataMap = dataMap.getOrDefault("add", Maps.newHashMap());
            Long parentDutyEntryId = bo2.getParentDutyEntryId();
            dataList = addDataMap.getOrDefault(parentDutyEntryId, Lists.newArrayList());
            dataList.add(bo2);
            addDataMap.put(parentDutyEntryId, dataList);
            dataMap.put("add", addDataMap);
        }
        return dataMap;
    }

    private void handleYearStaffNum(UseOrgEntryParamBO useOrgEntryParamBO, Map<String, Map<Long, List<UseOrgEntryParamBO>>> compareResultDataMap) {
        if (CollectionUtils.isEmpty(compareResultDataMap)) {
            return;
        }
        Integer yearStaffNumWithSub = useOrgEntryParamBO.getYearStaffNumWithSub();
        if (yearStaffNumWithSub == null) {
            return;
        }
        Map<Long, List<UseOrgEntryParamBO>> deductdataMap = compareResultDataMap.getOrDefault("del", Maps.newHashMap());
        List<UseOrgEntryParamBO> deductList = deductdataMap.getOrDefault(useOrgEntryParamBO.getId(), Lists.newArrayList());
        for (UseOrgEntryParamBO paranBO : deductList) {
            yearStaffNumWithSub = yearStaffNumWithSub - paranBO.getMaxStaffNum();
            useOrgEntryParamBO.setYearStaffNumWithSub(yearStaffNumWithSub);
        }
        Map<Long, List<UseOrgEntryParamBO>> addDataMap = compareResultDataMap.getOrDefault("add", Maps.newHashMap());
        List<UseOrgEntryParamBO> addList = addDataMap.getOrDefault(useOrgEntryParamBO.getId(), Lists.newArrayList());
        for (UseOrgEntryParamBO paranBO : addList) {
            yearStaffNumWithSub = yearStaffNumWithSub + paranBO.getMaxStaffNum();
            useOrgEntryParamBO.setYearStaffNumWithSub(yearStaffNumWithSub);
        }
    }

    private void setYearStaffNullIfHaveNoChild(UseOrgEntryParamBO useOrgEntryParamBO) {
        if (CollectionUtils.isEmpty((Collection)useOrgEntryParamBO.getChildEntryInfos())) {
            useOrgEntryParamBO.setYearStaffNumWithSub(null);
        }
    }

    private void setDimensionDataFromDB(long staffId, DynamicObjectCollection useOrgInfos, boolean isView) {
        if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
            return;
        }
        DynamicObject[] dimensionInfoArr = StaffCommonService.queryStaffTempAndEffectData((String)"haos_muldimendetail", (Long)staffId, (String)"id, useorg.id, useorg.enable, useorg.boid, orgteam, dutyworkrole, job,basicdata1,basicdata2,basicdata3,basicdata4,basicdata5, laborreltype, sequence, controlstrategy, elasticcontrol, elasticcount, yearstaff, halfyearstaff1, halfyearstaff2, quarterstaff1, quarterstaff2, quarterstaff3, quarterstaff4, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12");
        if (dimensionInfoArr == null || dimensionInfoArr.length == 0) {
            return;
        }
        Map<Long, List<DynamicObject>> dimensionInfoMap = Arrays.stream(dimensionInfoArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("useorg.boid")));
        for (DynamicObject useOrgEntry : useOrgInfos) {
            long useOrgBoId = useOrgEntry.getLong("buseorg.boid");
            DynamicObjectCollection positionInfos = useOrgEntry.getDynamicObjectCollection("centryentity");
            DynamicObjectCollection jobInfos = useOrgEntry.getDynamicObjectCollection("dentryentity");
            DynamicObjectCollection laborInfos = useOrgEntry.getDynamicObjectCollection("eentryentity");
            HashMap<Long, DynamicObjectCollection> extEntryMap = new HashMap<Long, DynamicObjectCollection>(8);
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                long extDimId = extDim.getLong("id");
                String prefix = this.staffExtEntryHelper.getExtDimPrefix(extDim.getString("staffdimension"));
                extEntryMap.put(extDimId, useOrgEntry.getDynamicObjectCollection(prefix + "entryentity"));
            }
            List<DynamicObject> subEntry = dimensionInfoMap.get(useOrgBoId);
            if (CollectionUtils.isEmpty(subEntry)) continue;
            for (DynamicObject dyn2 : subEntry) {
                if (dyn2.get("dutyworkrole") != null && (isView || "1".equals(dyn2.getString("dutyworkrole.enable")))) {
                    DynamicObject position = new DynamicObject(positionInfos.getDynamicObjectType());
                    this.setTabValueWithPrefix(position, dyn2, "c");
                    positionInfos.add((Object)position);
                    continue;
                }
                if (dyn2.get("job") != null && (isView || "1".equals(dyn2.getString("job.enable")))) {
                    DynamicObject job = new DynamicObject(jobInfos.getDynamicObjectType());
                    this.setTabValueWithPrefix(job, dyn2, "d");
                    jobInfos.add((Object)job);
                    continue;
                }
                if (dyn2.get("laborreltype") != null && (isView || "1".equals(dyn2.getString("laborreltype.enable")))) {
                    DynamicObject laborRelType = new DynamicObject(laborInfos.getDynamicObjectType());
                    this.setTabValueWithPrefix(laborRelType, dyn2, "e");
                    laborInfos.add((Object)laborRelType);
                    continue;
                }
                for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                    DynamicObjectCollection extEntryCol;
                    String dimension = extDim.getString("staffdimension");
                    if (dyn2.get(dimension) == null || (extEntryCol = (DynamicObjectCollection)extEntryMap.get(extDim.getLong("id"))) == null) continue;
                    DynamicObject extEntry = new DynamicObject(extEntryCol.getDynamicObjectType());
                    this.setTabValueWithPrefix(extEntry, dyn2, this.staffExtEntryHelper.getExtDimPrefix(dimension));
                    extEntryCol.add((Object)extEntry);
                }
            }
        }
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }

    private void loadEntryDataView() {
        long staffId = this.model.getDataEntity().getLong("id");
        String showDisable = this.formView.getPageCache().get("showDisable");
        if (HRStringUtils.equals((String)showDisable, (String)"true")) {
            DynamicObject[] disableUseOrgInfoArr = StaffCommonService.queryStaffTempAndEffectDisableData((String)"haos_useorgdetail", (Long)staffId, (String)"id, useorg.id, useorg.enable, useorg, useorgbo, dutyorg.id, sequence, pid,staffdimension.fbasedataid, controlstrategy, elasticcontrol, elasticcount, yearstaff, halfyearstaff1, halfyearstaff2, quarterstaff1, quarterstaff2, quarterstaff3, quarterstaff4, monthstaff1, monthstaff2, monthstaff3, monthstaff4, monthstaff5, monthstaff6, monthstaff7, monthstaff8, monthstaff9, monthstaff10, monthstaff11, monthstaff12");
            this.disableUseOrgEntryDataFromDB = StaffEntryHelper.buildUseOrgEntryParamBO((AbstractFormDataModel)((AbstractFormDataModel)this.model), (DynamicObject[])disableUseOrgInfoArr, (DynamicObject[])this.dutyOrgInfoArr);
            StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)((AbstractFormDataModel)this.model), (IFormView)this.formView, this.disableUseOrgEntryDataFromDB);
        } else {
            StaffEntryHelper.batchCreateNewEntryRow((AbstractFormDataModel)((AbstractFormDataModel)this.model), (IFormView)this.formView, this.useOrgEntryDataFromDB);
        }
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        this.setDimensionDataFromDB(staffId, useOrgInfos, true);
    }

    private List<UseOrgEntryParamBO> compareForChange(Map<Long, UseOrgEntryParamBO> useOrgEntryBOIdMap, Map<Long, UseOrgEntryParamBO> useOrgFromDBMap) {
        ArrayList compareResult = Lists.newArrayListWithExpectedSize((int)16);
        HashSet adminOrgBOIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet toRemoveId = Sets.newHashSetWithExpectedSize((int)16);
        Map<Long, UseOrgEntryParamBO> entryIdToEntryParamBOMap = this.useOrgEntryDataFromDB.stream().collect(Collectors.toMap(StaffEntryParamBO::getId, dyn -> dyn));
        long staffCycleId = this.model.getDataEntity().getLong("staffcycle.id");
        useOrgEntryBOIdMap.forEach((useOrgBOId, bo) -> {
            UseOrgEntryParamBO dbBO = (UseOrgEntryParamBO)useOrgFromDBMap.get(useOrgBOId);
            UseOrgEntryParamBO resultBO = new UseOrgEntryParamBO();
            resultBO.setAdminOrgId(bo.getAdminOrgId());
            if (dbBO == null) {
                bo.setId(ID.genLongId());
                resultBO.setChangeTypeId(ChangeTransactionConstants.ADD.longValue());
                resultBO.setId(bo.getId());
                compareResult.add(resultBO);
            } else {
                bo.setId(dbBO.getId());
                if (bo.getParentOrgId() != dbBO.getParentOrgId()) {
                    resultBO.setChangeTypeId(ChangeTransactionConstants.PARENT.longValue());
                    resultBO.setParentDutyEntryId(Long.valueOf(this.getParentDutyEntryId(bo.getParentEntryId(), entryIdToEntryParamBOMap)));
                    resultBO.setOldParentDutyEntryId(Long.valueOf(this.getParentDutyEntryId(dbBO.getParentEntryId(), entryIdToEntryParamBOMap)));
                    resultBO.setMaxStaffNum(dbBO.getMaxStaffNumByData(staffCycleId));
                    resultBO.setId(bo.getId());
                    compareResult.add(resultBO);
                }
                toRemoveId.add(dbBO.getAdminOrgId());
            }
            adminOrgBOIds.add(bo.getBoId());
        });
        for (UseOrgEntryParamBO dbBO : this.useOrgEntryDataFromDB) {
            if (toRemoveId.contains(dbBO.getAdminOrgId())) continue;
            UseOrgEntryParamBO resultBO = new UseOrgEntryParamBO();
            resultBO.setAdminOrgId(dbBO.getBoId());
            resultBO.setChangeTypeId(ChangeTransactionConstants.DISABLE.longValue());
            resultBO.setOldParentDutyEntryId(Long.valueOf(this.getParentDutyEntryId(dbBO.getParentEntryId(), entryIdToEntryParamBOMap)));
            resultBO.setMaxStaffNum(dbBO.getMaxStaffNumByData(staffCycleId));
            resultBO.setId(dbBO.getId());
            compareResult.add(resultBO);
        }
        StaffCommonService.buildStaffStructInfo(this.useOrgEntryData, useOrgEntryBOIdMap, (Set)adminOrgBOIds);
        if (!CollectionUtils.isEmpty((Collection)compareResult)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId("haos_staffcompareview");
            formShowParameter.setCustomParam("compareResult", (Object)JSON.toJSONString((Object)compareResult));
            formShowParameter.setHasRight(true);
            this.formView.showForm(formShowParameter);
        }
        return compareResult;
    }

    private long getParentDutyEntryId(Long id, Map<Long, UseOrgEntryParamBO> entryIdToEntryParamBOMap) {
        UseOrgEntryParamBO bo = entryIdToEntryParamBOMap.get(id);
        if (bo == null) {
            return 0L;
        }
        if (bo.getYearStaffNumWithSub() != null) {
            return id;
        }
        return this.getParentDutyEntryId(bo.getParentEntryId(), entryIdToEntryParamBOMap);
    }

    private void setTabValueWithPrefix(DynamicObject newDyn, DynamicObject dyn, String prefix) {
        DataEntityPropertyCollection targetProperties = newDyn.getDataEntityType().getProperties();
        DataEntityPropertyCollection sourceProperties = dyn.getDataEntityType().getProperties();
        HashMap fieldNameVsValueMap = Maps.newHashMapWithExpectedSize((int)sourceProperties.size());
        for (IDataEntityProperty sourceProperty : sourceProperties) {
            fieldNameVsValueMap.put(prefix + sourceProperty.getName(), dyn.get(sourceProperty.getName()));
        }
        for (IDataEntityProperty target : targetProperties) {
            String fieldName = target.getName();
            newDyn.set(fieldName, fieldNameVsValueMap.get(fieldName));
        }
        newDyn.set("id", (Object)dyn.getLong("id"));
        this.setMultiFieldNumWithPrefix(newDyn, prefix);
    }

    private void setMultiFieldNumWithPrefix(DynamicObject newDyn, String prefix) {
        String controlStrategy = newDyn.getString(prefix + "controlstrategy");
        if (HRStringUtils.equals((String)controlStrategy, (String)"3")) {
            String elasticControl = newDyn.getString(prefix + "elasticcontrol");
            int elasticCount = newDyn.getInt(prefix + "elasticcount");
            String roundType = (String)StaffCommonService.getSystemParam((long)((DynamicObject)this.model.getValue("org")).getLong("id"), (String)"elasticcountgroup");
            for (String commonCycleField : COMMON_CYCLE_FIELD) {
                Object value = newDyn.get(prefix + commonCycleField);
                if (value != null) {
                    value = StaffCommonService.elasticValueCalc((String)roundType, (String)elasticControl, (int)elasticCount, (Integer)((Integer)value));
                }
                newDyn.set(prefix + commonCycleField + "num", value);
            }
        }
    }

    public void buildStaffNumWithSub(StaffFormService staffFormService) {
        DynamicObjectCollection useOrgInfos = this.model.getEntryEntity("bentryentity");
        for (int i = 0; i < useOrgInfos.size(); ++i) {
            DynamicObject useOrgInfo = (DynamicObject)useOrgInfos.get(i);
            useOrgInfo.set("brealnumwithsub", (Object)0);
            if (useOrgInfo.get("byearstaffnumwithsub") == null) continue;
            staffFormService.rebuildStaffNumWithSub(useOrgInfo, i);
        }
        Map<Long, DynamicObject> idVsDynMap = useOrgInfos.stream().collect(Collectors.toMap(info -> info.getLong("id"), info -> info, (o1, o2) -> o1));
        List useOrgInfoSortList = useOrgInfos.stream().sorted(Comparator.comparing(o -> o.getString("bstructlongnumber"))).collect(Collectors.toList());
        for (int i = useOrgInfoSortList.size() - 1; i >= 0; --i) {
            Object parentRealNumWithSubObject;
            DynamicObject parentDyn;
            DynamicObject useOrgInfo = (DynamicObject)useOrgInfoSortList.get(i);
            Object directNumObject = useOrgInfo.get("bdirectnum");
            Object realNumWithSubObject = useOrgInfo.get("brealnumwithsub");
            if (Objects.isNull(directNumObject) && Objects.isNull(realNumWithSubObject)) continue;
            int realNumWithSub = 0;
            if (Objects.nonNull(realNumWithSubObject)) {
                realNumWithSub = (Integer)realNumWithSubObject;
            }
            int directNum = 0;
            if (Objects.nonNull(directNumObject)) {
                directNum = (Integer)directNumObject;
            }
            useOrgInfo.set("brealnumwithsub", (Object)(directNum + realNumWithSub));
            long parentEntryId = useOrgInfo.getLong("pid");
            if (parentEntryId == 0L || Objects.isNull(parentDyn = idVsDynMap.get(parentEntryId)) || !Objects.nonNull(parentRealNumWithSubObject = parentDyn.get("brealnumwithsub"))) continue;
            parentDyn.set("brealnumwithsub", (Object)(useOrgInfo.getInt("brealnumwithsub") + (Integer)parentRealNumWithSubObject));
        }
        this.formView.updateView("bentryentity");
    }
}

