/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.servicehelper.OrgBatchBillHelper;
import kd.hr.haos.business.servicehelper.VirtualOrgHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class StructOrgDetailPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String MODIFYBTN = "modifybtn";
    private static final String SAVEBTN = "savebtn";
    private Set<String> virtualOrgNumberSet = Sets.newHashSetWithExpectedSize((int)16);

    public void registerListener(EventObject event) {
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl("struct_parent_org");
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().getFormShowParameter().setCustomParam("custom_parent_f7_prop", (Object)"boid");
        this.getView().cacheFormShowParameter();
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVEBTN, "parent_struct_name"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals("struct_parent_org")) {
            DynamicObject parentDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (parentDy == null) {
                this.getModel().setValue("parent_struct_name", null);
                return;
            }
            String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
            String orgLongName = OrgBatchBillHelper.getOrgLongName((Long)parentDy.getLong("id"), (Date)new Date(), (String)String.valueOf(structProjectIdStr));
            this.getModel().setValue("parent_struct_name", (Object)orgLongName);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)SAVEBTN)) {
            OperateOption op = operate.getOption();
            op.setVariableValue("struct_project_ids", SerializationUtils.toJsonString((Object)this.getView().getFormShowParameter().getCustomParam("structproject")));
        } else if (HRStringUtils.equals((String)operateKey, (String)MODIFYBTN)) {
            this.getView().getParentView().getPageCache().put("oldModifyParentId", this.getParentIdStr());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        if (!eventArgs.getOperationResult().isSuccess()) {
            return;
        }
        if (operateKey.equals(MODIFYBTN)) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVEBTN, "parent_struct_name"});
            this.getView().setVisible(Boolean.FALSE, new String[]{MODIFYBTN, "struct_name"});
        } else if (HRStringUtils.equals((String)operateKey, (String)SAVEBTN)) {
            this.getModel().setDataChanged(false);
            IPageCache pageCache = this.getView().getParentView().getPageCache();
            pageCache.put("searchnode", this.getParentIdStr());
            pageCache.put("modifyNodeId", this.getModel().getDataEntity().getString("id"));
            this.getView().getParentView().invokeOperation("searchnode");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    private String getParentIdStr() {
        DynamicObject parentDy = this.getModel().getDataEntity().getDynamicObject("struct_parent_org");
        if (parentDy == null) {
            return "";
        }
        return parentDy.getString("boid");
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if ("struct_parent_org".equals(fieldKey)) {
            String structProjectIdStr = (String)this.getView().getFormShowParameter().getCustomParam("structproject");
            Long structProjectId = Long.valueOf(structProjectIdStr);
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7", (String)"VirtualOrgDetailPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
            event.getFormShowParameter().setCustomParam("struct_project_ids", (Object)SerializationUtils.toJsonString(Collections.singletonList(structProjectIdStr)));
            event.getFormShowParameter().setCustomParam("struct_project_visible", (Object)String.valueOf(Boolean.FALSE));
            event.getCustomQFilters().add(new QFilter("id", "not in", this.getSubOrgSet(structProjectId)));
            if ("getLookUpList".equals(event.getSourceMethod())) {
                Set orgSet = VirtualOrgHelper.getStructOrgSet((Long)structProjectId, (QFilter)((BasedataEdit)event.getSource()).getSearchFilter());
                event.getCustomQFilters().add(new QFilter("id", "in", (Object)orgSet));
                VirtualOrgHelper.setPermFilter((List)event.getCustomQFilters(), (Long)structProjectId);
            }
        }
    }

    private Set<Long> getSubOrgSet(Long structProjectId) {
        Long orgId = this.getModel().getDataEntity().getLong("boid");
        Date effectDate = HRDateTimeUtils.getNowDate();
        return VirtualOrgHelper.getSubOrgSet((Long)orgId, (Long)structProjectId, (Date)effectDate);
    }

    public void initImportData(InitImportDataEventArgs initImportDataEventArgs) {
        List sourceDataList = initImportDataEventArgs.getSourceDataList();
        for (int sourceDataIndex = 0; sourceDataIndex < sourceDataList.size(); ++sourceDataIndex) {
            int index = sourceDataIndex;
            Map sourceData = (Map)sourceDataList.get(index);
            if (!Objects.equals(sourceData.get("isvirtualorg"), Boolean.TRUE)) continue;
            Optional.ofNullable(sourceData.get("number")).map(Object::toString).ifPresent(number -> {
                if (!this.isSpecialNumber((String)number) && !this.virtualOrgNumberSet.add((String)number)) {
                    String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u5728\u672c\u6a21\u677f\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StructOrgDetailPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[0]), number);
                    initImportDataEventArgs.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), Integer.valueOf(0), errorMsg);
                }
            });
        }
    }

    public void afterImportData(ImportDataEventArgs eventArgs) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Map sourceData = eventArgs.getSourceData();
        this.setNull(sourceData, dataEntity, "parentorg");
        if (!Objects.equals(sourceData.get("isvirtualorg"), Boolean.TRUE)) {
            this.setNull(sourceData, dataEntity, "bsed");
        } else {
            this.setNull(sourceData, dataEntity, "org");
        }
        if (this.isSpecialNumber(dataEntity.getString("number"))) {
            dataEntity.set("number", null);
        }
    }

    private void setNull(Map<String, Object> sourceData, DynamicObject dataEntity, String field) {
        Object value = sourceData.get(field);
        if (Objects.isNull(value)) {
            dataEntity.set(field, null);
        }
    }

    private boolean isSpecialNumber(String number) {
        return HRStringUtils.equals((String)"NULL", (String)number);
    }
}

