/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.utils.msg.BaseMessage;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.org.model.OrgTreeSearchParam;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.util.tree.TreeAssistUtils;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class StructTreeView {
    protected static final String EMPTY = "";
    protected final TreeView treeView;
    protected final IPageCache pageCache;
    protected TreeNode rootNode;

    public StructTreeView(TreeView treeView, boolean isInitTree) {
        this.treeView = treeView;
        this.pageCache = treeView.getView().getPageCache();
        if (!isInitTree) {
            this.initRootNodeFromCache();
        }
    }

    public void initTree() {
        this.rootNode = this.initRootNode();
        if (this.rootNode != null) {
            this.rootNode.setParentid(EMPTY);
            this.rootNode.setIsOpened(true);
        }
        this.treeView.addNode(this.rootNode);
        this.updateRootNodeCache();
    }

    public void search(String searchText) {
        OrgTreeSearchParam orgTreeSearchParam = new OrgTreeSearchParam(searchText, this.treeView.getView(), this.treeView, this.rootNode, 0L);
        this.searchFromLazyOrgTree(String.valueOf(this.getStructProjectId()), orgTreeSearchParam, searchText);
    }

    protected List<OtherStructVO> getAllOtherStructList(Map<String, TreeNode> allTargetNodeMap) {
        this.getAllNodesMap(allTargetNodeMap, this.rootNode);
        return allTargetNodeMap.values().stream().map(node -> new OtherStructVO(Long.valueOf(node.getId()), ChangeTransactionConstants.ADD, EMPTY.equals(node.getParentid()) ? null : Long.valueOf(node.getParentid()), !node.isDisabled())).collect(Collectors.toList());
    }

    protected abstract String getOrderBys();

    protected abstract String structSelectFields();

    protected abstract String orgSelectFields();

    protected QFilter getOtherQFilter() {
        return null;
    }

    public TreeView getTreeView() {
        return this.treeView;
    }

    public TreeNode getRootNode() {
        return this.rootNode;
    }

    protected TreeNode initRootNode() {
        AuthorizedOrgResultWithSub resultWithSub = this.getPermOrgResultWithSub();
        if (resultWithSub.isHasAllOrgPerm()) {
            DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), null, this.getOtherQFilter(), this.getOrderBys());
            return this.buildTreeNode(col, null);
        }
        return this.buildPermTreeNode(resultWithSub);
    }

    protected void setNodeValue(TreeNode node, DynamicObject dy) {
        node.setText(dy.getString("name"));
        this.setLabelPara(node, dy.getString("enable"), dy.getString("tobedisableflag"));
    }

    protected void setExtendResultMap(DynamicObjectCollection col) {
    }

    protected TreeNode buildTreeNodeByDy(DynamicObject dy) {
        TreeNode node = new TreeNode(dy.getLong("parentorg") == 0L ? EMPTY : dy.getString("parentorg"), dy.getString("id"), EMPTY);
        node.setLongNumber(dy.getString("structlongnumber"));
        this.setNodeValue(node, dy);
        return node;
    }

    protected void updateRootNodeCache() {
        List<OtherStructVO> allOtherStructList = this.getAllOtherStructList(new LinkedHashMap<String, TreeNode>(16));
        this.put(this.getRootNodeKey(), allOtherStructList);
    }

    private void initRootNodeFromCache() {
        if (this.rootNode != null) {
            return;
        }
        String rootNodeCache = this.pageCache.get(this.getRootNodeKey());
        if (HRStringUtils.isEmpty((String)rootNodeCache)) {
            return;
        }
        List structList = SerializationUtils.fromJsonStringToList((String)rootNodeCache, OtherStructVO.class);
        if (CollectionUtils.isEmpty((Collection)structList)) {
            return;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(structList.size());
        Map<String, TreeNode> nodeMap = structList.stream().map(structVO -> {
            orgIdSet.add(structVO.getOrgId());
            TreeNode node = new TreeNode(structVO.getParentId() == null ? EMPTY : String.valueOf(structVO.getParentId()), String.valueOf(structVO.getOrgId()), EMPTY);
            node.setDisabled(!structVO.isPermFlag());
            return node;
        }).collect(Collectors.toMap(TreeNode::getId, node -> node));
        DynamicObjectCollection orgDys = this.queryOriginalColByPks(this.orgSelectFields(), orgIdSet);
        Map<Long, DynamicObject> orgMap = orgDys.stream().collect(Collectors.toMap(orgDy -> orgDy.getLong("id"), orgDy -> orgDy));
        this.setExtendResultMap(orgDys);
        for (OtherStructVO otherStructVO : structList) {
            TreeNode node2 = nodeMap.get(String.valueOf(otherStructVO.getOrgId()));
            this.setNodeValue(node2, orgMap.get(otherStructVO.getOrgId()));
            TreeNode parentNode = nodeMap.get(node2.getParentid());
            if (parentNode != null) {
                parentNode.addChild(node2);
                continue;
            }
            if (this.rootNode != null) continue;
            this.rootNode = node2;
        }
    }

    protected String getRootNodeKey() {
        return "ROOT_NODE_" + this.treeView.getKey();
    }

    protected void put(String key, Object cache) {
        if (cache == null) {
            this.pageCache.remove(key);
        } else {
            this.pageCache.put(key, SerializationUtils.toJsonString((Object)cache));
        }
    }

    protected TreeNode buildTreeNode(DynamicObjectCollection col, Set<String> permStructSet) {
        if (CollectionUtils.isEmpty((Collection)col)) {
            return this.defaultRootNode();
        }
        this.setExtendResultMap(col);
        TreeNode rootNode = null;
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(col.size());
        for (int index = 0; index < col.size(); ++index) {
            DynamicObject dy = (DynamicObject)col.get(index);
            TreeNode node = this.buildTreeNodeByDy(dy);
            if (permStructSet != null && !permStructSet.contains(dy.getString("structlongnumber"))) {
                node.setDisabled(true);
            }
            if (index == 0) {
                rootNode = node;
                nodeMap.put(rootNode.getId(), rootNode);
                continue;
            }
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
            nodeMap.put(node.getId(), node);
        }
        return rootNode;
    }

    private Set<String> getPermStructSet(AuthorizedOrgResultWithSub permissionModel) {
        QFilter permFilter = TreeTemplateHelper.getPermStructLongNumberFilter((AuthorizedOrgResultWithSub)permissionModel, (String)"adminorg.id");
        if (permFilter == null) {
            return new HashSet<String>(0);
        }
        DynamicObjectCollection col = this.queryValidColByStructProject("structlongnumber", this.getStructProjectId(), permFilter, this.getOtherQFilter(), null);
        return col.stream().map(dy -> dy.getString("structlongnumber")).collect(Collectors.toSet());
    }

    protected TreeNode buildPermTreeNode(AuthorizedOrgResultWithSub permissionModel) {
        Set<String> permStructSet = this.getPermStructSet(permissionModel);
        String minStructLongNumber = TreeAssistUtils.getCommonPrefixStructLongNumber(new ArrayList<String>(permStructSet));
        if (HRStringUtils.isEmpty((String)minStructLongNumber)) {
            return this.defaultRootNode();
        }
        HashSet<String> allStructSet = new HashSet<String>(permStructSet.size());
        int index = minStructLongNumber.lastIndexOf("!");
        allStructSet.add(index == -1 ? minStructLongNumber : minStructLongNumber.substring(index + 1));
        permStructSet.forEach(struct -> {
            if ((struct = struct.replace(minStructLongNumber, EMPTY)).contains("!")) {
                allStructSet.addAll(Arrays.asList(struct.split("!")));
            }
        });
        allStructSet.remove(EMPTY);
        QFilter structLongNumberFilter = new QFilter("adminorg.structnumber", "in", allStructSet);
        DynamicObjectCollection col = this.queryValidColByStructProject(this.structSelectFields(), this.getStructProjectId(), structLongNumberFilter, this.getOtherQFilter(), this.getOrderBys());
        return this.buildTreeNode(col, permStructSet);
    }

    protected abstract AuthorizedOrgResultWithSub getPermOrgResultWithSub();

    protected abstract Long getStructProjectId();

    protected TreeNode defaultRootNode() {
        return null;
    }

    protected void setLabelPara(TreeNode node, String enable, String tobeDisableFlag) {
        node.getLabelPara().clear();
        ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
        node.setLabelShowType(1);
        if ("0".equals(enable)) {
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AdminOrgTreeListTemplate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
        } else if (HRStringUtils.equals((String)"true", (String)tobeDisableFlag)) {
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5f85\u505c\u7528", (String)"AdminOrgTreeListTemplate_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#FF991C");
            labelParaList.add(treeNodeLabel);
        }
        if (!CollectionUtils.isEmpty(labelParaList)) {
            node.setLabelPara(labelParaList);
        }
    }

    protected void searchFromLazyOrgTree(String structProjectIdStr, OrgTreeSearchParam searchParam, String searchText) {
        if (HRStringUtils.isEmpty((String)searchText)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (searchParam.getRootNode() == null) {
            return;
        }
        IFormView formView = searchParam.getTreeView().getView();
        List treeNodes = null;
        IPageCache pageCache = formView.getPageCache();
        if (!structProjectIdStr.equals(pageCache.get("_oldSearchViewSchema"))) {
            this.removeAllSearchTreeNodeCache(pageCache);
        }
        pageCache.put("_oldSearchViewSchema", structProjectIdStr);
        String oldSearchText = pageCache.get("_oldSearchText");
        pageCache.put("_oldSearchText", searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get("_searchNodes");
            if (HRStringUtils.isNotEmpty((String)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            pageCache.remove("_searchNodes");
            treeNodes = this.searchTreeNode(rootNode, searchText);
            if (this.finishSearch(searchParam, treeNodes, true)) {
                return;
            }
            pageCache.put("_resultTotalCacheKey", Integer.toString(treeNodes.size()));
        }
        if (CollectionUtils.isEmpty(treeNodes)) {
            this.finishSearch(searchParam, treeNodes, false);
        } else {
            this.searchFromLazyOrgTree(searchParam, treeNodes);
        }
    }

    private void removeAllSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
        pageCache.remove("_oldSearchText");
        pageCache.remove("_oldSearchViewSchema");
        pageCache.remove("_resultTotalCacheKey");
    }

    private void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (treeNodes == null || treeNodes.size() == 0) {
            return;
        }
        IPageCache pageCache = searchParam.getPageCache();
        String resultTotal = pageCache.get("_resultTotalCacheKey");
        boolean firstTimeCheck = HRStringUtils.isNotEmpty((String)resultTotal) && Integer.parseInt(resultTotal) == treeNodes.size();
        TreeView treeView = searchParam.getTreeView();
        TreeNode node = this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        if (node == null) {
            this.finishSearch(searchParam, treeNodes, firstTimeCheck);
        } else {
            searchParam.getTreeView().focusNode(node);
            treeView.unCheckNodeWithoutChild(node.getId());
            if (!CollectionUtils.isEmpty(treeNodes)) {
                treeNodes.remove(0);
            }
        }
        pageCache.put("_searchNodes", SerializationUtils.toJsonString(treeNodes));
    }

    private boolean finishSearch(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        searchParam.getPageCache().put("_searchNodes", EMPTY);
        searchParam.getPageCache().remove("_oldSearchText");
        if (noResult) {
            searchParam.getFormView().showTipNotification(BaseMessage.getMessage((String)"M00030"));
        } else {
            searchParam.getFormView().showSuccessNotification(BaseMessage.getMessage((String)"M00029"));
        }
        TreeView treeView = searchParam.getTreeView();
        TreeNode rootNode = searchParam.getRootNode();
        if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
            treeView.focusNode(rootNode);
            treeView.unCheckNodeWithoutChild(rootNode.getId());
        }
        return true;
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)parentId);
        if (this.isChildNode(parentNode, node)) {
            ArrayList<String> loopController = new ArrayList<String>();
            ArrayList<TreeNode> unExpendNodes = new ArrayList<TreeNode>();
            this.expandParentNode(searchParam, parentId, loopController, unExpendNodes);
            for (TreeNode treeNode : unExpendNodes) {
                if (searchParam.isQueryBeforeExpend()) {
                    searchParam.getTreeView().queryTreeNodeChildren(treeNode.getParentid(), treeNode.getId());
                }
                this.expandNode(searchParam.getTreeView(), treeNode);
            }
        }
        node = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)node.getId());
        return node;
    }

    private boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode == null || CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            return false;
        }
        for (TreeNode child : parentNode.getChildren()) {
            if (!node.getId().equals(child.getId())) continue;
            return true;
        }
        return false;
    }

    private void expandParentNode(OrgTreeSearchParam searchParam, String nodeId, List<String> loopController, List<TreeNode> unExpendNodes) {
        if (searchParam == null || HRStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        if (loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            if (unExpendNodes == null) {
                this.expandNode(searchParam.getTreeView(), treeNode);
            } else {
                unExpendNodes.add(0, treeNode);
            }
            this.expandParentNode(searchParam, treeNode.getParentid(), loopController, unExpendNodes);
        }
    }

    private void expandNode(TreeView treeView, TreeNode treeNode) {
        treeView.expand(treeNode.getId());
        treeNode.setExpend(true);
    }

    private List<TreeNode> searchTreeNode(TreeNode rootNode, String searchText) {
        LinkedHashMap<String, TreeNode> map = new LinkedHashMap<String, TreeNode>(16);
        this.getAllNodesMap(map, rootNode);
        return map.values().stream().filter(node -> node.getText().contains(searchText)).map(node -> new TreeNode(node.getParentid(), node.getId(), node.getText())).collect(Collectors.toList());
    }

    protected void getAllNodesMap(Map<String, TreeNode> nodesMap, TreeNode node) {
        if (node == null) {
            return;
        }
        nodesMap.put(node.getId(), node);
        if (node.getChildren() == null) {
            return;
        }
        Iterator iterator = node.getChildren().iterator();
        while (iterator.hasNext()) {
            TreeNode childNode = (TreeNode)iterator.next();
            if (nodesMap.containsKey(childNode.getId())) {
                iterator.remove();
                continue;
            }
            this.getAllNodesMap(nodesMap, childNode);
        }
    }

    protected DynamicObjectCollection queryValidColByStructProject(String selectFields, Long structProjectId, QFilter permQFilter, QFilter otherQFilter, String orderBys) {
        return AdminOrgStructRepository.getInstance().queryValidColByStructProject(selectFields, structProjectId, permQFilter, otherQFilter, orderBys);
    }

    protected DynamicObjectCollection queryOriginalColByPks(String selectFields, Collection<Long> pks) {
        return AdOrgRepository.getInstance().queryOriginalColByPks(selectFields, pks);
    }
}

