/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.formplugin.web.structproject;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.servicehelper.AdminOrgCodeRuleServiceHelper;
import kd.hr.haos.business.servicehelper.VirtualOrgHelper;
import kd.hr.haos.business.util.NameSeparatorTipsUtil;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.business.util.PatternUtil;
import kd.hr.haos.formplugin.web.structproject.OtherStructTreeView;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class VirtualOrgPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String CLOSE_CONFIRM = "close_confirm";
    private LocaleStringComparator localeStringComparator;
    private static final String MODIFY_NUMBER = "modifynumber";

    public void registerListener(EventObject event) {
        BasedataEdit parentEdit = (BasedataEdit)this.getView().getControl("parentorg");
        parentEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgEdit = (BasedataEdit)this.getView().getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObject parentDy = this.getView().getParentView().getModel().getDataEntity(true);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String orgIdStr = (String)formShowParameter.getCustomParam("orgid");
        String parentIdStr = (String)formShowParameter.getCustomParam("parentorg");
        this.getModel().beginInit();
        if ("".equals(parentIdStr)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"parentorg"});
            BasedataEdit parentEdit = (BasedataEdit)this.getControl("parentorg");
            parentEdit.setMustInput(false);
        } else {
            Long parentId = Long.valueOf(parentIdStr);
            this.getModel().setValue("parentorg", (Object)parentId);
            DynamicObject parentOrgDy = this.getModel().getDataEntity().getDynamicObject("parentorg");
            if (HRStringUtils.isEmpty((String)orgIdStr)) {
                this.getModel().setValue("org", parentOrgDy.get("org"));
            }
            this.setParentLongName(parentId);
        }
        if (!HRStringUtils.isEmpty((String)orgIdStr)) {
            long orgId = Long.parseLong(orgIdStr);
            this.getModel().setValue("orgid", (Object)orgId);
            this.getModel().setValue("adminorg", (Object)orgId);
            DynamicObject orgDy = this.getModel().getDataEntity().getDynamicObject("adminorg");
            DynamicObjectCollection col = parentDy.getDynamicObjectCollection("entryentity");
            DynamicObject modifyDy = col.stream().filter(dy -> dy.getLong("orgid") == orgId).findFirst().orElse(orgDy);
            this.getModel().setValue("number", modifyDy.get("number"));
            this.getModel().setValue("name", modifyDy.get("name"));
            this.getModel().setValue("description", modifyDy.get("description"));
            this.getModel().setValue("org", modifyDy.get("org"));
        }
        this.setNumber();
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject orgDy;
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"btnsave")) {
            return;
        }
        DynamicObject currentDy = this.getModel().getDataEntity();
        DynamicObject parentDy = currentDy.getDynamicObject("parentorg");
        if (parentDy != null) {
            currentDy.set("org", parentDy.get("org"));
        }
        if ((orgDy = currentDy.getDynamicObject("adminorg")) == null || orgDy.getBoolean("isvirtualorg")) {
            ArrayList<String> errorMsgList = new ArrayList<String>(10);
            this.checkName(errorMsgList, currentDy);
            this.checkNumber(errorMsgList, currentDy);
            if (!CollectionUtils.isEmpty(errorMsgList)) {
                errorMsgList.forEach(item -> this.getView().showTipNotification(item));
                args.setCancel(true);
            }
        }
    }

    private void checkName(List<String> errorMsgList, DynamicObject currentDy) {
        ILocaleString localeString = currentDy.getLocaleString("name");
        List enabledLangList = this.getLocaleStringComparator().getEnabledLangList();
        PatternUtil patternUtil = new PatternUtil();
        NameSeparatorTipsUtil nameSeparatorTipsUtil = new NameSeparatorTipsUtil();
        for (EnabledLang enabledLang : enabledLangList) {
            String name = (String)localeString.get((Object)enabledLang.getNumber());
            if (!HRStringUtils.isNotEmpty((String)name) || !patternUtil.validName4Config(name)) continue;
            String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c{0}\u201d\u540d\u79f0\u201c{1}\u201d\u540d\u79f0\u4e0d\u5141\u8bb8\u6709\u7279\u6b8a\u7684\u5206\u9694\u7b26({2})\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgPlugin_1", (String)"hrmp-haos-formplugin", (Object[])new Object[]{enabledLang.getName(), name, nameSeparatorTipsUtil.getAllSeparator()});
            errorMsgList.add(message);
        }
    }

    private void checkNumber(List<String> errorMsgList, DynamicObject currentDy) {
        Set set;
        String number = currentDy.getString("number");
        if (HRStringUtils.isEmpty((String)number)) {
            return;
        }
        String message = ResManager.loadKDString((String)"\u6709\u76f8\u540c\u7ec4\u7ec7\u7f16\u7801\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgPlugin_0", (String)"hrmp-haos-formplugin", (Object[])new Object[0]);
        long orgId = currentDy.getLong("orgid");
        DynamicObjectCollection col = this.getView().getParentView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        boolean numberExits = col.stream().anyMatch(dy -> dy.getLong("orgid") != orgId && dy.getString("number").equals(number));
        if (numberExits) {
            errorMsgList.add(message);
            return;
        }
        Set<String> numberSet = Collections.singleton(number);
        Set<Long> idSet = Collections.singleton(orgId);
        DynamicObjectCollection dyCol = AdOrgRepository.getInstance().queryColByNumber("number", numberSet, idSet);
        if (!CollectionUtils.isEmpty((Collection)dyCol)) {
            errorMsgList.add(message);
        }
        if (!CollectionUtils.isEmpty((Collection)(set = VirtualOrgHelper.checkProcessNumber(numberSet)))) {
            String processMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u5728\u9014\u7ec4\u7ec7\u8c03\u6574\u5355\u636e\u201c{0}\u201d\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"VirtualOrgPlugin_3", (String)"hrmp-haos-formplugin", (Object[])new Object[]{set.stream().findFirst().orElse(null)});
            errorMsgList.add(processMsg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)"btnsave")) {
            return;
        }
        this.getModel().setDataChanged(false);
        this.getView().returnDataToParent((Object)this.getModel().getDataEntity());
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String fieldKey = event.getProperty().getName();
        if ("parentorg".equals(fieldKey)) {
            OtherStructTreeView otherTreeView = this.getOtherStructTreeView(false);
            HashSet<String> nodeIdSet = new HashSet<String>(16);
            String currentOrgId = this.getModel().getDataEntity().getString("orgid");
            otherTreeView.fillNodeSetNoContainsIdAndChild(nodeIdSet, otherTreeView.getRootNode(), currentOrgId);
            QFilter qFilter = new QFilter("id", "in", nodeIdSet.stream().map(Long::valueOf).collect(Collectors.toSet()));
            event.getCustomQFilters().add(qFilter);
            ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
            formShowParameter.setShowApproved(false);
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7", (String)"VirtualOrgPlugin_2", (String)"hrmp-haos-formplugin", (Object[])new Object[0]));
        } else if ("org".equals(fieldKey)) {
            event.getCustomQFilters().add(OrgPermHelper.getHrPermFilter((String)"haos_structproject", (String)"id"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey.equals("parentorg")) {
            DynamicObject parentDy = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (parentDy == null) {
                return;
            }
            this.setParentLongName(parentDy.getLong("id"));
        } else if ("number".equals(fieldKey)) {
            this.getModel().setValue(MODIFY_NUMBER, (Object)this.getModel().getDataEntity().getString("number"));
        }
    }

    private void setParentLongName(Long parentId) {
        if (parentId == null || parentId == 0L) {
            return;
        }
        this.getModel().setValue("parentorg_name", (Object)this.getOtherStructTreeView(true).getCurrentLongName(String.valueOf(parentId)));
    }

    private OtherStructTreeView getOtherStructTreeView(boolean isInitTree) {
        return new OtherStructTreeView((TreeView)this.getView().getParentView().getControl("other_tree"), isInitTree);
    }

    private LocaleStringComparator getLocaleStringComparator() {
        if (this.localeStringComparator == null) {
            this.localeStringComparator = new LocaleStringComparator();
        }
        return this.localeStringComparator;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if ("1".equals(this.getView().getPageCache().get(CLOSE_CONFIRM))) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, null);
            return;
        }
        if (this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CLOSE_CONFIRM, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"BillView_0", (String)"bos-form-mvc", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"BillView_1", (String)"bos-form-mvc", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"HRBaseDataCommonBillEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), this.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CLOSE_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, "1");
            this.getView().close();
        }
    }

    private void setNumber() {
        DynamicObject adminOrgDy = this.getModel().getDataEntity().getDynamicObject("adminorg");
        if (adminOrgDy != null && !HRStringUtils.equals((String)adminOrgDy.getString("datastatus"), (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
            return;
        }
        AdminOrgCodeRuleServiceHelper.create((IFormView)this.getView(), (IDataModel)this.getModel()).setOrgNumber(this.getHrDy(this.getModel().getDataEntity()), "number");
    }

    private DynamicObject getHrDy(DynamicObject addDy) {
        DynamicObject hrDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_adminorghr"));
        HRDynamicObjectUtils.copy((DynamicObject)addDy, (DynamicObject)hrDy);
        return hrDy;
    }
}

