/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.common.util;

import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;

public class FatalErrorMessageUtil {
    private static final String PAGE_FORMID = "bos_operationresult";
    private static final String KEY_TITLE = "title";
    private static final String KEY_ERRORMSG = "errorMsg";
    private static final String KEY_HASMORE = "hasMore";
    private static final String KEY_OPERATENAME = "operateName";
    private static final String APPID = "hbjm";

    public static String buildErrorMsg(List<String> errorMsgs) {
        StringBuilder result = new StringBuilder("<div style='overflow:auto;word-wrap:break-word;word-break:break-all;width:100%'>");
        for (String errorMsg : errorMsgs) {
            result.append(errorMsg).append("<br/>");
        }
        result.append("</div>");
        return result.toString();
    }

    public static void showFatalErrorMessage(String title, String errorMsg, String operateName, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(PAGE_FORMID);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.setCustomParam(KEY_TITLE, (Object)title);
        formShowParameter.setCustomParam(KEY_ERRORMSG, (Object)errorMsg);
        formShowParameter.setCustomParam(KEY_HASMORE, (Object)Boolean.FALSE);
        formShowParameter.setCustomParam(KEY_OPERATENAME, (Object)operateName);
        formShowParameter.setAppId(APPID);
        formShowParameter.setShowTitle(false);
        view.showForm(formShowParameter);
        view.sendFormAction(view);
    }
}

