/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.cascadedata;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hrmp.hbjm.business.cascadedata.CompareEntity;

public class CascadeDataValideService
implements AutoCloseable {
    private static final Log LOG = LogFactory.getLog(CascadeDataValideService.class);
    private CompareEntity entity;

    public CascadeDataValideService(CompareEntity entity) {
        this.entity = entity;
    }

    public CascadeDataValideService initData() {
        Optional.ofNullable(this.entity).ifPresent(entity -> this.entity.initData());
        return this;
    }

    public boolean compare(String mainCompareValue, String subCompareValue) {
        if (this.entity == null) {
            throw new RuntimeException("params can not be null");
        }
        if (ObjectUtils.isEmpty((Object)mainCompareValue)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)subCompareValue)) {
            return true;
        }
        this.entity.setValue(mainCompareValue);
        this.entity.setCompareValue(subCompareValue);
        return this.valideDatas();
    }

    protected boolean valideDatas() {
        Map<String, DynamicObject> mainMap = this.entity.getDataContainer();
        if (mainMap == null || mainMap.size() <= 0) {
            return false;
        }
        return mainMap.containsKey(this.entity.getValue() + this.entity.CON_SYMBOL + this.entity.getCompareValue());
    }

    @Override
    public void close() throws KDException {
        LOG.info("\u3000CascadeDataValideService\u3000\u3000close\u3000start\u3000\u91ca\u653e\u8d44\u6e90\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        Optional.ofNullable(this.entity).ifPresent(entity -> {
            entity.setDataContainer(null);
            this.entity = null;
        });
        LOG.info("\u3000CascadeDataValideService\u3000\u3000close\u3000end\u3000\u91ca\u653e\u8d44\u6e90\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
    }

    public CompareEntity getEntity() {
        return this.entity;
    }
}

