/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.cascadedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public final class CompareEntity {
    public String CON_SYMBOL = "!!";
    private String relactionCol;
    private String compareCol;
    private String value;
    private String compareValue;
    private boolean isfromDb = false;
    private String entityCode;
    private QFilter[] qFilters;
    private String selectExtProps;
    private Map<String, DynamicObject> dataContainer;

    public CompareEntity(String relactionCol, String compareCol, String compareValue, boolean isfromDb, String entityCode, QFilter[] qFilters, Map<String, DynamicObject> dataContainer) {
        this.relactionCol = relactionCol;
        this.compareCol = compareCol;
        this.compareValue = compareValue;
        this.isfromDb = isfromDb;
        this.entityCode = entityCode;
        this.qFilters = qFilters;
        this.dataContainer = dataContainer;
    }

    public static CompareEntity newInstance(String relactionCol, String compareCol, String compareValue, Map<String, DynamicObject> dataContainer) {
        return new CompareEntity(relactionCol, compareCol, compareValue, false, null, null, dataContainer);
    }

    public static CompareEntity newInstanceFromDb(String relactionCol, String compareCol, String compareValue, String entityCode, QFilter[] qFilters) {
        return new CompareEntity(relactionCol, compareCol, compareValue, true, entityCode, qFilters, null);
    }

    public void initData() {
        Map<Object, Object> map = this.dataContainer = ObjectUtils.isEmpty(this.dataContainer) ? new HashMap() : this.dataContainer;
        if (!this.isfromDb) {
            return;
        }
        String selectProps = this.relactionCol + "," + this.compareCol;
        if (HRStringUtils.isNotEmpty((String)this.selectExtProps)) {
            selectProps = selectProps + "," + this.selectExtProps;
        }
        String finalSelectProps = selectProps;
        Optional.ofNullable(this.entityCode).ifPresent(code -> {
            HRBaseServiceHelper dataHelper = new HRBaseServiceHelper(code);
            DynamicObject[] results = dataHelper.query(finalSelectProps, this.qFilters);
            Optional.ofNullable(results).ifPresent(datas -> {
                this.dataContainer = new HashMap<String, DynamicObject>();
                Arrays.stream(datas).forEach(data -> this.dataContainer.put(data.getString(this.relactionCol) + this.CON_SYMBOL + data.getString(this.compareCol), (DynamicObject)data));
            });
        });
    }

    public String getRelactionCol() {
        return this.relactionCol;
    }

    public String getCompareCol() {
        return this.compareCol;
    }

    public boolean isIsfromDb() {
        return this.isfromDb;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public QFilter[] getQFilters() {
        return this.qFilters;
    }

    public void setEntityCode(String entityCode) {
        this.entityCode = entityCode;
    }

    public void setQFilters(QFilter[] qFilters) {
        this.qFilters = qFilters;
    }

    public void addQFilters(QFilter[] qFilters) {
        this.qFilters = (QFilter[])ArrayUtils.add((Object[])qFilters, QFilter.class);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getCompareValue() {
        return this.compareValue;
    }

    public void setCompareValue(String compareValue) {
        this.compareValue = compareValue;
    }

    public Map<String, DynamicObject> getDataContainer() {
        return this.dataContainer;
    }

    public void setDataContainer(Map<String, DynamicObject> dataContainer) {
        this.dataContainer = dataContainer;
    }

    public void setSelectExtProps(String selectExtProps) {
        this.selectExtProps = selectExtProps;
    }
}

