/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hbjm.business.domain.application.impl.job;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hbjm.business.domain.application.job.IJobApplication;
import kd.hrmp.hbjm.business.domain.repository.HBJMEventRepository;
import kd.hrmp.hbjm.business.domain.repository.JobRepository;
import kd.hrmp.hbjm.business.domain.service.impl.JobServiceImpl;
import kd.hrmp.hbjm.business.model.JobChangeInfoModel;
import kd.hrmp.hbjm.business.utils.JobDynamicObjectUtils;
import kd.hrmp.hbjm.business.utils.model.JobDisableModel;

public class JobApplicationImpl
implements IJobApplication {
    private static final Log LOGGER = LogFactory.getLog(JobApplicationImpl.class);
    protected static ThreadLocal<Map<String, Map<String, IDataEntityProperty>>> dynamicObjectContainer = ThreadLocal.withInitial(() -> new HashMap());

    @Override
    public DynamicObject dealGradeOrLevelImportToNull(Map<String, Object> sourceData, DynamicObject viewData) {
        if (ObjectUtils.isEmpty(sourceData)) {
            return viewData;
        }
        String entityCode = viewData.getDataEntityType().getName();
        Map props = Optional.ofNullable(dynamicObjectContainer.get().get(entityCode)).orElseGet(() -> {
            Map<String, IDataEntityProperty> infos = JobDynamicObjectUtils.getNoDbCol(viewData);
            dynamicObjectContainer.get().put(entityCode, infos);
            return infos;
        });
        if (ObjectUtils.isEmpty((Object)props)) {
            return viewData;
        }
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            Object data = sourceData.get(key);
            if (!sourceData.containsKey(key)) continue;
            this.changeViewData(key, (IDataEntityProperty)entry.getValue(), data, viewData);
        }
        return viewData;
    }

    @Override
    public DynamicObject dealChangeReasonImportToNull(Map<String, Object> sourceData, DynamicObject viewData) {
        if (ObjectUtils.isEmpty(sourceData)) {
            return viewData;
        }
        if (!sourceData.containsKey("changedesc")) {
            viewData.set("changedesc", null);
        }
        if (!sourceData.containsKey("changedesc2")) {
            viewData.set("changedesc2", null);
        }
        return viewData;
    }

    @Override
    public Map<Long, List<JobChangeInfoModel>> getAllChangeInfoByBoids(Set<Long> boids) {
        if (ObjectUtils.isEmpty(boids)) {
            return null;
        }
        Object[] jobhis = JobRepository.getInstance().findJobsChangeHis(boids);
        if (ObjectUtils.isEmpty((Object[])jobhis)) {
            return null;
        }
        Map<Object, Object> opsMap = new HashMap();
        Map<Object, Object> eventsMap = new HashMap();
        Object[] ops = HBJMEventRepository.getInstance().selectOpDetailByBoIds(boids);
        Object[] eventDetails = null;
        if (!ObjectUtils.isEmpty((Object[])ops)) {
            opsMap = Arrays.stream(ops).collect(Collectors.toMap(op -> op.getLong("afterjob"), vv -> vv, (v1, v2) -> v2));
            Set<Long> eventIds = Arrays.stream(ops).map(op -> op.getLong("event")).collect(Collectors.toSet());
            eventDetails = HBJMEventRepository.getInstance().selectEventDetails(eventIds);
            if (!ObjectUtils.isEmpty((Object[])eventDetails)) {
                eventsMap = Arrays.stream(eventDetails).collect(Collectors.toMap(op -> op.getLong("event"), vv -> vv, (v1, v2) -> v2));
            }
        }
        ArrayList<JobChangeInfoModel> resultTmp = new ArrayList<JobChangeInfoModel>(jobhis.length);
        for (Object his : jobhis) {
            Long id;
            DynamicObject opDetail;
            JobChangeInfoModel model = new JobChangeInfoModel();
            model.setBoid(his.getLong("boid"));
            model.setDataId(his.getLong("id"));
            model.setJobHis((DynamicObject)his);
            if (!ObjectUtils.isEmpty(opsMap) && !ObjectUtils.isEmpty((Object)(opDetail = (DynamicObject)opsMap.get(id = Long.valueOf(his.getLong("id")))))) {
                DynamicObject aaa;
                model.setOpDetail(opDetail);
                Long eventId = opDetail.getLong("event");
                if (!ObjectUtils.isEmpty(eventsMap) && (aaa = (DynamicObject)eventsMap.get(eventId)) != null) {
                    model.setEventDetail(aaa);
                }
            }
            resultTmp.add(model);
        }
        Map<Long, List<JobChangeInfoModel>> result = resultTmp.stream().collect(Collectors.groupingBy(JobChangeInfoModel::getBoid));
        return result;
    }

    private void changeViewData(String key, IDataEntityProperty prop, Object source, DynamicObject viewData) {
        if (prop instanceof MuliLangTextProp) {
            Map data = (Map)source;
            ILocaleString dataresult = viewData.getLocaleString("key");
            for (Map.Entry entry : data.entrySet()) {
                String kk = (String)entry.getKey();
                Object val = entry.getValue();
                if (val != null) continue;
                dataresult.setItem(kk, (Object)"NULL");
            }
            viewData.set(key, (Object)dataresult);
        } else if (prop instanceof TextProp && source == null) {
            viewData.set(key, (Object)"NULL");
        }
    }

    @Override
    public DynamicObject[] disableJob(DynamicObject[] jobs, JobDisableModel models) {
        if (!ObjectUtils.isEmpty((Object[])jobs)) {
            QFilter idFilter;
            List idList = Arrays.stream(jobs).map(job -> job.getLong("id")).collect(Collectors.toList());
            String entityNumber = jobs[0].getDataEntityType().getName();
            HRBaseServiceHelper jobHepler = new HRBaseServiceHelper(entityNumber);
            if (!ObjectUtils.isEmpty((Object[])(jobs = jobHepler.loadDynamicObjectArray(new QFilter[]{idFilter = new QFilter("id", "in", idList)})))) {
                for (DynamicObject job2 : jobs) {
                    job2.set("changedesc", (Object)(models == null ? Long.valueOf(0L) : models.getChangedesc()));
                    job2.set("changedesc2", (Object)(models == null ? "" : models.getChangedesc2()));
                    job2.set("disabledate", (Object)(models == null ? HRDateTimeUtils.getNowDate() : models.getHisDisableDate()));
                    job2.set("enable", (Object)"0");
                    job2.set("disabler", (Object)RequestContext.get().getCurrUserId());
                    job2.set("bsed", (Object)(models == null ? HRDateTimeUtils.getNowDate() : models.getHisDisableDate()));
                }
            }
            JobServiceImpl jobService = new JobServiceImpl();
            return jobService.batchHisVersionChange(jobs);
        }
        return jobs;
    }

    @Override
    public DynamicObject[] enableJob(DynamicObject[] jobs) {
        if (!ObjectUtils.isEmpty((Object[])jobs)) {
            List idList = Arrays.stream(jobs).map(job -> job.getLong("id")).collect(Collectors.toList());
            String entityNumber = jobs[0].getDataEntityType().getName();
            QFilter idFilter = new QFilter("id", "in", idList);
            HRBaseServiceHelper jobHepler = new HRBaseServiceHelper(entityNumber);
            jobs = jobHepler.loadDynamicObjectArray(new QFilter[]{idFilter});
            if (!ObjectUtils.isEmpty((Object[])jobs)) {
                for (DynamicObject job2 : jobs) {
                    job2.set("changedesc", null);
                    job2.set("changedesc2", null);
                    job2.set("enable", (Object)"1");
                }
            }
            JobServiceImpl jobService = new JobServiceImpl();
            return jobService.batchHisVersionChange(jobs);
        }
        return jobs;
    }
}

